/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openide.options.ContextSystemOption;
import org.openide.text.PrintPreferences;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class PrintSettings
extends ContextSystemOption {
    static final long serialVersionUID = -9102470021814206818L;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 0;
    public static final String PROP_PAGE_FORMAT = "pageFormat";
    public static final String PROP_WRAP = "wrap";
    public static final String PROP_HEADER_FORMAT = "headerFormat";
    public static final String PROP_FOOTER_FORMAT = "footerFormat";
    public static final String PROP_HEADER_FONT = "headerFont";
    public static final String PROP_FOOTER_FONT = "footerFont";
    public static final String PROP_HEADER_ALIGNMENT = "headerAlignment";
    public static final String PROP_FOOTER_ALIGNMENT = "footerAlignment";
    public static final String PROP_LINE_ASCENT_CORRECTION = "lineAscentCorrection";
    private static final String HELP_ID = "editing.printing";

    public String displayName() {
        return NbBundle.getMessage((Class)PrintSettings.class, (String)"CTL_Print_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public static PageFormat getPageFormat(PrinterJob printerJob) {
        return PrintPreferences.getPageFormat((PrinterJob)printerJob);
    }

    public PageFormat getPageFormat() {
        return PrintSettings.getPageFormat(PrinterJob.getPrinterJob());
    }

    public void setPageFormat(PageFormat pageFormat) {
        PrintPreferences.setPageFormat((PageFormat)pageFormat);
        this.firePropertyChange(PROP_PAGE_FORMAT, null, pageFormat);
    }

    public boolean getWrap() {
        return PrintPreferences.getWrap();
    }

    public void setWrap(boolean bl) {
        PrintPreferences.setWrap((boolean)bl);
        this.firePropertyChange(PROP_WRAP, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getHeaderFormat() {
        return PrintPreferences.getHeaderFormat();
    }

    public void setHeaderFormat(String string) {
        PrintPreferences.setHeaderFormat((String)string);
        this.firePropertyChange(PROP_HEADER_FORMAT, null, string);
    }

    public String getFooterFormat() {
        return PrintPreferences.getFooterFormat();
    }

    public void setFooterFormat(String string) {
        PrintPreferences.setFooterFormat((String)string);
        this.firePropertyChange(PROP_FOOTER_FORMAT, null, string);
    }

    public Font getHeaderFont() {
        return PrintPreferences.getHeaderFont();
    }

    public void setHeaderFont(Font font) {
        PrintPreferences.setHeaderFont((Font)font);
        this.firePropertyChange(PROP_HEADER_FONT, null, font);
    }

    public Font getFooterFont() {
        return PrintPreferences.getFooterFont();
    }

    public void setFooterFont(Font font) {
        PrintPreferences.setFooterFont((Font)font);
        this.firePropertyChange(PROP_FOOTER_FONT, null, font);
    }

    public int getHeaderAlignment() {
        return this.fromAlignment(PrintPreferences.getHeaderAlignment());
    }

    public void setHeaderAlignment(int n) {
        PrintPreferences.setHeaderAlignment((PrintPreferences.Alignment)this.toAlignment(n));
        this.firePropertyChange(PROP_HEADER_ALIGNMENT, null, new Integer(n));
    }

    private PrintPreferences.Alignment toAlignment(int n) {
        PrintPreferences.Alignment alignment = PrintPreferences.Alignment.CENTER;
        switch (n) {
            case 1: {
                alignment = PrintPreferences.Alignment.CENTER;
                break;
            }
            case 0: {
                alignment = PrintPreferences.Alignment.LEFT;
                break;
            }
            case 2: {
                alignment = PrintPreferences.Alignment.RIGHT;
            }
        }
        return alignment;
    }

    private int fromAlignment(PrintPreferences.Alignment alignment) {
        int n = 1;
        if (PrintPreferences.Alignment.CENTER.equals((Object)alignment)) {
            n = 1;
        } else if (PrintPreferences.Alignment.LEFT.equals((Object)alignment)) {
            n = 0;
        } else if (PrintPreferences.Alignment.RIGHT.equals((Object)alignment)) {
            n = 2;
        }
        return n;
    }

    public int getFooterAlignment() {
        return this.fromAlignment(PrintPreferences.getFooterAlignment());
    }

    public void setFooterAlignment(int n) {
        PrintPreferences.setFooterAlignment((PrintPreferences.Alignment)this.toAlignment(n));
        this.firePropertyChange(PROP_FOOTER_ALIGNMENT, null, new Integer(n));
    }

    public float getLineAscentCorrection() {
        return PrintPreferences.getLineAscentCorrection();
    }

    public void setLineAscentCorrection(float f) {
        PrintPreferences.setLineAscentCorrection((float)f);
        this.firePropertyChange(PROP_LINE_ASCENT_CORRECTION, null, new Float(f));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public static class AlignmentEditor
    extends PropertyEditorSupport {
        private String sCENTER;
        private String sRIGHT;
        private String sLEFT = NbBundle.getMessage((Class)(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = PrintSettings.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings), (String)"CTL_LEFT");
        private String[] tags = new String[]{this.sLEFT, this.sCENTER = NbBundle.getMessage((Class)(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = PrintSettings.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings), (String)"CTL_CENTER"), this.sRIGHT = NbBundle.getMessage((Class)(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = PrintSettings.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings), (String)"CTL_RIGHT")};

        public String[] getTags() {
            return this.tags;
        }

        public String getAsText() {
            return this.tags[(Integer)this.getValue()];
        }

        public void setAsText(String string) {
            if (string.equals(this.sLEFT)) {
                this.setValue(new Integer(0));
            } else if (string.equals(this.sCENTER)) {
                this.setValue(new Integer(1));
            } else {
                this.setValue(new Integer(2));
            }
        }
    }

    public static class PageFormatEditor
    extends PropertyEditorSupport {
        public String getAsText() {
            return null;
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            PageFormat pageFormat = (PageFormat)this.getValue();
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
            ((PrintSettings)PrintSettings.findObject((Class)(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = PrintSettings.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings))).setPageFormat((PageFormat)pageFormat2.clone());
            printerJob.cancel();
            return null;
        }
    }
}

