/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.apache.batik.util.CleanerThread;

public class SoftReferenceCache {
    HashMap map = new HashMap();

    protected SoftReferenceCache() {
    }

    public synchronized void flush() {
        this.map.clear();
        this.notifyAll();
    }

    protected final synchronized boolean isPresentImpl(Object object) {
        if (!this.map.containsKey(object)) {
            return false;
        }
        Object object2 = this.map.get(object);
        if (object2 == null) {
            return true;
        }
        SoftReference softReference = (SoftReference)object2;
        if ((object2 = softReference.get()) != null) {
            return true;
        }
        this.clearImpl(object);
        return false;
    }

    protected final synchronized boolean isDoneImpl(Object object) {
        Object object2 = this.map.get(object);
        if (object2 == null) {
            return false;
        }
        SoftReference softReference = (SoftReference)object2;
        if ((object2 = softReference.get()) != null) {
            return true;
        }
        this.clearImpl(object);
        return false;
    }

    protected final synchronized Object requestImpl(Object object) {
        if (this.map.containsKey(object)) {
            SoftReference softReference;
            Object object2 = this.map.get(object);
            while (object2 == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.map.containsKey(object)) break;
                object2 = this.map.get(object);
            }
            if (object2 != null && (object2 = (softReference = (SoftReference)object2).get()) != null) {
                return object2;
            }
        }
        this.map.put(object, null);
        return null;
    }

    protected final synchronized void clearImpl(Object object) {
        this.map.remove(object);
        this.notifyAll();
    }

    protected final synchronized void putImpl(Object object, Object object2) {
        if (this.map.containsKey(object)) {
            SoftRefKey softRefKey = new SoftRefKey(object2, object);
            this.map.put(object, softRefKey);
            this.notifyAll();
        }
    }

    class SoftRefKey
    extends CleanerThread.SoftReferenceCleared {
        Object key;

        public SoftRefKey(Object object, Object object2) {
            super(object);
            this.key = object2;
        }

        public void cleared() {
            SoftReferenceCache softReferenceCache = SoftReferenceCache.this;
            if (softReferenceCache == null) {
                return;
            }
            SoftReferenceCache softReferenceCache2 = softReferenceCache;
            synchronized (softReferenceCache2) {
                Object v = softReferenceCache.map.remove(this.key);
                if (this == v) {
                    softReferenceCache.notifyAll();
                } else {
                    softReferenceCache.map.put(this.key, v);
                }
            }
        }
    }
}

