/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.Response;
import com.sun.mail.pop3.SharedByteArrayOutputStream;
import com.sun.mail.pop3.Status;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.StringTokenizer;

class Protocol {
    private Socket socket;
    private DataInputStream input;
    private PrintWriter output;
    private static final int POP3_PORT = 110;
    private static final String CRLF = "\r\n";
    private boolean debug = false;
    private PrintStream out;
    private String apopChallenge = null;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Protocol(String string, int n, boolean bl, PrintStream printStream, Properties properties, String string2, boolean bl2) throws IOException {
        Response response;
        this.debug = bl;
        this.out = printStream;
        String string3 = properties.getProperty(string2 + ".apop.enable");
        boolean bl3 = string3 != null && string3.equalsIgnoreCase("true");
        try {
            if (n == -1) {
                n = 110;
            }
            if (bl) {
                printStream.println("DEBUG POP3: connecting to host \"" + string + "\", port " + n + ", isSSL " + bl2);
            }
            this.socket = SocketFetcher.getSocket(string, n, properties, string2, bl2);
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "iso-8859-1")));
            response = this.simpleCommand(null);
        }
        catch (IOException iOException) {
            try {
                this.socket.close();
                Object var13_12 = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                throw iOException;
            }
            throw iOException;
        }
        if (!response.ok) {
            try {
                this.socket.close();
                Object var15_15 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                throw new IOException("Connect failed");
            }
            throw new IOException("Connect failed");
        }
        if (bl3) {
            int n2 = response.data.indexOf(60);
            int n3 = response.data.indexOf(62, n2);
            if (n2 != -1 && n3 != -1) {
                this.apopChallenge = response.data.substring(n2, n3 + 1);
            }
            if (bl) {
                printStream.println("DEBUG POP3: APOP challenge: " + this.apopChallenge);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.socket != null) {
            this.quit();
        }
    }

    synchronized String login(String string, String string2) throws IOException {
        Response response;
        String string3 = null;
        if (this.apopChallenge != null) {
            string3 = this.getDigest(string2);
        }
        if (this.apopChallenge != null && string3 != null) {
            response = this.simpleCommand("APOP " + string + " " + string3);
        } else {
            response = this.simpleCommand("USER " + string);
            if (!response.ok) {
                return response.data != null ? response.data : "USER command failed";
            }
            response = this.simpleCommand("PASS " + string2);
        }
        if (!response.ok) {
            return response.data != null ? response.data : "login failed";
        }
        return null;
    }

    private String getDigest(String string) {
        byte[] byArray;
        String string2 = this.apopChallenge + string;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray = messageDigest.digest(string2.getBytes("iso-8859-1"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return Protocol.toHex(byArray);
    }

    private static String toHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            int n3 = byArray[n] & 0xFF;
            cArray[n2++] = digits[n3 >> 4];
            cArray[n2++] = digits[n3 & 0xF];
            ++n;
        }
        return new String(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean quit() throws IOException {
        Object v1;
        boolean bl;
        block5: {
            bl = false;
            try {
                Response response = this.simpleCommand("QUIT");
                bl = response.ok;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var4_4 = null;
                try {
                    this.socket.close();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var6_8 = v0;
                this.socket = null;
                this.input = null;
                this.output = null;
                throw throwable;
            }
            try {
                this.socket.close();
                v1 = null;
                break block5;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var6_7 = v1;
        this.socket = null;
        this.input = null;
        this.output = null;
        return bl;
    }

    synchronized Status stat() throws IOException {
        Response response = this.simpleCommand("STAT");
        Status status = new Status();
        if (response.ok && response.data != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(response.data);
                status.total = Integer.parseInt(stringTokenizer.nextToken());
                status.size = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return status;
    }

    synchronized int list(int n) throws IOException {
        Response response = this.simpleCommand("LIST " + n);
        int n2 = -1;
        if (response.ok && response.data != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(response.data);
                stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    synchronized InputStream list() throws IOException {
        Response response = this.multilineCommand("LIST", 128);
        return response.bytes;
    }

    synchronized InputStream retr(int n, int n2) throws IOException {
        Response response = this.multilineCommand("RETR " + n, n2);
        return response.bytes;
    }

    synchronized InputStream top(int n, int n2) throws IOException {
        Response response = this.multilineCommand("TOP " + n + " " + n2, 0);
        return response.bytes;
    }

    synchronized boolean dele(int n) throws IOException {
        Response response = this.simpleCommand("DELE " + n);
        return response.ok;
    }

    synchronized String uidl(int n) throws IOException {
        Response response = this.simpleCommand("UIDL " + n);
        if (!response.ok) {
            return null;
        }
        int n2 = response.data.indexOf(32);
        if (n2 > 0) {
            return response.data.substring(n2 + 1);
        }
        return null;
    }

    synchronized boolean uidl(String[] stringArray) throws IOException {
        Response response = this.multilineCommand("UIDL", 15 * stringArray.length);
        if (!response.ok) {
            return false;
        }
        LineInputStream lineInputStream = new LineInputStream(response.bytes);
        String string = null;
        while ((string = lineInputStream.readLine()) != null) {
            int n;
            int n2 = string.indexOf(32);
            if (n2 < 1 || n2 >= string.length() || (n = Integer.parseInt(string.substring(0, n2))) <= 0 || n > stringArray.length) continue;
            stringArray[n - 1] = string.substring(n2 + 1);
        }
        return true;
    }

    synchronized boolean noop() throws IOException {
        Response response = this.simpleCommand("NOOP");
        return response.ok;
    }

    synchronized boolean rset() throws IOException {
        Response response = this.simpleCommand("RSET");
        return response.ok;
    }

    private Response simpleCommand(String string) throws IOException {
        String string2;
        if (this.socket == null) {
            throw new IOException("Folder is closed");
        }
        if (string != null) {
            if (this.debug) {
                this.out.println("C: " + string);
            }
            string = string + CRLF;
            this.output.print(string);
            this.output.flush();
        }
        if ((string2 = this.input.readLine()) == null) {
            if (this.debug) {
                this.out.println("S: EOF");
            }
            throw new EOFException("EOF on socket");
        }
        if (this.debug) {
            this.out.println("S: " + string2);
        }
        Response response = new Response();
        if (string2.startsWith("+OK")) {
            response.ok = true;
        } else if (string2.startsWith("-ERR")) {
            response.ok = false;
        } else {
            throw new IOException("Unexpected response: " + string2);
        }
        int n = string2.indexOf(32);
        if (n >= 0) {
            response.data = string2.substring(n + 1);
        }
        return response;
    }

    private Response multilineCommand(String string, int n) throws IOException {
        int n2;
        Response response = this.simpleCommand(string);
        if (!response.ok) {
            return response;
        }
        SharedByteArrayOutputStream sharedByteArrayOutputStream = new SharedByteArrayOutputStream(n);
        int n3 = 10;
        while ((n2 = this.input.read()) >= 0) {
            if (n3 == 10 && n2 == 46) {
                if (this.debug) {
                    this.out.write(n2);
                }
                if ((n2 = this.input.read()) == 13) {
                    if (this.debug) {
                        this.out.write(n2);
                    }
                    n2 = this.input.read();
                    if (!this.debug) break;
                    this.out.write(n2);
                    break;
                }
            }
            sharedByteArrayOutputStream.write(n2);
            if (this.debug) {
                this.out.write(n2);
            }
            n3 = n2;
        }
        if (n2 < 0) {
            throw new EOFException("EOF on socket");
        }
        response.bytes = sharedByteArrayOutputStream.toStream();
        return response;
    }
}

