/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.netbeans.core.output2.FileMapStorage;
import org.netbeans.core.output2.Storage;

class HeapStorage
implements Storage {
    private boolean closed = true;
    private byte[] bytes = new byte[2048];
    private int size = 0;

    HeapStorage() {
    }

    public Storage toFileMapStorage() throws IOException {
        FileMapStorage fileMapStorage = new FileMapStorage();
        fileMapStorage.write(this.getReadBuffer(0, this.size));
        return fileMapStorage;
    }

    public ByteBuffer getReadBuffer(int n, int n2) throws IOException {
        return ByteBuffer.wrap(this.bytes, n, Math.min(n2, this.bytes.length - n));
    }

    public ByteBuffer getWriteBuffer(int n) throws IOException {
        return ByteBuffer.allocate(n);
    }

    public synchronized int write(ByteBuffer byteBuffer) throws IOException {
        this.closed = false;
        int n = this.size;
        this.size += byteBuffer.limit();
        if (this.size > this.bytes.length) {
            byte[] byArray = this.bytes;
            this.bytes = new byte[Math.max(n * 2, byteBuffer.limit() * 2 + n)];
            System.arraycopy(byArray, 0, this.bytes, 0, n);
        }
        byteBuffer.flip();
        byteBuffer.get(this.bytes, n, byteBuffer.limit());
        return n;
    }

    public synchronized void dispose() {
        this.bytes = new byte[0];
        this.size = 0;
    }

    public synchronized int size() {
        return this.size;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

