/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.quicksearch.Accessor;
import org.netbeans.modules.quicksearch.CategoryResult;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandEvaluator {
    static final String RECENT = "Recent";
    private static Pattern COMMAND_PATTERN = Pattern.compile("(\\w+)(\\s+)(.+)");
    private static ProviderModel.Category evalCat;
    private static boolean isCatTemporary;

    public static Task evaluate(String string, ResultsModel resultsModel) {
        ArrayList<CategoryResult> arrayList = new ArrayList<CategoryResult>();
        String[] stringArray = CommandEvaluator.parseCommand(string);
        SearchRequest searchRequest = Accessor.DEFAULT.createRequest(stringArray[1], null);
        ArrayList<RequestProcessor.Task> arrayList2 = new ArrayList<RequestProcessor.Task>();
        ArrayList<ProviderModel.Category> arrayList3 = new ArrayList<ProviderModel.Category>();
        boolean bl = CommandEvaluator.getProviderCategories(stringArray, arrayList3);
        for (ProviderModel.Category category : arrayList3) {
            CategoryResult categoryResult = new CategoryResult(category, bl);
            SearchResponse searchResponse = Accessor.DEFAULT.createResponse(categoryResult, searchRequest);
            for (SearchProvider searchProvider : category.getProviders()) {
                RequestProcessor.Task task = CommandEvaluator.runEvaluation(searchProvider, searchRequest, searchResponse, category);
                if (task == null) continue;
                arrayList2.add(task);
            }
            arrayList.add(categoryResult);
        }
        resultsModel.setContent(arrayList);
        return new Wait4AllTask(arrayList2);
    }

    public static ProviderModel.Category getEvalCat() {
        return evalCat;
    }

    public static void setEvalCat(ProviderModel.Category category) {
        evalCat = category;
    }

    public static boolean isCatTemporary() {
        return isCatTemporary;
    }

    public static void setCatTemporary(boolean bl) {
        isCatTemporary = bl;
    }

    private static String[] parseCommand(String string) {
        String[] stringArray = new String[2];
        Matcher matcher = COMMAND_PATTERN.matcher(string);
        if (matcher.matches()) {
            stringArray[0] = matcher.group(1);
            if (ProviderModel.getInstance().isKnownCommand(stringArray[0])) {
                stringArray[1] = matcher.group(3);
            } else {
                stringArray[0] = null;
                stringArray[1] = string;
            }
        } else {
            stringArray[1] = string;
        }
        return stringArray;
    }

    private static boolean getProviderCategories(String[] stringArray, List<ProviderModel.Category> list) {
        List<ProviderModel.Category> list2 = ProviderModel.getInstance().getCategories();
        for (ProviderModel.Category category : list2) {
            if (!RECENT.equals(category.getName())) continue;
            list.add(category);
        }
        if (stringArray[1] == null || stringArray[1].trim().equals("")) {
            return false;
        }
        if (stringArray[0] != null) {
            for (ProviderModel.Category category : list2) {
                String string = category.getCommandPrefix();
                if (string == null || !string.equalsIgnoreCase(stringArray[0])) continue;
                list.add(category);
                return true;
            }
        }
        if (evalCat != null) {
            list.add(evalCat);
            return true;
        }
        list.clear();
        list.addAll(list2);
        return false;
    }

    private static RequestProcessor.Task runEvaluation(final SearchProvider searchProvider, final SearchRequest searchRequest, final SearchResponse searchResponse, ProviderModel.Category category) {
        if ("Actions".equals(category.getName())) {
            searchProvider.evaluate(searchRequest, searchResponse);
            return null;
        }
        return RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                searchProvider.evaluate(searchRequest, searchResponse);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Wait4AllTask
    extends Task
    implements Runnable {
        private static final long TIMEOUT = 60000L;
        private List<RequestProcessor.Task> tasks;

        private Wait4AllTask(List<RequestProcessor.Task> list) {
            this.tasks = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.notifyRunning();
                for (RequestProcessor.Task task : this.tasks) {
                    try {
                        task.waitFinished(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                this.notifyFinished();
            }
        }
    }
}

