/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.io.File;
import java.util.Date;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.TreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileSystemModel
implements TreeTableModel {
    protected EventListenerList listenerList;
    private static final Long ZERO = 0L;
    private File root;

    public SimpleFileSystemModel() {
        this(new File(File.separator));
    }

    public SimpleFileSystemModel(File root) {
        this.root = root;
        this.listenerList = new EventListenerList();
    }

    @Override
    public File getChild(Object parent, int index) {
        File parentFile;
        File[] files;
        if (parent instanceof File && (files = (parentFile = (File)parent).listFiles()) != null) {
            return files[index];
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        String[] children;
        if (parent instanceof File && (children = ((File)parent).list()) != null) {
            return children.length;
        }
        return 0;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Date.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Directory";
            }
            case 3: {
                return "Modification Date";
            }
        }
        return "Column " + column;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (node instanceof File) {
            File file = (File)node;
            switch (column) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return file.isFile() ? file.length() : ZERO.longValue();
                }
                case 2: {
                    return file.isDirectory();
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
        }
        return null;
    }

    @Override
    public int getHierarchicalColumn() {
        return 0;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, Object node, int column) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof File && child instanceof File) {
            File parentFile = (File)parent;
            File[] files = parentFile.listFiles();
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                if (!files[i].equals(child)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof File) {
            return ((File)node).list() == null;
        }
        return true;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }
}

