/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import javax.swing.JComponent;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.PainterAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVisuals<T extends JComponent>
implements Serializable {
    private Color unselectedForeground;
    private Color unselectedBackground;

    public void setForeground(Color c) {
        this.unselectedForeground = c;
    }

    public void setBackground(Color c) {
        this.unselectedBackground = c;
    }

    public void configureVisuals(T renderingComponent, CellContext context) {
        this.configureState(renderingComponent, context);
        this.configureColors(renderingComponent, context);
        this.configureBorder(renderingComponent, context);
        this.configurePainter(renderingComponent, context);
    }

    protected void configurePainter(T renderingComponent, CellContext context) {
        if (renderingComponent instanceof PainterAware) {
            ((PainterAware)renderingComponent).setPainter(null);
        }
    }

    protected void configureState(T renderingComponent, CellContext context) {
        ((JComponent)renderingComponent).setToolTipText(null);
        this.configureSizes(renderingComponent, context);
        if (context.getComponent() != null) {
            ((JComponent)renderingComponent).setFont(((Component)context.getComponent()).getFont());
            ((JComponent)renderingComponent).setEnabled(((Component)context.getComponent()).isEnabled());
            ((Container)renderingComponent).applyComponentOrientation(((Component)context.getComponent()).getComponentOrientation());
        }
    }

    protected void configureSizes(T renderingComponent, CellContext context) {
        ((JComponent)renderingComponent).setPreferredSize(null);
        ((JComponent)renderingComponent).setMinimumSize(null);
        ((JComponent)renderingComponent).setMaximumSize(null);
    }

    protected void configureColors(T renderingComponent, CellContext context) {
        if (context.isSelected()) {
            ((JComponent)renderingComponent).setForeground(context.getSelectionForeground());
            ((JComponent)renderingComponent).setBackground(context.getSelectionBackground());
        } else {
            ((JComponent)renderingComponent).setForeground(this.getForeground(context));
            ((JComponent)renderingComponent).setBackground(this.getBackground(context));
        }
        if (context.isFocused()) {
            this.configureFocusColors(renderingComponent, context);
        }
    }

    protected void configureFocusColors(T renderingComponent, CellContext context) {
        if (!context.isSelected() && context.isEditable()) {
            Color col = context.getFocusForeground();
            if (col != null) {
                ((JComponent)renderingComponent).setForeground(col);
            }
            if ((col = context.getFocusBackground()) != null) {
                ((JComponent)renderingComponent).setBackground(col);
            }
        }
    }

    protected void configureBorder(T renderingComponent, CellContext context) {
        ((JComponent)renderingComponent).setBorder(context.getBorder());
    }

    protected Color getForeground(CellContext context) {
        if (this.unselectedForeground != null) {
            return this.unselectedForeground;
        }
        return context.getForeground();
    }

    protected Color getBackground(CellContext context) {
        if (this.unselectedBackground != null) {
            return this.unselectedBackground;
        }
        return context.getBackground();
    }
}

