/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.image.AbstractFilter;

public class ColorTintFilter
extends AbstractFilter {
    private final Color mixColor;
    private final float mixValue;
    private int[] preMultipliedRed;
    private int[] preMultipliedGreen;
    private int[] preMultipliedBlue;

    public ColorTintFilter(Color mixColor, float mixValue) {
        if (mixColor == null) {
            throw new IllegalArgumentException("mixColor cannot be null");
        }
        this.mixColor = mixColor;
        if (mixValue < 0.0f) {
            mixValue = 0.0f;
        } else if (mixValue > 1.0f) {
            mixValue = 1.0f;
        }
        this.mixValue = mixValue;
        int mix_r = (int)((float)mixColor.getRed() * mixValue);
        int mix_g = (int)((float)mixColor.getGreen() * mixValue);
        int mix_b = (int)((float)mixColor.getBlue() * mixValue);
        float factor = 1.0f - mixValue;
        this.preMultipliedRed = new int[256];
        this.preMultipliedGreen = new int[256];
        this.preMultipliedBlue = new int[256];
        for (int i = 0; i < 256; ++i) {
            int value = (int)((float)i * factor);
            this.preMultipliedRed[i] = value + mix_r;
            this.preMultipliedGreen[i] = value + mix_g;
            this.preMultipliedBlue[i] = value + mix_b;
        }
    }

    public float getMixValue() {
        return this.mixValue;
    }

    public Color getMixColor() {
        return this.mixColor;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        GraphicsUtilities.getPixels(src, 0, 0, width, height, pixels);
        this.mixColor(pixels);
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }

    private void mixColor(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            int argb = pixels[i];
            pixels[i] = argb & 0xFF000000 | this.preMultipliedRed[argb >> 16 & 0xFF] << 16 | this.preMultipliedGreen[argb >> 8 & 0xFF] << 8 | this.preMultipliedBlue[argb & 0xFF];
        }
    }
}

