/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.rollover.TreeRolloverController;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;
import org.jdesktop.swingx.search.TreeSearchable;
import org.jdesktop.swingx.tree.DefaultXTreeCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(JXTree.class.getName());
    @Deprecated
    private Method conversionMethod = null;
    @Deprecated
    private static final Class[] methodSignature = new Class[]{Object.class};
    @Deprecated
    private static final Object[] methodArgs = new Object[]{null};
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    private DelegatingRenderer delegatingRenderer;
    private RolloverProducer rolloverProducer;
    private TreeRolloverController<JXTree> linkController;
    private boolean overwriteIcons;
    private Searchable searchable;
    private CellEditorRemover editorRemover;
    private CellEditorListener editorListener;
    private Color selectionForeground;
    private Color selectionBackground;
    protected ComponentAdapter dataAdapter;

    public JXTree() {
        this.init();
    }

    public JXTree(Object[] value) {
        super(value);
        this.init();
    }

    public JXTree(Vector value) {
        super(value);
        this.init();
    }

    public JXTree(Hashtable value) {
        super(value);
        this.init();
    }

    public JXTree(TreeNode root) {
        super(root, false);
        this.init();
    }

    public JXTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public JXTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    private void init() {
        TreeCellRenderer delegate;
        this.conversionMethod = this.getValueConversionMethod(this.getModel());
        TreeCellRenderer xRenderer = this.getCellRenderer();
        if (xRenderer instanceof DelegatingRenderer && (delegate = ((DelegatingRenderer)xRenderer).getDelegateRenderer()) instanceof DefaultTreeCellRenderer) {
            this.setCellEditor(new DefaultXTreeCellEditor(this, (DefaultTreeCellRenderer)delegate));
        }
        ActionMap map = this.getActionMap();
        map.put("expand-all", new Actions("expand-all"));
        map.put("collapse-all", new Actions("collapse-all"));
        map.put("find", this.createFindAction());
        KeyStroke findStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(findStroke, "find");
    }

    @Override
    protected TreeModelListener createTreeModelListener() {
        return new XTreeModelHandler();
    }

    private Action createFindAction() {
        return new UIAction("find"){

            public void actionPerformed(ActionEvent e) {
                JXTree.this.doFind();
            }
        };
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TreeSearchable(this);
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public String getStringAt(int row) {
        return this.getStringAt(this.getPathForRow(row));
    }

    public String getStringAt(TreePath path) {
        if (path == null) {
            return null;
        }
        TreeCellRenderer renderer = this.getDelegatingRenderer().getDelegateRenderer();
        if (renderer instanceof StringValue) {
            return ((StringValue)((Object)renderer)).getString(path.getLastPathComponent());
        }
        return StringValues.TO_STRING.getString(path.getLastPathComponent());
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public void expandAll() {
        if (this.getRowCount() == 0) {
            this.expandRoot();
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    private void expandRoot() {
        TreeModel model = this.getModel();
        if (model != null && model.getRoot() != null) {
            this.expandPath(new TreePath(model.getRoot()));
        }
    }

    @Override
    public int[] getSelectionRows() {
        int[] rows = super.getSelectionRows();
        return rows != null ? rows : EMPTY_INT_ARRAY;
    }

    @Override
    public TreePath[] getSelectionPaths() {
        TreePath[] paths = super.getSelectionPaths();
        return paths != null ? paths : EMPTY_TREEPATH_ARRAY;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color selectionForeground) {
        Color oldValue = this.getSelectionForeground();
        this.selectionForeground = selectionForeground;
        this.firePropertyChange("selectionForeground", oldValue, this.getSelectionForeground());
        this.repaint();
    }

    public void setSelectionBackground(Color selectionBackground) {
        Color oldValue = this.getSelectionBackground();
        this.selectionBackground = selectionBackground;
        this.firePropertyChange("selectionBackground", oldValue, this.getSelectionBackground());
        this.repaint();
    }

    @Override
    public void updateUI() {
        this.uninstallSelectionColors();
        super.updateUI();
        this.installSelectionColors();
        this.updateHighlighterUI();
    }

    private void installSelectionColors() {
        if (this.isUIResource(this.getSelectionBackground())) {
            this.setSelectionBackground(UIManager.getColor("Tree.selectionBackground"));
        }
        if (this.isUIResource(this.getSelectionForeground())) {
            this.setSelectionForeground(UIManager.getColor("Tree.selectionForeground"));
        }
    }

    private void uninstallSelectionColors() {
        if (this.isUIResource(this.getSelectionBackground())) {
            this.setSelectionBackground(null);
        }
        if (this.isUIResource(this.getSelectionForeground())) {
            this.setSelectionForeground(null);
        }
    }

    protected void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }

    private boolean isUIResource(Object value) {
        return value == null || value instanceof UIResource;
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    protected TreeRolloverController<JXTree> getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected TreeRolloverController<JXTree> createLinkController() {
        return new TreeRolloverController<JXTree>();
    }

    protected RolloverProducer createRolloverProducer() {
        return new RolloverProducer(){

            public void mousePressed(MouseEvent e) {
                JXTree tree = (JXTree)e.getComponent();
                Point mousePoint = e.getPoint();
                int labelRow = tree.getRowForLocation(mousePoint.x, mousePoint.y);
                if (labelRow >= 0) {
                    return;
                }
                int row = tree.getClosestRowForLocation(mousePoint.x, mousePoint.y);
                Rectangle bounds = tree.getRowBounds(row);
                if (bounds == null) {
                    row = -1;
                } else if (bounds.y + bounds.height < mousePoint.y || bounds.x > mousePoint.x) {
                    row = -1;
                }
                if (row < 0) {
                    return;
                }
                tree.dispatchEvent(new MouseEvent(tree, e.getID(), e.getWhen(), e.getModifiers(), bounds.x + bounds.width - 2, mousePoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            }

            protected void updateRolloverPoint(JComponent component, Point mousePoint) {
                int col;
                JXTree tree = (JXTree)component;
                int row = tree.getClosestRowForLocation(mousePoint.x, mousePoint.y);
                Rectangle bounds = tree.getRowBounds(row);
                if (bounds == null) {
                    row = -1;
                } else if (bounds.y + bounds.height < mousePoint.y || bounds.x > mousePoint.x) {
                    row = -1;
                }
                this.rollover.x = col = row < 0 ? -1 : 0;
                this.rollover.y = row;
            }
        };
    }

    public void setHighlighters(Highlighter ... highlighters) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighters);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public void removeHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JXTree.this.repaint();
            }
        };
    }

    public void setExpandedIcon(Icon expandedIcon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setExpandedIcon(expandedIcon);
        }
    }

    public void setCollapsedIcon(Icon collapsedIcon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setCollapsedIcon(collapsedIcon);
        }
    }

    public void setLeafIcon(Icon leafIcon) {
        this.getDelegatingRenderer().setLeafIcon(leafIcon);
    }

    public void setOpenIcon(Icon openIcon) {
        this.getDelegatingRenderer().setOpenIcon(openIcon);
    }

    public void setClosedIcon(Icon closedIcon) {
        this.getDelegatingRenderer().setClosedIcon(closedIcon);
    }

    public void setOverwriteRendererIcons(boolean overwrite) {
        if (this.overwriteIcons == overwrite) {
            return;
        }
        boolean old = this.overwriteIcons;
        this.overwriteIcons = overwrite;
        this.firePropertyChange("overwriteRendererIcons", old, overwrite);
    }

    public boolean isOverwriteRendererIcons() {
        return this.overwriteIcons;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
        }
        return this.delegatingRenderer;
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public TreeCellRenderer getWrappedCellRenderer() {
        return this.getDelegatingRenderer().getDelegateRenderer();
    }

    @Override
    public void setCellRenderer(TreeCellRenderer renderer) {
        this.getDelegatingRenderer().setDelegateRenderer(renderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        super.startEditingAtPath(path);
        if (this.isEditing()) {
            this.updateEditorListener();
            this.updateEditorRemover();
        }
    }

    private void updateEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new CellEditorListener(){

                public void editingCanceled(ChangeEvent e) {
                    this.terminated(e);
                }

                private void terminated(ChangeEvent e) {
                    JXTree.this.analyseFocus();
                    ((CellEditor)e.getSource()).removeCellEditorListener(JXTree.this.editorListener);
                }

                public void editingStopped(ChangeEvent e) {
                    this.terminated(e);
                }
            };
        }
        this.getCellEditor().addCellEditorListener(this.editorListener);
    }

    protected void analyseFocus() {
        if (this.isFocusOwnerDescending()) {
            this.requestFocusInWindow();
        }
    }

    private boolean isFocusOwnerDescending() {
        if (!this.isEditing()) {
            return false;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        if (SwingXUtilities.isDescendingFrom(focusOwner, this)) {
            return true;
        }
        Component permanent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        return SwingXUtilities.isDescendingFrom(permanent, this);
    }

    @Override
    public void removeNotify() {
        if (this.editorRemover != null) {
            this.editorRemover.release();
            this.editorRemover = null;
        }
        super.removeNotify();
    }

    private void updateEditorRemover() {
        if (this.editorRemover == null) {
            this.editorRemover = new CellEditorRemover();
        }
        this.editorRemover.updateKeyboardFocusManager();
    }

    @Override
    public void setModel(TreeModel newModel) {
        this.conversionMethod = this.getValueConversionMethod(newModel);
        super.setModel(newModel);
    }

    @Deprecated
    protected Method getValueConversionMethod(TreeModel model) {
        try {
            return model == null ? null : model.getClass().getMethod("convertValueToText", methodSignature);
        }
        catch (NoSuchMethodException ex) {
            LOG.finer("ex " + ex);
            LOG.finer("no conversionMethod in " + model.getClass());
            return null;
        }
    }

    @Override
    @Deprecated
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null) {
            if (this.conversionMethod == null) {
                return value.toString();
            }
            try {
                JXTree.methodArgs[0] = value;
                return (String)this.conversionMethod.invoke((Object)this.getModel(), methodArgs);
            }
            catch (Exception ex) {
                LOG.finer("ex " + ex);
                LOG.finer("can't invoke " + this.conversionMethod);
            }
        }
        return "";
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int index) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.column = 0;
        adapter.row = index;
        return adapter;
    }

    protected static class TreeAdapter
    extends ComponentAdapter {
        private final JXTree tree;

        public TreeAdapter(JXTree component) {
            super(component);
            this.tree = component;
        }

        public JXTree getTree() {
            return this.tree;
        }

        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        public Object getValueAt(int row, int column) {
            TreePath path = this.tree.getPathForRow(row);
            return path.getLastPathComponent();
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.getValueAt(row, column);
        }

        public Object getValue() {
            return this.getValueAt(this.row, this.column);
        }

        public String getFilteredStringAt(int row, int column) {
            return this.tree.getStringAt(row);
        }

        public String getString() {
            return this.tree.getStringAt(this.row);
        }

        public String getStringAt(int row, int column) {
            return this.tree.getStringAt(row);
        }

        public boolean isEditable() {
            return this.tree.isPathEditable(this.tree.getPathForRow(this.row));
        }

        public boolean isSelected() {
            return this.tree.isRowSelected(this.row);
        }

        public boolean isExpanded() {
            return this.tree.isExpanded(this.row);
        }

        public int getDepth() {
            return this.tree.getPathForRow(this.row).getPathCount() - 1;
        }

        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void setValueAt(Object aValue, int row, int column) {
        }
    }

    public class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover() {
            this.updateKeyboardFocusManager();
        }

        public void updateKeyboardFocusManager() {
            KeyboardFocusManager current = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.setKeyboardFocusManager(current);
        }

        public void release() {
            this.setKeyboardFocusManager(null);
        }

        private void setKeyboardFocusManager(KeyboardFocusManager current) {
            if (this.focusManager == current) {
                return;
            }
            KeyboardFocusManager old = this.focusManager;
            if (old != null) {
                old.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = current;
            if (this.focusManager != null) {
                this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!JXTree.this.isEditing()) {
                return;
            }
            Component c = this.focusManager.getPermanentFocusOwner();
            JXTree tree = JXTree.this;
            while (c != null) {
                if (c instanceof JPopupMenu) {
                    c = ((JPopupMenu)c).getInvoker();
                    continue;
                }
                if (c == tree) {
                    return;
                }
                if (c instanceof Window || c instanceof Applet && c.getParent() == null) {
                    if (c != SwingUtilities.getRoot(tree)) break;
                    if (tree.getInvokesStopCellEditing()) {
                        tree.stopEditing();
                    }
                    if (!tree.isEditing()) break;
                    tree.cancelEditing();
                    break;
                }
                c = c.getParent();
            }
        }
    }

    public class DelegatingRenderer
    implements TreeCellRenderer,
    RolloverRenderer {
        private Icon closedIcon = null;
        private Icon openIcon = null;
        private Icon leafIcon = null;
        private TreeCellRenderer delegate;

        public DelegatingRenderer() {
            this(null);
            this.initIcons(new DefaultTreeCellRenderer());
        }

        public DelegatingRenderer(TreeCellRenderer delegate) {
            this.initIcons((DefaultTreeCellRenderer)(delegate instanceof DefaultTreeCellRenderer ? delegate : new DefaultTreeCellRenderer()));
            this.setDelegateRenderer(delegate);
        }

        private void initIcons(DefaultTreeCellRenderer renderer) {
            this.closedIcon = renderer.getDefaultClosedIcon();
            this.openIcon = renderer.getDefaultOpenIcon();
            this.leafIcon = renderer.getDefaultLeafIcon();
        }

        public void setDelegateRenderer(TreeCellRenderer delegate) {
            if (delegate == null) {
                delegate = JXTree.this.createDefaultCellRenderer();
            }
            this.delegate = delegate;
            this.updateIcons();
        }

        private void updateIcons() {
            if (!JXTree.this.isOverwriteRendererIcons()) {
                return;
            }
            this.setClosedIcon(this.closedIcon);
            this.setOpenIcon(this.openIcon);
            this.setLeafIcon(this.leafIcon);
        }

        public void setClosedIcon(Icon closedIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setClosedIcon(closedIcon);
            }
            this.closedIcon = closedIcon;
        }

        public void setOpenIcon(Icon openIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setOpenIcon(openIcon);
            }
            this.openIcon = openIcon;
        }

        public void setLeafIcon(Icon leafIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setLeafIcon(leafIcon);
            }
            this.leafIcon = leafIcon;
        }

        public TreeCellRenderer getDelegateRenderer() {
            return this.delegate;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component result = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (JXTree.this.compoundHighlighter != null && row < JXTree.this.getRowCount() && row >= 0) {
                result = JXTree.this.compoundHighlighter.highlight(result, JXTree.this.getComponentAdapter(row));
            }
            return result;
        }

        public boolean isEnabled() {
            return this.delegate instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.delegate)).isEnabled();
        }

        public void doClick() {
            if (this.isEnabled()) {
                ((RolloverRenderer)((Object)this.delegate)).doClick();
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("expand-all".equals(this.getName())) {
                JXTree.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTree.this.collapseAll();
            }
        }
    }

    protected class XTreeModelHandler
    extends JTree.TreeModelHandler {
        protected XTreeModelHandler() {
            super(JXTree.this);
        }

        public void treeNodesInserted(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            if (path.getParentPath() == null && !JXTree.this.isRootVisible() && JXTree.this.isCollapsed(path)) {
                JXTree.this.expandPath(path);
            }
            super.treeNodesInserted(e);
        }
    }
}

