/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.View;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXImagePanel;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.auth.DefaultUserNameStore;
import org.jdesktop.swingx.auth.LoginAdapter;
import org.jdesktop.swingx.auth.LoginEvent;
import org.jdesktop.swingx.auth.LoginListener;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.auth.PasswordStore;
import org.jdesktop.swingx.auth.UserNameStore;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.plaf.LoginPaneAddon;
import org.jdesktop.swingx.plaf.LoginPaneUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.WindowUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXLoginPane
extends JXPanel {
    private static final Logger LOG = Logger.getLogger(JXLoginPane.class.getName());
    private static final long serialVersionUID = 3544949969896288564L;
    public static final String uiClassID = "LoginPaneUI";
    public static final String LOGIN_ACTION_COMMAND = "login";
    public static final String CANCEL_LOGIN_ACTION_COMMAND = "cancel-login";
    private static String CLASS_NAME = JXLoginPane.class.getSimpleName();
    private Status status = Status.NOT_STARTED;
    private JXImagePanel banner;
    private String bannerText;
    private JLabel messageLabel;
    private JXLabel errorMessageLabel;
    private JXPanel loginPanel;
    private JXPanel contentPanel;
    private NameComponent namePanel;
    private JPasswordField passwordField;
    private JComboBox serverCombo;
    private JCheckBox saveCB;
    private JLabel capsOn;
    private JXPanel progressPanel;
    private JLabel progressMessageLabel;
    private LoginService loginService;
    private PasswordStore passwordStore;
    private UserNameStore userNameStore;
    private List<String> servers;
    private SaveMode saveMode;
    private Cursor oldCursor;
    private boolean namePanelEnabled = true;
    private LoginListener defaultLoginListener;
    private final CapsOnTest capsOnTest;
    private boolean caps;
    private boolean isTestingCaps;
    private final KeyEventDispatcher capsOnListener;
    private boolean capsLockSupport = true;
    private JXBtnPanel buttonPanel;
    private final CapsOnWinListener capsOnWinListener;
    private JPanel contentCardPane;
    private boolean isErrorMessageSet;

    private void reinitLocales(Locale l) {
        JLabel lbl;
        this.setBannerText(UIManagerExt.getString(CLASS_NAME + ".bannerString", this.getLocale()));
        this.banner.setImage(this.createLoginBanner());
        if (!this.isErrorMessageSet) {
            this.errorMessageLabel.setText(UIManager.getString((Object)(CLASS_NAME + ".errorMessage"), this.getLocale()));
        }
        this.progressMessageLabel.setText(UIManagerExt.getString(CLASS_NAME + ".pleaseWait", this.getLocale()));
        this.recreateLoginPanel();
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w instanceof JXLoginFrame) {
            JXLoginFrame f = (JXLoginFrame)w;
            f.setTitle(UIManagerExt.getString(CLASS_NAME + ".titleString", this.getLocale()));
            if (this.buttonPanel != null) {
                this.buttonPanel.getOk().setText(UIManagerExt.getString(CLASS_NAME + ".loginString", this.getLocale()));
                this.buttonPanel.getCancel().setText(UIManagerExt.getString(CLASS_NAME + ".cancelString", this.getLocale()));
            }
        }
        if ((lbl = (JLabel)this.passwordField.getClientProperty("labeledBy")) != null) {
            lbl.setText(UIManagerExt.getString(CLASS_NAME + ".passwordString", this.getLocale()));
        }
        if ((lbl = (JLabel)this.namePanel.getComponent().getClientProperty("labeledBy")) != null) {
            lbl.setText(UIManagerExt.getString(CLASS_NAME + ".nameString", this.getLocale()));
        }
        if (this.serverCombo != null && (lbl = (JLabel)this.serverCombo.getClientProperty("labeledBy")) != null) {
            lbl.setText(UIManagerExt.getString(CLASS_NAME + ".serverString", this.getLocale()));
        }
        this.saveCB.setText(UIManagerExt.getString(CLASS_NAME + ".rememberPasswordString", this.getLocale()));
        this.capsOn.setText(this.isCapsLockOn() ? UIManagerExt.getString(CLASS_NAME + ".capsOnWarning", this.getLocale()) : " ");
        this.getActionMap().get(LOGIN_ACTION_COMMAND).putValue("Name", UIManagerExt.getString(CLASS_NAME + ".loginString", this.getLocale()));
        this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND).putValue("Name", UIManagerExt.getString(CLASS_NAME + ".cancelString", this.getLocale()));
    }

    public JXLoginPane() {
        this((LoginService)null);
    }

    public JXLoginPane(LoginService service) {
        this(service, null, null);
    }

    public JXLoginPane(LoginService service, PasswordStore passwordStore, UserNameStore userStore) {
        this(service, passwordStore, userStore, null);
    }

    public JXLoginPane(LoginService service, PasswordStore passwordStore, UserNameStore userStore, List<String> servers) {
        if (Boolean.parseBoolean(System.getProperty("swingx.enableCapslockTesting"))) {
            this.capsOnTest = new CapsOnTest();
            this.capsOnListener = new KeyEventDispatcher(){

                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getID() != 401) {
                        return false;
                    }
                    if (e.getKeyCode() == 20) {
                        JXLoginPane.this.setCapsLock(!JXLoginPane.this.isCapsLockOn());
                    }
                    return false;
                }
            };
            this.capsOnWinListener = new CapsOnWinListener(this.capsOnTest);
        } else {
            this.capsOnTest = null;
            this.capsOnListener = null;
            this.capsOnWinListener = null;
            this.capsLockSupport = false;
        }
        this.setLoginService(service);
        this.setPasswordStore(passwordStore);
        this.setUserNameStore(userStore);
        this.setServers(servers);
        this.getActionMap().put(LOGIN_ACTION_COMMAND, this.createLoginAction());
        this.getActionMap().put(CANCEL_LOGIN_ACTION_COMMAND, this.createCancelAction());
        this.saveMode = passwordStore != null && userStore != null ? SaveMode.BOTH : (passwordStore != null ? SaveMode.PASSWORD : (userStore != null ? SaveMode.USER_NAME : SaveMode.NONE));
        this.setOpaque(false);
        this.initComponents();
    }

    private void setCapsLock(boolean b) {
        this.caps = b;
        this.capsOn.setText(this.caps ? UIManagerExt.getString(CLASS_NAME + ".capsOnWarning", this.getLocale()) : " ");
    }

    public boolean isCapsLockOn() {
        return this.caps;
    }

    public boolean isCapsLockDetectionSupported() {
        return this.capsLockSupport;
    }

    @Override
    public LoginPaneUI getUI() {
        return (LoginPaneUI)super.getUI();
    }

    public void setUI(LoginPaneUI ui) {
        if (this.banner == null) {
            this.banner = new JXImagePanel();
        }
        if (this.errorMessageLabel == null) {
            this.errorMessageLabel = new JXLabel(UIManagerExt.getString(CLASS_NAME + ".errorMessage", this.getLocale()));
        }
        super.setUI(ui);
        this.banner.setImage(this.createLoginBanner());
    }

    @Override
    public void updateUI() {
        this.setUI((LoginPaneUI)LookAndFeelAddons.getUI(this, LoginPaneUI.class));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected void recreateLoginPanel() {
        this.contentPanel.remove(this.loginPanel);
        this.loginPanel = this.createLoginPanel();
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(0, 36, 7, 11));
        this.contentPanel.add((Component)this.loginPanel, 1);
    }

    private JXPanel createLoginPanel() {
        JXPanel loginPanel = new JXPanel();
        NameComponent oldPanel = this.namePanel;
        this.namePanel = this.saveMode == SaveMode.NONE ? new SimpleNamePanel() : new ComboNamePanel(this.userNameStore);
        if (oldPanel != null) {
            this.namePanel.setUserName(oldPanel.getUserName());
            this.namePanel.setEnabled(oldPanel.isEnabled());
            this.namePanel.setEditable(oldPanel.isEditable());
        } else {
            this.namePanel.setEnabled(this.namePanelEnabled);
            this.namePanel.setEditable(this.namePanelEnabled);
        }
        JLabel nameLabel = new JLabel(UIManagerExt.getString(CLASS_NAME + ".nameString", this.getLocale()));
        nameLabel.setLabelFor(this.namePanel.getComponent());
        JPasswordField oldPwd = this.passwordField;
        this.passwordField = new JPasswordField("", 15);
        JLabel passwordLabel = new JLabel(UIManagerExt.getString(CLASS_NAME + ".passwordString", this.getLocale()));
        passwordLabel.setLabelFor(this.passwordField);
        if (oldPwd != null) {
            this.passwordField.setText(new String(oldPwd.getPassword()));
        }
        JLabel serverLabel = new JLabel(UIManagerExt.getString(CLASS_NAME + ".serverString", this.getLocale()));
        if (this.servers.size() > 1) {
            this.serverCombo = new JComboBox<Object>(this.servers.toArray());
            serverLabel.setLabelFor(this.serverCombo);
        } else {
            this.serverCombo = null;
        }
        this.saveCB = new JCheckBox(UIManagerExt.getString(CLASS_NAME + ".rememberPasswordString", this.getLocale()));
        this.saveCB.setIconTextGap(10);
        this.saveCB.setSelected(false);
        this.saveCB.setVisible(this.saveMode == SaveMode.PASSWORD || this.saveMode == SaveMode.BOTH);
        this.saveCB.setOpaque(false);
        this.capsOn = new JLabel(" ");
        int lShift = 3;
        GridLayout grid = new GridLayout(2, 1);
        grid.setVgap(5);
        JPanel fields = new JPanel(grid);
        fields.setOpaque(false);
        fields.add(this.namePanel.getComponent());
        fields.add(this.passwordField);
        loginPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(4, lShift, 5, 11);
        loginPanel.add((Component)nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        loginPanel.add((Component)fields, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, lShift, 5, 11);
        loginPanel.add((Component)passwordLabel, gridBagConstraints);
        if (this.serverCombo != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, lShift, 5, 11);
            loginPanel.add((Component)serverLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            loginPanel.add((Component)this.serverCombo, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            loginPanel.add((Component)this.saveCB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, lShift, 0, 11);
            loginPanel.add((Component)this.capsOn, gridBagConstraints);
        } else {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            loginPanel.add((Component)this.saveCB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, lShift, 0, 11);
            loginPanel.add((Component)this.capsOn, gridBagConstraints);
        }
        loginPanel.setOpaque(false);
        return loginPanel;
    }

    @Override
    public void setComponentOrientation(ComponentOrientation orient) {
        if (orient != super.getComponentOrientation()) {
            super.setComponentOrientation(orient);
            this.banner.setImage(this.createLoginBanner());
            this.progressPanel.applyComponentOrientation(orient);
        }
    }

    private void initComponents() {
        this.banner.setImage(this.createLoginBanner());
        this.messageLabel = new JLabel(" ");
        this.messageLabel.setOpaque(false);
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
        this.loginPanel = this.createLoginPanel();
        this.errorMessageLabel.setIcon(UIManager.getIcon(CLASS_NAME + ".errorIcon", this.getLocale()));
        this.errorMessageLabel.setVerticalTextPosition(1);
        this.errorMessageLabel.setLineWrap(true);
        this.errorMessageLabel.setPaintBorderInsets(false);
        this.errorMessageLabel.setBackgroundPainter(new MattePainter(UIManager.getColor(CLASS_NAME + ".errorBackground", this.getLocale()), true));
        this.errorMessageLabel.setMaxLineSpan(320);
        this.errorMessageLabel.setVisible(false);
        this.contentPanel = new JXPanel(new LoginPaneLayout());
        this.contentPanel.setOpaque(false);
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(12, 12, 7, 11));
        this.contentPanel.add(this.messageLabel);
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(0, 36, 7, 11));
        this.contentPanel.add(this.loginPanel);
        this.errorMessageLabel.setBorder(UIManager.getBorder(CLASS_NAME + ".errorBorder", this.getLocale()));
        this.contentPanel.add(this.errorMessageLabel);
        this.progressPanel = new JXPanel(new GridBagLayout());
        this.progressPanel.setOpaque(false);
        this.progressMessageLabel = new JLabel(UIManagerExt.getString(CLASS_NAME + ".pleaseWait", this.getLocale()));
        this.progressMessageLabel.setFont(UIManager.getFont(CLASS_NAME + ".pleaseWaitFont", this.getLocale()));
        JProgressBar pb = new JProgressBar();
        pb.setIndeterminate(true);
        JButton cancelButton = new JButton(this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND));
        this.progressPanel.add((Component)this.progressMessageLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 11, 11), 0, 0));
        this.progressPanel.add((Component)pb, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 24, 11, 7), 0, 0));
        this.progressPanel.add((Component)cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 11, 11), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.banner, "North");
        this.contentCardPane = new JPanel(new CardLayout());
        this.contentCardPane.setOpaque(false);
        this.contentCardPane.add((Component)this.contentPanel, "0");
        this.contentCardPane.add((Component)this.progressPanel, "1");
        this.add((Component)this.contentCardPane, "Center");
    }

    protected Image createLoginBanner() {
        return this.getUI() == null ? null : this.getUI().getBanner();
    }

    protected Action createLoginAction() {
        return new LoginAction(this);
    }

    protected Action createCancelAction() {
        return new CancelAction(this);
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        if (this.saveMode != saveMode) {
            SaveMode oldMode = this.getSaveMode();
            this.saveMode = saveMode;
            this.recreateLoginPanel();
            this.firePropertyChange("saveMode", (Object)oldMode, (Object)this.getSaveMode());
        }
    }

    public List<String> getServers() {
        return Collections.unmodifiableList(this.servers);
    }

    public void setServers(List<String> servers) {
        if (this.servers == null) {
            this.servers = servers == null ? new ArrayList() : servers;
        } else if (this.servers != servers) {
            List<String> old = this.getServers();
            this.servers = servers == null ? new ArrayList() : servers;
            this.recreateLoginPanel();
            this.firePropertyChange("servers", old, this.getServers());
        }
    }

    private LoginListener getDefaultLoginListener() {
        if (this.defaultLoginListener == null) {
            this.defaultLoginListener = new LoginListenerImpl();
        }
        return this.defaultLoginListener;
    }

    public void setLoginService(LoginService service) {
        LoginService newService;
        LoginService oldService = this.getLoginService();
        LoginService loginService = newService = service == null ? new NullLoginService() : service;
        if (!newService.equals(oldService)) {
            if (oldService != null) {
                oldService.removeLoginListener(this.getDefaultLoginListener());
            }
            this.loginService = newService;
            this.loginService.addLoginListener(this.getDefaultLoginListener());
            this.firePropertyChange("loginService", oldService, this.getLoginService());
        }
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    public void setPasswordStore(PasswordStore store) {
        PasswordStore newStore;
        PasswordStore oldStore = this.getPasswordStore();
        PasswordStore passwordStore = newStore = store == null ? new NullPasswordStore() : store;
        if (!newStore.equals(oldStore)) {
            this.passwordStore = newStore;
            this.firePropertyChange("passwordStore", oldStore, this.getPasswordStore());
        }
    }

    public UserNameStore getUserNameStore() {
        return this.userNameStore;
    }

    public void setUserNameStore(UserNameStore store) {
        UserNameStore newStore;
        UserNameStore oldStore = this.getUserNameStore();
        UserNameStore userNameStore = newStore = store == null ? new DefaultUserNameStore() : store;
        if (!newStore.equals(oldStore)) {
            this.userNameStore = newStore;
            this.firePropertyChange("userNameStore", oldStore, this.getUserNameStore());
        }
    }

    public PasswordStore getPasswordStore() {
        return this.passwordStore;
    }

    public void setUserName(String username) {
        if (this.namePanel != null) {
            this.namePanel.setUserName(username);
        }
    }

    public void setUserNameEnabled(boolean enabled) {
        this.namePanelEnabled = enabled;
        if (this.namePanel != null) {
            this.namePanel.setEnabled(enabled);
            this.namePanel.setEditable(enabled);
        }
    }

    public boolean isUserNameEnabled() {
        return this.namePanelEnabled;
    }

    public String getUserName() {
        return this.namePanel == null ? null : this.namePanel.getUserName();
    }

    public void setPassword(char[] password) {
        this.passwordField.setText(new String(password));
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public Image getBanner() {
        return this.banner.getImage();
    }

    public void setBanner(Image img) {
        Image oldImage = this.getBanner();
        if (oldImage != img) {
            this.banner.setImage(img);
            this.firePropertyChange("banner", oldImage, this.getBanner());
        }
    }

    public void setBannerText(String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.bannerText)) {
            String oldText = this.bannerText;
            this.bannerText = text;
            this.banner.setImage(this.createLoginBanner());
            this.firePropertyChange("bannerText", oldText, text);
        }
    }

    public String getBannerText() {
        return this.bannerText;
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public String getErrorMessage() {
        return this.errorMessageLabel.getText();
    }

    public void setErrorMessage(String errorMessage) {
        this.isErrorMessageSet = true;
        this.errorMessageLabel.setText(errorMessage);
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setStatus(Status newStatus) {
        if (this.status != newStatus) {
            Status oldStatus = this.status;
            this.status = newStatus;
            this.firePropertyChange("status", (Object)oldStatus, (Object)newStatus);
        }
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.reinitLocales(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startLogin() {
        this.oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.progressMessageLabel.setText(UIManagerExt.getString(CLASS_NAME + ".pleaseWait", this.getLocale()));
            String name = this.getUserName();
            char[] password = this.getPassword();
            String server = this.servers.size() == 1 ? this.servers.get(0) : (this.serverCombo == null ? null : (String)this.serverCombo.getSelectedItem());
            this.loginService.startAuthentication(name, password, server);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Authentication exception while logging in", ex);
        }
        finally {
            this.setCursor(this.oldCursor);
        }
    }

    protected void cancelLogin() {
        this.progressMessageLabel.setText(UIManagerExt.getString(CLASS_NAME + ".cancelWait", this.getLocale()));
        this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND).setEnabled(false);
        this.loginService.cancelAuthentication();
        this.setCursor(this.oldCursor);
    }

    protected void savePassword() {
        if (this.saveCB.isSelected() && (this.saveMode == SaveMode.BOTH || this.saveMode == SaveMode.PASSWORD) && this.passwordStore != null) {
            this.passwordStore.set(this.getUserName(), this.getLoginService().getServer(), this.getPassword());
        }
    }

    @Override
    public void removeNotify() {
        try {
            Window c;
            if (this.capsLockSupport) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.capsOnListener);
            }
            if ((c = this.getTLA()) instanceof Window) {
                Window w = c;
                w.removeWindowFocusListener(this.capsOnWinListener);
                w.removeWindowListener(this.capsOnWinListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.removeNotify();
    }

    private Window getTLA() {
        Container c = this;
        while (c.getParent() != null && !(c instanceof Window)) {
            c = c.getParent();
        }
        return (Window)c;
    }

    @Override
    public void addNotify() {
        try {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.capsOnListener);
            Window c = this.getTLA();
            if (c instanceof Window) {
                Window w = c;
                w.addWindowFocusListener(this.capsOnWinListener);
                w.addWindowListener(this.capsOnWinListener);
            }
        }
        catch (Exception e) {
            this.capsLockSupport = false;
        }
        super.addNotify();
    }

    public static Status showLoginDialog(Component parent, LoginService svc) {
        return JXLoginPane.showLoginDialog(parent, svc, null, null);
    }

    public static Status showLoginDialog(Component parent, LoginService svc, PasswordStore ps, UserNameStore us) {
        return JXLoginPane.showLoginDialog(parent, svc, ps, us, null);
    }

    public static Status showLoginDialog(Component parent, LoginService svc, PasswordStore ps, UserNameStore us, List<String> servers) {
        JXLoginPane panel = new JXLoginPane(svc, ps, us, servers);
        return JXLoginPane.showLoginDialog(parent, panel);
    }

    public static Status showLoginDialog(Component parent, JXLoginPane panel) {
        Window w = WindowUtils.findWindow(parent);
        JXLoginDialog dlg = null;
        if (w == null) {
            dlg = new JXLoginDialog((Frame)null, panel);
        } else if (w instanceof Dialog) {
            dlg = new JXLoginDialog((Dialog)w, panel);
        } else if (w instanceof Frame) {
            dlg = new JXLoginDialog((Frame)w, panel);
        } else {
            throw new AssertionError((Object)"Shouldn't be able to happen");
        }
        dlg.setVisible(true);
        return dlg.getStatus();
    }

    public static JXLoginFrame showLoginFrame(LoginService svc) {
        return JXLoginPane.showLoginFrame(svc, null, null);
    }

    public static JXLoginFrame showLoginFrame(LoginService svc, PasswordStore ps, UserNameStore us) {
        return JXLoginPane.showLoginFrame(svc, ps, us, null);
    }

    public static JXLoginFrame showLoginFrame(LoginService svc, PasswordStore ps, UserNameStore us, List<String> servers) {
        JXLoginPane panel = new JXLoginPane(svc, ps, us, servers);
        return JXLoginPane.showLoginFrame(panel);
    }

    public static JXLoginFrame showLoginFrame(JXLoginPane panel) {
        return new JXLoginFrame(panel);
    }

    static void initWindow(final Window w, final JXLoginPane panel) {
        w.setLayout(new BorderLayout());
        w.add((Component)panel, "Center");
        JButton okButton = new JButton(panel.getActionMap().get(LOGIN_ACTION_COMMAND));
        final JButton cancelButton = new JButton(UIManagerExt.getString(CLASS_NAME + ".cancelString", panel.getLocale()));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                panel.status = Status.CANCELLED;
                w.setVisible(false);
                w.dispose();
            }
        });
        panel.addPropertyChangeListener("status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Status status = (Status)((Object)evt.getNewValue());
                switch (status) {
                    case NOT_STARTED: {
                        break;
                    }
                    case IN_PROGRESS: {
                        cancelButton.setEnabled(false);
                        break;
                    }
                    case CANCELLED: {
                        cancelButton.setEnabled(true);
                        w.pack();
                        break;
                    }
                    case FAILED: {
                        cancelButton.setEnabled(true);
                        w.pack();
                        break;
                    }
                    case SUCCEEDED: {
                        w.setVisible(false);
                        w.dispose();
                    }
                }
                for (PropertyChangeListener l : w.getPropertyChangeListeners("status")) {
                    PropertyChangeEvent pce = new PropertyChangeEvent(w, "status", evt.getOldValue(), evt.getNewValue());
                    l.propertyChange(pce);
                }
            }
        });
        JXBtnPanel buttonPanel = new JXBtnPanel(okButton, cancelButton);
        buttonPanel.setOpaque(false);
        panel.setButtonPanel(buttonPanel);
        JXPanel controls = new JXPanel(new FlowLayout(2));
        controls.setOpaque(false);
        new BoxLayout(controls, 0);
        controls.add(Box.createHorizontalGlue());
        controls.add(buttonPanel);
        w.add((Component)controls, "South");
        w.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                panel.cancelLogin();
            }
        });
        if (w instanceof JFrame) {
            final JFrame f = (JFrame)w;
            f.getRootPane().setDefaultButton(okButton);
            f.setResizable(false);
            f.setDefaultCloseOperation(2);
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
            ActionListener closeAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    f.setVisible(false);
                    f.dispose();
                }
            };
            f.getRootPane().registerKeyboardAction(closeAction, ks, 2);
        } else if (w instanceof JDialog) {
            final JDialog d = (JDialog)w;
            d.getRootPane().setDefaultButton(okButton);
            d.setResizable(false);
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
            ActionListener closeAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    d.setVisible(false);
                }
            };
            d.getRootPane().registerKeyboardAction(closeAction, ks, 2);
        }
        w.pack();
        w.setLocation(WindowUtils.getPointForCentering(w));
    }

    private void setButtonPanel(JXBtnPanel buttonPanel) {
        this.buttonPanel = buttonPanel;
    }

    static {
        LookAndFeelAddons.contribute(new LoginPaneAddon());
    }

    public class RemovableKeyEventDispatcher
    implements KeyEventDispatcher {
        private CapsOnTest cot;
        private boolean tested = false;
        private int retry = 0;

        public RemovableKeyEventDispatcher(CapsOnTest capsOnTest) {
            this.cot = capsOnTest;
        }

        public boolean dispatchKeyEvent(KeyEvent e) {
            this.tested = true;
            if (e.getID() != 401) {
                return true;
            }
            if (JXLoginPane.this.isTestingCaps && e.getKeyCode() > 64 && e.getKeyCode() < 91) {
                JXLoginPane.this.setCapsLock(!e.isShiftDown() && Character.isUpperCase(e.getKeyChar()));
            }
            if (JXLoginPane.this.isTestingCaps && e.getKeyCode() == 8) {
                this.uninstall();
                this.retry = 0;
            }
            return true;
        }

        void uninstall() {
            JXLoginPane.this.isTestingCaps = false;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            if (this.cot.ked == this) {
                this.cot.ked = null;
            }
        }

        void cleanOnBogusFocus() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!RemovableKeyEventDispatcher.this.tested) {
                        RemovableKeyEventDispatcher.this.uninstall();
                        if (RemovableKeyEventDispatcher.this.retry < 3) {
                            Window w = JXLoginPane.this.getTLA();
                            if (w != null) {
                                w.toFront();
                            }
                            RemovableKeyEventDispatcher.this.cot.runTest();
                            RemovableKeyEventDispatcher.this.retry++;
                        }
                    }
                }
            });
        }
    }

    public static class CapsOnWinListener
    extends WindowAdapter
    implements WindowFocusListener,
    WindowListener {
        private CapsOnTest cot;
        private long stamp;

        public CapsOnWinListener(CapsOnTest cot) {
            this.cot = cot;
        }

        public void windowActivated(WindowEvent e) {
            this.cot.runTest();
            this.stamp = System.currentTimeMillis();
        }

        public void windowGainedFocus(WindowEvent e) {
            if (this.stamp + 20L < System.currentTimeMillis()) {
                this.cot.runTest();
            }
        }

        public void windowOpened(WindowEvent arg0) {
            this.cot.clean();
        }
    }

    private class CapsOnTest {
        RemovableKeyEventDispatcher ked;

        private CapsOnTest() {
        }

        public void runTest() {
            boolean success = false;
            if (!success) {
                try {
                    KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    if (this.ked != null) {
                        kfm.removeKeyEventDispatcher(this.ked);
                    }
                    this.ked = new RemovableKeyEventDispatcher(this);
                    kfm.addKeyEventDispatcher(this.ked);
                    Robot r = new Robot();
                    JXLoginPane.this.isTestingCaps = true;
                    r.keyPress(65);
                    r.keyRelease(65);
                    r.keyPress(8);
                    r.keyRelease(8);
                }
                catch (Exception e1) {
                    this.ked.uninstall();
                }
            }
        }

        public void clean() {
            if (this.ked != null) {
                this.ked.cleanOnBogusFocus();
            }
        }
    }

    private static class JXBtnPanel
    extends JXPanel {
        private static final long serialVersionUID = 4136611099721189372L;
        private JButton cancel;
        private JButton ok;

        public JXBtnPanel(JButton okButton, JButton cancelButton) {
            GridLayout layout = new GridLayout(1, 2);
            layout.setHgap(5);
            this.setLayout(layout);
            this.ok = okButton;
            this.cancel = cancelButton;
            this.add(okButton);
            this.add(cancelButton);
            this.setBorder(new EmptyBorder(0, 0, 7, 11));
        }

        public JButton getCancel() {
            return this.cancel;
        }

        public JButton getOk() {
            return this.ok;
        }
    }

    public static final class JXLoginFrame
    extends JXFrame {
        private static final long serialVersionUID = -9016407314342050807L;
        private JXLoginPane panel;

        public JXLoginFrame(JXLoginPane p) {
            super(UIManagerExt.getString(CLASS_NAME + ".titleString", p.getLocale()));
            JXPanel cp = new JXPanel();
            cp.setOpaque(true);
            this.setContentPane(cp);
            this.panel = p;
            JXLoginPane.initWindow(this, this.panel);
        }

        public JXPanel getContentPane() {
            return (JXPanel)super.getContentPane();
        }

        public Status getStatus() {
            return this.panel.getStatus();
        }

        public JXLoginPane getPanel() {
            return this.panel;
        }
    }

    public static final class JXLoginDialog
    extends JDialog {
        private static final long serialVersionUID = -3185639594267828103L;
        private JXLoginPane panel;

        public JXLoginDialog(Frame parent, JXLoginPane p) {
            super(parent, true);
            this.init(p);
        }

        public JXLoginDialog(Dialog parent, JXLoginPane p) {
            super(parent, true);
            this.init(p);
        }

        protected void init(JXLoginPane p) {
            this.setTitle(UIManagerExt.getString(CLASS_NAME + ".titleString", this.getLocale()));
            this.panel = p;
            JXLoginPane.initWindow(this, this.panel);
        }

        public Status getStatus() {
            return this.panel.getStatus();
        }
    }

    public static final class ComboNamePanel
    extends JComboBox
    implements NameComponent {
        private static final long serialVersionUID = 2511649075486103959L;
        private UserNameStore userNameStore;

        public ComboNamePanel(UserNameStore userNameStore) {
            this.userNameStore = userNameStore;
            this.setModel(new NameComboBoxModel());
            this.setEditable(true);
        }

        public String getUserName() {
            Object item = this.getModel().getSelectedItem();
            return item == null ? null : item.toString();
        }

        public void setUserName(String userName) {
            this.getModel().setSelectedItem(userName);
        }

        public void setUserNames(String[] names) {
            this.setModel(new DefaultComboBoxModel<String>(names));
        }

        public JComponent getComponent() {
            return this;
        }

        private final class NameComboBoxModel
        extends AbstractListModel
        implements ComboBoxModel {
            private static final long serialVersionUID = 7097674687536018633L;
            private Object selectedItem;

            private NameComboBoxModel() {
            }

            public void setSelectedItem(Object anItem) {
                this.selectedItem = anItem;
                this.fireContentsChanged(this, -1, -1);
            }

            public Object getSelectedItem() {
                return this.selectedItem;
            }

            public Object getElementAt(int index) {
                return ComboNamePanel.this.userNameStore.getUserNames()[index];
            }

            public int getSize() {
                return ComboNamePanel.this.userNameStore.getUserNames().length;
            }
        }
    }

    public static final class SimpleNamePanel
    extends JTextField
    implements NameComponent {
        private static final long serialVersionUID = 6513437813612641002L;

        public SimpleNamePanel() {
            super("", 15);
        }

        public String getUserName() {
            return this.getText();
        }

        public void setUserName(String userName) {
            this.setText(userName);
        }

        public JComponent getComponent() {
            return this;
        }
    }

    public static interface NameComponent {
        public String getUserName();

        public boolean isEnabled();

        public boolean isEditable();

        public void setEditable(boolean var1);

        public void setEnabled(boolean var1);

        public void setUserName(String var1);

        public JComponent getComponent();
    }

    private static final class NullPasswordStore
    extends PasswordStore {
        private static final char[] EMPTY = new char[0];

        private NullPasswordStore() {
        }

        public boolean set(String username, String server, char[] password) {
            return false;
        }

        public char[] get(String username, String server) {
            return EMPTY;
        }

        public boolean equals(Object obj) {
            return obj instanceof NullPasswordStore;
        }

        public int hashCode() {
            return 7;
        }
    }

    private static final class NullLoginService
    extends LoginService {
        private NullLoginService() {
        }

        public boolean authenticate(String name, char[] password, String server) throws Exception {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof NullLoginService;
        }

        public int hashCode() {
            return 7;
        }
    }

    private static final class CancelAction
    extends AbstractActionExt {
        private static final long serialVersionUID = 4040029973355439229L;
        private JXLoginPane panel;

        public CancelAction(JXLoginPane p) {
            super(UIManagerExt.getString(CLASS_NAME + ".cancelLogin", p.getLocale()), JXLoginPane.CANCEL_LOGIN_ACTION_COMMAND);
            this.panel = p;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.panel.cancelLogin();
        }

        public void itemStateChanged(ItemEvent e) {
        }
    }

    private static final class LoginAction
    extends AbstractActionExt {
        private static final long serialVersionUID = 7256761187925982485L;
        private JXLoginPane panel;

        public LoginAction(JXLoginPane p) {
            super(UIManagerExt.getString(CLASS_NAME + ".loginString", p.getLocale()), JXLoginPane.LOGIN_ACTION_COMMAND);
            this.panel = p;
        }

        public void actionPerformed(ActionEvent e) {
            this.panel.startLogin();
        }

        public void itemStateChanged(ItemEvent e) {
        }
    }

    protected class LoginListenerImpl
    extends LoginAdapter {
        protected LoginListenerImpl() {
        }

        public void loginSucceeded(LoginEvent source) {
            String userName = JXLoginPane.this.namePanel.getUserName();
            JXLoginPane.this.savePassword();
            if (!(JXLoginPane.this.getSaveMode() != SaveMode.USER_NAME && JXLoginPane.this.getSaveMode() != SaveMode.BOTH || userName == null || userName.trim().equals(""))) {
                JXLoginPane.this.userNameStore.addUserName(userName);
                JXLoginPane.this.userNameStore.saveUserNames();
            }
            JXLoginPane.this.setStatus(Status.SUCCEEDED);
        }

        public void loginStarted(LoginEvent source) {
            assert (EventQueue.isDispatchThread());
            JXLoginPane.this.getActionMap().get(JXLoginPane.LOGIN_ACTION_COMMAND).setEnabled(false);
            JXLoginPane.this.getActionMap().get(JXLoginPane.CANCEL_LOGIN_ACTION_COMMAND).setEnabled(true);
            ((CardLayout)JXLoginPane.this.contentCardPane.getLayout()).last(JXLoginPane.this.contentCardPane);
            JXLoginPane.this.revalidate();
            JXLoginPane.this.repaint();
            JXLoginPane.this.setStatus(Status.IN_PROGRESS);
        }

        public void loginFailed(LoginEvent source) {
            assert (EventQueue.isDispatchThread());
            ((CardLayout)JXLoginPane.this.contentCardPane.getLayout()).first(JXLoginPane.this.contentCardPane);
            JXLoginPane.this.getActionMap().get(JXLoginPane.LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPane.this.errorMessageLabel.setVisible(true);
            JXLoginPane.this.revalidate();
            JXLoginPane.this.repaint();
            JXLoginPane.this.setStatus(Status.FAILED);
        }

        public void loginCanceled(LoginEvent source) {
            assert (EventQueue.isDispatchThread());
            ((CardLayout)JXLoginPane.this.contentCardPane.getLayout()).first(JXLoginPane.this.contentCardPane);
            JXLoginPane.this.getActionMap().get(JXLoginPane.LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPane.this.errorMessageLabel.setVisible(false);
            JXLoginPane.this.revalidate();
            JXLoginPane.this.repaint();
            JXLoginPane.this.setStatus(Status.CANCELLED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_STARTED,
        IN_PROGRESS,
        FAILED,
        CANCELLED,
        SUCCEEDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveMode {
        NONE,
        USER_NAME,
        PASSWORD,
        BOTH;

    }

    private static class LoginPaneLayout
    extends VerticalLayout
    implements LayoutManager {
        private LoginPaneLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension pref = new Dimension(0, 0);
            int gap = this.getGap();
            int c = parent.getComponentCount();
            for (int i = 0; i < c; ++i) {
                Component m = parent.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension componentPreferredSize = m.getPreferredSize();
                if (m instanceof JLabel) {
                    View view = (View)((JLabel)m).getClientProperty("html");
                    if (view != null) {
                        view.setSize(pref.width, m.getHeight());
                        componentPreferredSize = m.getPreferredSize();
                    }
                } else {
                    pref.width = Math.max(pref.width, componentPreferredSize.width);
                }
                pref.height += componentPreferredSize.height + gap;
            }
            pref.width += insets.left + insets.right;
            pref.height += insets.top + insets.bottom;
            return pref;
        }
    }
}

