/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topics.screen;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.openide.util.actions.SystemAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.topics.DeleteTopicAction;
import tr.view.topics.EditTopicAction;
import tr.view.topics.dialog.TopicDialog;
import tr.view.topics.screen.TopicNode;
import tr.view.topics.screen.TopicNodeProvider;
import tr.view.topics.screen.TopicsTableFormat;

public class TopicsPanel
extends JPanel
implements ListSelectionListener,
Observer {
    private final Data data;
    private final TopicNodeProvider topicProvider;
    private JXTable topicTable;
    private TopicsTableFormat topicTableFormat;
    private Collection<Topic> topicList;
    private EventList<Topic> topicEventList;
    private EventSelectionModel<Topic> selectionModel;
    private EventTableModel<Topic> topicEventTableModel;
    private ListSelectionModel tableSelectionModel;
    private SortedList<Topic> topicSortedList;
    private TableComparatorChooser<Topic> tableSorter;
    private TopicDialog topicDialog;

    public TopicsPanel(TopicNodeProvider topicProvider) {
        this.topicProvider = topicProvider;
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        this.initTable();
        this.initPanel();
    }

    private void initTable() {
        if (this.data == null) {
            return;
        }
        this.topicList = this.data.getTopicManager().list();
        this.topicEventList = new BasicEventList();
        this.topicEventList.addAll(this.topicList);
        this.data.getTopicManager().addObserver((Observer)this);
        this.topicSortedList = new SortedList(this.topicEventList);
        this.topicSortedList.setMode(1);
        this.topicTableFormat = new TopicsTableFormat();
        this.topicEventTableModel = new EventTableModel(this.topicSortedList, (TableFormat)this.topicTableFormat);
        this.topicTable = new JXTable(this.topicEventTableModel);
        this.topicTable.getTableHeader().setDefaultRenderer(new JTableHeader().getDefaultRenderer());
        this.topicTable.getSelectionMapper().setEnabled(false);
        this.topicTable.setSortable(false);
        this.topicTable.setSelectionMode(0);
        this.topicTable.setColumnControlVisible(true);
        this.topicTable.setColumnSelectionAllowed(false);
        this.topicTable.setCellSelectionEnabled(false);
        this.topicTable.setRowSelectionAllowed(true);
        this.topicTable.setShowGrid(false);
        this.topicTable.setShowHorizontalLines(false);
        this.topicTable.setShowVerticalLines(false);
        this.selectionModel = new EventSelectionModel(this.topicSortedList);
        this.selectionModel.addListSelectionListener((ListSelectionListener)this);
        this.selectionModel.setSelectionMode(2);
        this.selectionModel.setEnabled(true);
        this.topicTable.setSelectionModel(this.selectionModel);
        for (int c = 0; c < this.topicTableFormat.getColumnCount(); ++c) {
            this.topicTable.getColumnModel().getColumn(c).setPreferredWidth(this.topicTableFormat.getColumnWidth(c));
        }
        this.topicTable.setDefaultRenderer(TopicsTableFormat.TopicName.class, (TableCellRenderer)new TopicsTableFormat.TopicNameRenderer());
        this.topicTable.setDefaultRenderer(TopicsTableFormat.TopicDesc.class, (TableCellRenderer)new TopicsTableFormat.TopicDescRenderer());
        this.tableSorter = new TableComparatorChooser((JTable)this.topicTable, this.topicSortedList, true);
        this.topicTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    TopicsPanel.this.edit();
                } else if (e.getKeyCode() == 127) {
                    e.consume();
                    TopicsPanel.this.delete();
                }
            }
        });
        this.topicTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TopicsPanel.this.edit();
                }
            }
        });
    }

    public Preferences getPreferences() {
        return new Preferences(this);
    }

    public void setPreferences(Preferences preferences) {
        if (preferences != null) {
            preferences.restore(this);
        }
    }

    private void initPanel() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView((Component)this.topicTable);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.add((Component)scrollPane, "Center");
    }

    private void edit() {
        ((EditTopicAction)SystemAction.get(EditTopicAction.class)).actionPerformed(null);
    }

    private void delete() {
        ((DeleteTopicAction)SystemAction.get(DeleteTopicAction.class)).actionPerformed(null);
    }

    private TopicDialog getTopicDialog() {
        this.topicDialog = new TopicDialog(this.data);
        return this.topicDialog;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Vector<TopicNode> nodes = new Vector<TopicNode>();
        for (Topic topic : this.selectionModel.getSelected()) {
            nodes.add(new TopicNode((Manager<Topic>)this.data.getTopicManager(), topic));
        }
        this.topicProvider.provide(nodes);
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Manager.EventAdd) {
            Manager.EventAdd event = (Manager.EventAdd)object;
            Lock lock = this.topicEventList.getReadWriteLock().writeLock();
            lock.lock();
            this.topicEventList.add((Object)((Topic)event.item));
            lock.unlock();
        } else if (object instanceof Manager.EventRemove) {
            Manager.EventRemove event = (Manager.EventRemove)object;
            Lock lock = this.topicEventList.getReadWriteLock().writeLock();
            lock.lock();
            this.topicEventList.remove(event.item);
            lock.unlock();
        } else if (observable instanceof Topic) {
            Lock lock = this.topicEventList.getReadWriteLock().writeLock();
            lock.lock();
            Topic item = (Topic)observable;
            int index = this.topicEventList.indexOf((Object)item);
            if (index > -1) {
                this.topicEventList.set(index, (Object)item);
            }
            lock.unlock();
        }
        this.topicTable.invalidate();
        this.topicTable.repaint();
    }

    static class Preferences
    implements Serializable {
        private static final long serialVersionUID = 8787983453L;
        private final int[] modelIndex;
        private final int[] columnWidth;
        private final boolean[] columnVisible;
        private final int[] columnOrder;
        private final List<Integer> sortingColumns;
        private final List<Boolean> sortingReverse;

        private Preferences(TopicsPanel panel) {
            int i;
            JXTable table = panel.topicTable;
            this.modelIndex = new int[table.getColumnCount(true)];
            this.columnWidth = new int[table.getColumnCount(true)];
            this.columnVisible = new boolean[table.getColumnCount(true)];
            this.columnOrder = new int[table.getColumnCount(false)];
            List columns = table.getColumns(true);
            for (i = 0; i < columns.size(); ++i) {
                TableColumn c = (TableColumn)columns.get(i);
                this.modelIndex[i] = c.getModelIndex();
                this.columnWidth[i] = c.getWidth();
                this.columnVisible[i] = table.getColumnExt(c.getIdentifier()).isVisible();
            }
            for (i = 0; i < table.getColumnCount(); ++i) {
                this.columnOrder[i] = table.getColumn(i).getModelIndex();
            }
            this.sortingColumns = panel.tableSorter.getSortingColumns();
            this.sortingReverse = new Vector<Boolean>();
            for (Integer column : this.sortingColumns) {
                this.sortingReverse.add(new Boolean(panel.tableSorter.isColumnReverse(column.intValue())));
            }
        }

        private void restore(TopicsPanel panel) {
            int i;
            if (panel == null) {
                return;
            }
            if (panel.topicTable == null) {
                return;
            }
            if (panel.topicTableFormat == null) {
                return;
            }
            for (int i2 = 0; i2 < this.modelIndex.length; ++i2) {
                String id = panel.topicTableFormat.getColumnName(this.modelIndex[i2]);
                TableColumnExt tce = panel.topicTable.getColumnExt((Object)id);
                if (panel.topicTableFormat.isResizable(this.modelIndex[i2])) {
                    tce.setPreferredWidth(this.columnWidth[i2]);
                } else {
                    int w = panel.topicTableFormat.getColumnWidth(this.modelIndex[i2]);
                    tce.setMaxWidth(w);
                    tce.setMinWidth(w);
                }
                tce.setVisible(this.columnVisible[i2]);
            }
            Object[] ids = new Object[this.columnOrder.length];
            for (i = 0; i < ids.length; ++i) {
                ids[i] = panel.topicTableFormat.getColumnName(this.columnOrder[i]);
            }
            panel.topicTable.setColumnSequence(ids);
            panel.tableSorter.clearComparator();
            for (i = 0; i < this.sortingColumns.size(); ++i) {
                int column = this.sortingColumns.get(i);
                boolean reverse = this.sortingReverse.get(i);
                panel.tableSorter.appendComparator(column, 0, reverse);
            }
        }
    }
}

