/*
 * Decompiled with CFR 0.152.
 */
package tr.view.filters;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChoiceDialog<T extends Comparable<? super T>>
extends JDialog {
    private JButton acceptAllButton;
    private JButton acceptButton;
    private JButton cancelButton;
    private JLabel choiceLabel;
    private JList choiceList;
    private JScrollPane choiceScrollPane;
    private JLabel chosenLabel;
    private JList chosenList;
    private JScrollPane chosenScrollPane;
    private JButton okButton;
    private JButton rejectAllButton;
    private JButton rejectButton;
    private JToolBar toolbar;
    private final Vector<T> all;
    private final boolean sort;
    private Vector<T> choice;
    private Vector<T> chosen;
    private boolean okay;

    public MultiChoiceDialog(Component comp, Vector<T> all, Vector<T> chosen, boolean sort) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.setDefaultCloseOperation(2);
        this.all = all;
        this.sort = sort;
        if (sort) {
            Collections.sort(all);
        }
        this.setLocationRelativeTo(comp);
        this.initComponents();
        Vector<T> c = new Vector<T>(chosen);
        if (sort) {
            Collections.sort(chosen);
        }
        this.setChosen(c);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.okay = false;
            super.setVisible(true);
        } else {
            super.setVisible(false);
            super.dispose();
        }
    }

    public boolean isOkay() {
        return this.okay;
    }

    public void setChosen(Vector<T> chosen) {
        this.chosen = chosen;
        this.choice = new Vector();
        for (Comparable t : this.all) {
            if (chosen.contains(t)) continue;
            this.choice.add(t);
        }
        if (this.sort) {
            Collections.sort(this.choice);
            Collections.sort(chosen);
        }
        this.choiceList.setListData(this.choice);
        this.chosenList.setListData(chosen);
    }

    public Vector<T> getChosen() {
        return this.chosen;
    }

    private void initComponents() {
        this.toolbar = new JToolBar();
        this.acceptButton = new JButton();
        this.rejectButton = new JButton();
        this.acceptAllButton = new JButton();
        this.rejectAllButton = new JButton();
        this.okButton = new JButton();
        this.choiceScrollPane = new JScrollPane();
        this.choiceList = new JList();
        this.chosenScrollPane = new JScrollPane();
        this.chosenList = new JList();
        this.choiceLabel = new JLabel();
        this.chosenLabel = new JLabel();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(1);
        this.toolbar.setMargin(new Insets(2, 2, 2, 2));
        this.acceptButton.setFont(new Font("Serif", 1, 10));
        this.acceptButton.setText(">");
        this.acceptButton.setHorizontalTextPosition(0);
        this.acceptButton.setMaximumSize(new Dimension(28, 28));
        this.acceptButton.setMinimumSize(new Dimension(28, 28));
        this.acceptButton.setPreferredSize(new Dimension(28, 28));
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MultiChoiceDialog.this.acceptActionPerformed(evt);
            }
        });
        this.toolbar.add(this.acceptButton);
        this.rejectButton.setFont(new Font("Serif", 1, 10));
        this.rejectButton.setText("<");
        this.rejectButton.setHorizontalTextPosition(0);
        this.rejectButton.setMaximumSize(new Dimension(28, 28));
        this.rejectButton.setMinimumSize(new Dimension(28, 28));
        this.rejectButton.setPreferredSize(new Dimension(28, 28));
        this.rejectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MultiChoiceDialog.this.rejectActionPerformed(evt);
            }
        });
        this.toolbar.add(this.rejectButton);
        this.acceptAllButton.setFont(new Font("Serif", 1, 10));
        this.acceptAllButton.setText(">>");
        this.acceptAllButton.setHorizontalTextPosition(0);
        this.acceptAllButton.setMaximumSize(new Dimension(28, 28));
        this.acceptAllButton.setMinimumSize(new Dimension(28, 28));
        this.acceptAllButton.setPreferredSize(new Dimension(28, 28));
        this.acceptAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MultiChoiceDialog.this.acceptAllActionPerformed(evt);
            }
        });
        this.toolbar.add(this.acceptAllButton);
        this.rejectAllButton.setFont(new Font("Serif", 1, 10));
        this.rejectAllButton.setText("<<");
        this.rejectAllButton.setHorizontalTextPosition(0);
        this.rejectAllButton.setMaximumSize(new Dimension(28, 28));
        this.rejectAllButton.setMinimumSize(new Dimension(28, 28));
        this.rejectAllButton.setPreferredSize(new Dimension(28, 28));
        this.rejectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MultiChoiceDialog.this.rejectAllActionPerformed(evt);
            }
        });
        this.toolbar.add(this.rejectAllButton);
        this.okButton.setText(NbBundle.getMessage(MultiChoiceDialog.class, (String)"ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MultiChoiceDialog.this.okActionPerformed(evt);
            }
        });
        this.choiceList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MultiChoiceDialog.this.choiceListMouseClicked(evt);
            }
        });
        this.choiceScrollPane.setViewportView(this.choiceList);
        this.chosenList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MultiChoiceDialog.this.chosenListMouseClicked(evt);
            }
        });
        this.chosenScrollPane.setViewportView(this.chosenList);
        this.choiceLabel.setHorizontalAlignment(0);
        this.choiceLabel.setText(NbBundle.getMessage(MultiChoiceDialog.class, (String)"available"));
        this.chosenLabel.setHorizontalAlignment(0);
        this.chosenLabel.setText(NbBundle.getMessage(MultiChoiceDialog.class, (String)"selection"));
        this.cancelButton.setText(NbBundle.getMessage(MultiChoiceDialog.class, (String)"cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MultiChoiceDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.choiceScrollPane, -1, 213, Short.MAX_VALUE).add((Component)this.choiceLabel, -1, 213, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.toolbar, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.chosenScrollPane, -1, 213, Short.MAX_VALUE).add((Component)this.chosenLabel, -1, 213, Short.MAX_VALUE))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.okButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.choiceLabel).add((Component)this.chosenLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.chosenScrollPane, -1, 260, Short.MAX_VALUE).add((Component)this.choiceScrollPane, -1, 260, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(44, 44, 44).add((Component)this.toolbar, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.okButton).add((Component)this.cancelButton))));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void chosenListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.rejectSelected();
        }
    }

    private void choiceListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.acceptSelected();
        }
    }

    private void okActionPerformed(ActionEvent evt) {
        this.okay = true;
        this.setVisible(false);
    }

    private void rejectAllActionPerformed(ActionEvent evt) {
        this.rejectAll();
    }

    private void acceptAllActionPerformed(ActionEvent evt) {
        this.acceptAll();
    }

    private void rejectActionPerformed(ActionEvent evt) {
        this.rejectSelected();
    }

    private void acceptActionPerformed(ActionEvent evt) {
        this.acceptSelected();
    }

    private synchronized void acceptSelected() {
        try {
            int[] indices = this.choiceList.getSelectedIndices();
            if (indices == null || indices.length < 1) {
                return;
            }
            Vector<T> selected = new Vector<T>(indices.length);
            for (int i = 0; i < indices.length; ++i) {
                selected.add(this.choice.get(indices[i]));
            }
            for (Comparable t : selected) {
                this.choice.remove(t);
                this.chosen.add(t);
            }
            if (this.sort) {
                Collections.sort(this.choice);
                Collections.sort(this.chosen);
            }
            this.choiceList.setListData(this.choice);
            this.chosenList.setListData(this.chosen);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private synchronized void rejectSelected() {
        try {
            int[] indices = this.chosenList.getSelectedIndices();
            if (indices == null || indices.length < 1) {
                return;
            }
            Vector<T> selected = new Vector<T>(indices.length);
            for (int i = 0; i < indices.length; ++i) {
                selected.add(this.chosen.get(indices[i]));
            }
            for (Comparable t : selected) {
                this.chosen.remove(t);
                this.choice.add(t);
            }
            if (this.sort) {
                Collections.sort(this.choice);
                Collections.sort(this.chosen);
            }
            this.choiceList.setListData(this.choice);
            this.chosenList.setListData(this.chosen);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private synchronized void acceptAll() {
        this.choice.clear();
        this.chosen.clear();
        for (Comparable t : this.all) {
            this.chosen.add(t);
        }
        if (this.sort) {
            Collections.sort(this.choice);
            Collections.sort(this.chosen);
        }
        this.choiceList.setListData(this.choice);
        this.chosenList.setListData(this.chosen);
    }

    private synchronized void rejectAll() {
        this.chosen.clear();
        this.choice.clear();
        for (Comparable t : this.all) {
            this.choice.add(t);
        }
        if (this.sort) {
            Collections.sort(this.choice);
            Collections.sort(this.chosen);
        }
        this.choiceList.setListData(this.choice);
        this.chosenList.setListData(this.chosen);
    }
}

