/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ComponentWidget
extends Widget {
    private Component component;
    private boolean componentAdded;
    private boolean widgetAdded;
    private double zoomFactor = Double.MIN_VALUE;
    private ComponentSceneListener validateListener;
    private ComponentComponentListener componentListener;
    private boolean componentVisible = false;

    public ComponentWidget(Scene scene, Component component) {
        super(scene);
        this.component = component;
        this.validateListener = null;
        this.componentListener = new ComponentComponentListener();
        this.setComponentVisible(true);
    }

    public final Component getComponent() {
        return this.component;
    }

    public final boolean isComponentVisible() {
        return this.componentVisible;
    }

    public final void setComponentVisible(boolean bl) {
        if (this.componentVisible == bl) {
            return;
        }
        this.componentVisible = bl;
        this.attach();
        this.revalidate();
    }

    protected final void notifyAdded() {
        this.widgetAdded = true;
        this.attach();
    }

    protected final void notifyRemoved() {
        this.widgetAdded = false;
    }

    private void attach() {
        if (this.validateListener != null) {
            return;
        }
        this.validateListener = new ComponentSceneListener();
        this.getScene().addSceneListener(this.validateListener);
    }

    private void detach() {
        if (this.validateListener == null) {
            return;
        }
        this.getScene().removeSceneListener(this.validateListener);
        this.validateListener = null;
    }

    protected final Rectangle calculateClientArea() {
        Dimension dimension = this.component.getPreferredSize();
        this.zoomFactor = this.getScene().getZoomFactor();
        dimension.width = (int)Math.floor((double)dimension.width / this.zoomFactor);
        dimension.height = (int)Math.floor((double)dimension.height / this.zoomFactor);
        return new Rectangle(dimension);
    }

    private void addComponent() {
        Scene scene = this.getScene();
        if (!this.componentAdded) {
            scene.getView().add(this.component);
            scene.getView().revalidate();
            this.component.addComponentListener(this.componentListener);
            this.componentAdded = true;
        }
        this.component.removeComponentListener(this.componentListener);
        this.component.setBounds(scene.convertSceneToView(this.convertLocalToScene(this.getClientArea())));
        this.component.addComponentListener(this.componentListener);
        this.component.repaint();
    }

    private void removeComponent() {
        Scene scene = this.getScene();
        if (this.componentAdded) {
            this.component.removeComponentListener(this.componentListener);
            scene.getView().remove(this.component);
            scene.getView().revalidate();
            this.componentAdded = false;
        }
    }

    protected final void paintWidget() {
        if (this.getScene().isPaintEverything() || !this.componentVisible) {
            boolean bl;
            boolean bl2 = bl = this.component instanceof JComponent && this.component.isDoubleBuffered();
            if (bl) {
                ((JComponent)this.component).setDoubleBuffered(false);
            }
            Graphics2D graphics2D = this.getGraphics();
            Rectangle rectangle = this.getClientArea();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(rectangle.x, rectangle.y);
            double d = this.getScene().getZoomFactor();
            graphics2D.scale(1.0 / d, 1.0 / d);
            this.component.paint(graphics2D);
            graphics2D.setTransform(affineTransform);
            if (bl) {
                ((JComponent)this.component).setDoubleBuffered(bl);
            }
        }
    }

    private final class ComponentComponentListener
    implements ComponentListener {
        private ComponentComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            ComponentWidget.this.revalidate();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            ComponentWidget.this.revalidate();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    private final class ComponentSceneListener
    implements Scene.SceneListener {
        private ComponentSceneListener() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
            double d = ComponentWidget.this.getScene().getZoomFactor();
            if (Math.abs(d - ComponentWidget.this.zoomFactor) != 0.0) {
                ComponentWidget.this.revalidate();
                ComponentWidget.this.zoomFactor = d;
            }
        }

        public void sceneValidated() {
            if (ComponentWidget.this.widgetAdded && ComponentWidget.this.componentVisible) {
                ComponentWidget.this.addComponent();
            } else {
                ComponentWidget.this.removeComponent();
                ComponentWidget.this.detach();
            }
        }
    }
}

