/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRCalculable;

class JRBigDecimalCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRBigDecimalCountIncrementer mainInstance = new JRBigDecimalCountIncrementer();

    private JRBigDecimalCountIncrementer() {
    }

    public static JRBigDecimalCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        BigDecimal value = (BigDecimal)variable.getIncrementedValue();
        if (value == null || variable.isInitialized()) {
            value = JRBigDecimalIncrementerFactory.ZERO;
        }
        if (expressionValue == null) {
            return value;
        }
        return value.add(JRBigDecimalIncrementerFactory.ONE);
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        BigDecimal value = (BigDecimal)calculable.getIncrementedValue();
        BigDecimal combineValue = (BigDecimal)calculableValue.getValue();
        if (value == null || calculable.isInitialized()) {
            value = JRBigDecimalIncrementerFactory.ZERO;
        }
        if (combineValue == null) {
            return value;
        }
        return value.add(combineValue);
    }

    public Object initialValue() {
        return JRBigDecimalIncrementerFactory.ZERO;
    }
}

