/*
 * Decompiled with CFR 0.152.
 */
package tr.view.contexts.screen;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.context.Context;
import tr.model.context.ContextUtils;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.view.contexts.ContextsComboBox;
import tr.view.contexts.ContextsComboBoxModel;
import tr.view.contexts.DeleteContextCookie;
import tr.view.contexts.EditContextCookie;
import tr.view.contexts.dialog.ContextDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextNode
extends AbstractNode
implements EditContextCookie,
DeleteContextCookie {
    public final Manager<Context> manager;
    public final Context context;

    public ContextNode(Manager<Context> manager, Context context) {
        super(Children.LEAF, Lookups.singleton((Object)context));
        this.manager = manager;
        this.context = context;
    }

    public String getName() {
        return this.context == null ? "" : this.context.getName();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == EditContextCookie.class) {
            return this;
        }
        if (clazz == DeleteContextCookie.class) {
            return this;
        }
        return super.getCookie(clazz);
    }

    @Override
    public void editContext() {
        if (this.context == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        if (this.context.equals((Object)Context.getDefault())) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        new ContextDialog(data).showModifyDialog(this.context);
    }

    @Override
    public void deleteContext() {
        if (this.context == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        if (this.context.equals((Object)Context.getDefault())) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (ContextUtils.instance().isUsed(data, this.context)) {
            ContextsComboBox ccb = new ContextsComboBox(new ContextsComboBoxModel(false));
            ccb.setSelectedIndex(0);
            JPanel panel = new JPanel();
            panel.add(new JLabel(NbBundle.getMessage(this.getClass(), (String)"MSG_ReplaceContext")));
            panel.add((Component)((Object)ccb));
            String title = NbBundle.getMessage(ContextNode.class, (String)"confirm.delete.context", (Object)this.context.getName());
            Frame p = WindowManager.getDefault().getMainWindow();
            int r = JOptionPane.showConfirmDialog(p, panel, title, 2);
            if (r == 2) {
                return;
            }
            Context replacement = (Context)ccb.getSelectedItem();
            if (!ContextUtils.instance().replace(data, this.context, replacement)) {
                String msg = NbBundle.getMessage(ContextNode.class, (String)"error.replace.context", (Object)this.context.getName(), (Object)replacement.getName());
                JOptionPane.showMessageDialog(p, msg);
                return;
            }
        }
        data.getContextManager().remove((Observable)this.context);
    }
}

