/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.openide.util.NbBundle;

public class MapFormat
extends Format {
    private static final int BUFSIZE = 255;
    static final long serialVersionUID = -7695811542873819435L;
    private Locale locale = Locale.getDefault();
    private String ldel = "{";
    private String rdel = "}";
    private Map argmap;
    private int[] offsets;
    private String[] arguments;
    private int maxOffset;
    private boolean throwex = false;
    private boolean exactmatch = true;

    public MapFormat(Map map) {
        this.setMap(map);
    }

    public static String format(String string, Map map) {
        MapFormat mapFormat = new MapFormat(map);
        return mapFormat.format(string);
    }

    protected Object processKey(String string) {
        return this.argmap.get(string);
    }

    public String processPattern(String string) throws IllegalArgumentException {
        int n = 0;
        int n2 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        this.offsets = new int[255];
        this.arguments = new String[255];
        this.maxOffset = -1;
        while (true) {
            int n3 = -1;
            int n4 = string.indexOf(this.ldel, n);
            if (n4 < 0) break;
            n3 = string.indexOf(this.rdel, n4 + this.ldel.length());
            if (++n2 >= 255) {
                throw new IllegalArgumentException(NbBundle.getBundle(MapFormat.class).getString("MSG_TooManyArguments"));
            }
            if (n3 < 0) {
                if (!this.exactmatch) break;
                throw new IllegalArgumentException(NbBundle.getBundle(MapFormat.class).getString("MSG_UnmatchedBraces") + " " + n4);
            }
            stringBuffer.append(string.substring(n, n4));
            this.offsets[n2] = stringBuffer.length();
            this.arguments[n2] = string.substring(n4 + this.ldel.length(), n3);
            n = n3 + this.rdel.length();
            ++this.maxOffset;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    private String formatObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return NumberFormat.getInstance(this.locale).format(object);
        }
        if (object instanceof Date) {
            return DateFormat.getDateTimeInstance(3, 3, this.locale).format(object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string = this.processPattern((String)object);
        int n = 0;
        for (int i = 0; i <= this.maxOffset; ++i) {
            String string2;
            String string3;
            String string4;
            int n2;
            int n3 = this.offsets[i];
            stringBuffer.append(string.substring(n, this.offsets[i]));
            n = n3;
            String string5 = this.arguments[i];
            if (string5.length() <= 0) {
                stringBuffer.append(this.ldel);
                stringBuffer.append(this.rdel);
                continue;
            }
            String string6 = this.formatObject(this.processKey(string5));
            if (string6 == null && (n2 = (string4 = this.ldel + string5).lastIndexOf(this.ldel)) > 0 && (string3 = this.formatObject(this.processKey(string2 = string4.substring(n2 + this.ldel.length())))) != null) {
                string6 = string4.substring(0, n2) + string3;
            }
            if (string6 == null) {
                if (this.throwex) {
                    throw new IllegalArgumentException(MessageFormat.format(NbBundle.getBundle(MapFormat.class).getString("MSG_FMT_ObjectForKey"), new Integer(string5)));
                }
                string6 = this.ldel + string5 + this.rdel;
            }
            stringBuffer.append(string6);
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string);
    }

    public String parse(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (String string2 : this.argmap.keySet()) {
            String string3 = this.formatObject(this.argmap.get(string2));
            int n = -1;
            do {
                ++n;
                n = stringBuffer.toString().indexOf(string3, n);
                if (n < 0) continue;
                stringBuffer.replace(n, n + string3.length(), this.ldel + string2 + this.rdel);
            } while (n != -1);
        }
        return stringBuffer.toString();
    }

    public boolean willThrowExceptionIfKeyWasNotFound() {
        return this.throwex;
    }

    public void setThrowExceptionIfKeyWasNotFound(boolean bl) {
        this.throwex = bl;
    }

    public boolean isExactMatch() {
        return this.exactmatch;
    }

    public void setExactMatch(boolean bl) {
        this.exactmatch = bl;
    }

    public String getLeftBrace() {
        return this.ldel;
    }

    public void setLeftBrace(String string) {
        this.ldel = string;
    }

    public String getRightBrace() {
        return this.rdel;
    }

    public void setRightBrace(String string) {
        this.rdel = string;
    }

    public Map getMap() {
        return this.argmap;
    }

    public void setMap(Map map) {
        this.argmap = map;
    }
}

