/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit38ClassRunner
extends Runner
implements Filterable,
Sortable {
    private Test fTest;

    public JUnit38ClassRunner(Class<?> klass) {
        this(new TestSuite((Class<? extends TestCase>)klass.asSubclass(TestCase.class)));
    }

    public JUnit38ClassRunner(Test test) {
        this.fTest = test;
    }

    @Override
    public void run(RunNotifier notifier) {
        TestResult result = new TestResult();
        result.addListener(JUnit38ClassRunner.createAdaptingListener(notifier));
        this.fTest.run(result);
    }

    public static TestListener createAdaptingListener(RunNotifier notifier) {
        return new OldTestClassAdaptingListener(notifier);
    }

    @Override
    public Description getDescription() {
        return this.makeDescription(this.fTest);
    }

    private Description makeDescription(Test test) {
        if (test instanceof TestCase) {
            TestCase tc = (TestCase)test;
            return Description.createTestDescription(tc.getClass(), tc.getName());
        }
        if (test instanceof TestSuite) {
            TestSuite ts = (TestSuite)test;
            String name = ts.getName() == null ? "" : ts.getName();
            Description description = Description.createSuiteDescription(name, new Annotation[0]);
            int n = ts.testCount();
            for (int i = 0; i < n; ++i) {
                description.addChild(this.makeDescription(ts.testAt(i)));
            }
            return description;
        }
        if (test instanceof Describable) {
            Describable adapter = (Describable)((Object)test);
            return adapter.getDescription();
        }
        if (test instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)test;
            return this.makeDescription(decorator.getTest());
        }
        return Description.createSuiteDescription(test.getClass());
    }

    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        if (this.fTest instanceof Filterable) {
            Filterable adapter = (Filterable)((Object)this.fTest);
            adapter.filter(filter);
        }
    }

    @Override
    public void sort(Sorter sorter) {
        if (this.fTest instanceof Sortable) {
            Sortable adapter = (Sortable)((Object)this.fTest);
            adapter.sort(sorter);
        }
    }

    private static final class OldTestClassAdaptingListener
    implements TestListener {
        private final RunNotifier fNotifier;

        private OldTestClassAdaptingListener(RunNotifier notifier) {
            this.fNotifier = notifier;
        }

        public void endTest(Test test) {
            this.fNotifier.fireTestFinished(this.asDescription(test));
        }

        public void startTest(Test test) {
            this.fNotifier.fireTestStarted(this.asDescription(test));
        }

        public void addError(Test test, Throwable t) {
            Failure failure = new Failure(this.asDescription(test), t);
            this.fNotifier.fireTestFailure(failure);
        }

        private Description asDescription(Test test) {
            if (test instanceof Describable) {
                Describable facade = (Describable)((Object)test);
                return facade.getDescription();
            }
            return Description.createTestDescription(test.getClass(), this.getName(test));
        }

        private String getName(Test test) {
            if (test instanceof TestCase) {
                return ((TestCase)test).getName();
            }
            return test.toString();
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.addError(test, (Throwable)((Object)t));
        }
    }
}

