/*
 * Decompiled with CFR 0.152.
 */
package tr.model.context;

import java.util.Iterator;
import java.util.logging.Logger;
import tr.model.Data;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.context.Context;
import tr.model.project.Project;

public class ContextUtils {
    private static final Logger LOG = Logger.getLogger("tr.model.context");
    private static ContextUtils instance;

    private ContextUtils() {
    }

    public static synchronized ContextUtils instance() {
        if (instance == null) {
            instance = new ContextUtils();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsed(Data data, Context context) {
        ContextUtils contextUtils = this;
        synchronized (contextUtils) {
            if (data == null || context == null) {
                return true;
            }
            return this.isUsedContext(data, context);
        }
    }

    private boolean isUsedContext(Data data, Context context) {
        if (context.equals(Context.getDefault())) {
            return true;
        }
        Iterator<Action> i = data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            if (!i.next().getContext().equals(context)) continue;
            return true;
        }
        if (this.isUsedContext(data.getRootProjects(), context)) {
            return true;
        }
        if (this.isUsedContext(data.getRootFutures(), context)) {
            return true;
        }
        return this.isUsedContext(data.getRootTemplates(), context);
    }

    private boolean isUsedContext(Project project, Context context) {
        for (Item child : project.getChildren()) {
            if (!(child instanceof Action ? ((Action)child).getContext().equals(context) : child instanceof Project && this.isUsedContext((Project)child, context))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Data data, Context context, Context replacement) {
        ContextUtils contextUtils = this;
        synchronized (contextUtils) {
            if (data == null || context == null || replacement == null) {
                return false;
            }
            if (context.equals(Context.getDefault())) {
                return false;
            }
            if (context.equals(replacement)) {
                return false;
            }
            this.replaceContext(data, context, replacement);
            return true;
        }
    }

    private void replaceContext(Data data, Context context, Context replacement) {
        this.replaceContext(data.getRootProjects(), context, replacement);
        Iterator<Action> i = data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            Action action = i.next();
            if (!action.getContext().equals(context)) continue;
            action.setContext(replacement);
        }
        this.replaceContext(data.getRootFutures(), context, replacement);
        this.replaceContext(data.getRootTemplates(), context, replacement);
    }

    private void replaceContext(Project project, Context context, Context replacement) {
        for (Item child : project.getChildren()) {
            if (child instanceof Action) {
                Action action = (Action)child;
                if (!action.getContext().equals(context)) continue;
                action.setContext(replacement);
                continue;
            }
            if (!(child instanceof Project)) continue;
            this.replaceContext((Project)child, context, replacement);
        }
    }
}

