/*
 * Decompiled with CFR 0.152.
 */
package tr.model;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import tr.model.Data;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.project.Project;

public class DataUpgrade0to1 {
    public static void process(Data data) {
        if (data.getVersion() == 0) {
            DataUpgrade0to1.upgrade(data);
            data.version = 1;
        }
    }

    private static void upgrade(Data data) {
        System.out.print("Upgrading data from version 0 to version 1 ... ");
        DataUpgrade0to1.processProjects(data);
        DataUpgrade0to1.processSingleActions(data);
        System.out.println("Done");
    }

    private static void processProjects(Data data) {
        Iterator<Project> i = data.getRootProjects().iterator(Project.class);
        while (i.hasNext()) {
            DataUpgrade0to1.processProject(i.next());
        }
    }

    private static void processProject(Project project) {
        Iterator<Item> i = project.iterator(Item.class);
        while (i.hasNext()) {
            Item child = i.next();
            if (child instanceof Action) {
                DataUpgrade0to1.processAction((Action)child);
                continue;
            }
            if (!(child instanceof Project)) continue;
            DataUpgrade0to1.processProject((Project)child);
        }
    }

    private static void processSingleActions(Data data) {
        Iterator<Action> i = data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            DataUpgrade0to1.processAction(i.next());
        }
    }

    private static void processAction(Action action) {
        ActionState state = action.getState();
        if (state instanceof ActionStateDelegated) {
            ActionStateDelegated asd = (ActionStateDelegated)state;
            asd.setDate(DataUpgrade0to1.clearTime(asd.getDate()));
        } else if (state instanceof ActionStateScheduled) {
            ActionStateScheduled ass = (ActionStateScheduled)state;
            ass.setDate(DataUpgrade0to1.clearTime(ass.getDate()));
        }
    }

    private static Date clearTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }
}

