/*
 * Decompiled with CFR 0.152.
 */
package tr.view.reference.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Date;
import org.openide.util.NbBundle;
import tr.model.information.Information;
import tr.swing.date.combo.DateItem;
import tr.util.DateUtils;
import tr.view.filters.FilterComboDate;
import tr.view.reference.filters.MatcherEditorBase;

public class MatcherEditorCreatedFrom
extends MatcherEditorBase
implements PropertyChangeListener {
    private static final DateItem[] dateItems = new DateItem[]{DateItem.DATE_CHOOSER, DateItem.TODAY, DateItem.YESTERDAY, DateItem.WEEKS_AGO_1, DateItem.WEEKS_AGO_2, DateItem.WEEKS_AGO_3, DateItem.WEEKS_AGO_4};
    private final FilterComboDate dateCombo = new FilterComboDate(dateItems, false);

    public MatcherEditorCreatedFrom() {
        this.dateCombo.addValueChangeListener((PropertyChangeListener)this);
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-created-from");
    }

    public Component getComponent() {
        return this.dateCombo;
    }

    public Serializable getSerializable() {
        return (DateItem)this.dateCombo.getSelectedItem();
    }

    public void setSerializable(Serializable serializable) {
        if (serializable instanceof DateItem) {
            this.dateCombo.setSelectedItem((Object)((DateItem)serializable));
        } else {
            this.dateCombo.setSelectedItem(null);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        DateItem item = (DateItem)this.dateCombo.getSelectedItem();
        if (item == null) {
            this.fireMatchAll();
        } else {
            this.fireChanged(new FromDateMatcher(FilterComboDate.getDate((DateItem)item)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FromDateMatcher
    implements Matcher<Information> {
        private final Date date;

        public FromDateMatcher() {
            this.date = null;
        }

        public FromDateMatcher(Date date) {
            this.date = DateUtils.getStart((Date)date);
        }

        public boolean matches(Information info) {
            return this.date == null || !info.getCreated().before(this.date);
        }
    }
}

