Sudo Security Policy
====================

The Sudo Project takes security seriously.  If you believe you have found a security vulnerability in Sudo, you can report it to us as described below.

## Reporting Security Issues

**Do not report security vulnerabilities through public GitHub issues or Bugzilla.**

Instead, report them via email to <Todd.Miller@sudo.ws>.  You may encrypt your message with PGP if you would like.  The current PGP key has the fingerprint 59D1 E9CC BA2B 3767 04FD D35B A9F4 C021 CEA4 70FB and may be downloaded from [the sudo.ws web site](https://www.sudo.ws/dist/PGPKEYS) or the [OpenPGP Key Server](https://keys.openpgp.org/search?q=0xa9f4c021cea470fb).

We try to respond to security issues in a timely manner but understand that Sudo is a volunteer project.

Include as much of the following information as possible to help us better understand the nature and scope of the potential issue:

  * Type of issue (e.g. buffer overflow, privilege escalation, etc.)
  * Full paths of source file(s) related to the issue
  * The location of the affected source code (tag/branch/commit or direct URL)
  * Any special configuration required to reproduce the issue
  * The operating system and/or distro affected
  * Step-by-step instructions to reproduce the issue
  * Proof-of-concept or exploit code (if possible)
  * Impact of the issue, including how an attacker might exploit the issue

This information will help us triage your report more quickly.

As a volunteer-led project, we are not able to offer bug bounties.
However, we'd be happy to send you Sudo stickers as a way of saying
thank you!

## Preferred Languages

We prefer all communications to be in English.

## Disclosure Policy

The Sudo Project follows the principle of [Coordinated Vulnerability Disclosure](https://vuls.cert.org/confluence/display/CVD/Executive+Summary).  Disclosure is usually coordinated using the [distros mailing list](https://oss-security.openwall.org/wiki/mailing-lists/distros).

## Security Advisories

The Sudo web site contains an archive of [sudo security advisories](https://www.sudo.ws/security/advisories/).
Additionally, information about vulnerabilities in sudo is sent to the
[oss-security mailing list](https://oss-security.openwall.org/wiki/mailing-lists/oss-security) once the information becomes public.
