"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _jsYaml = require("js-yaml");
var _moment = _interopRequireDefault(require("moment"));
var _constants2 = require("../../common/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class RulesService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend POST Rules API.
     */
    _defineProperty(this, "createRule", async (context, request, response) => {
      try {
        const {
          id,
          title,
          category,
          description,
          detection,
          status,
          author,
          references,
          tags,
          level,
          false_positives
        } = request.body;
        const today = (0, _moment.default)(_moment.default.now()).format('YYYY/MM/DD');
        const jsonPayload = {
          id: id || _constants2.DEFAULT_RULE_UUID,
          title,
          description: description || title,
          status,
          author,
          date: today,
          modified: today,
          logsource: {
            category
          },
          level,
          detection: (0, _jsYaml.load)(detection)
        };
        if (tags.length > 0) {
          jsonPayload['tags'] = tags.map(tag => tag.value);
        }
        if (references.length > 0) {
          jsonPayload['references'] = references.map(ref => ref.value);
        }
        if (false_positives.length > 0) {
          jsonPayload['falsepositives'] = false_positives.map(falsePos => falsePos.value);
        }
        const ruleYamlPayload = (0, _jsYaml.safeDump)(jsonPayload);
        const params = {
          body: ruleYamlPayload,
          category: encodeURIComponent(category)
        };
        const client = this.getClient(request, context);
        const createRuleResponse = await client(_constants.CLIENT_RULE_METHODS.CREATE_RULE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createRuleResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - RulesService - createRule:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getRules", async (context, request, response) => {
      try {
        const {
          prePackaged
        } = request.query;
        const params = {
          prePackaged,
          body: request.body
        };
        const client = this.getClient(request, context);
        const getRuleResponse = await client(_constants.CLIENT_RULE_METHODS.GET_RULES, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getRuleResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - RulesService - getRules:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "deleteRule", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const deleteRuleResponse = await client(_constants.CLIENT_RULE_METHODS.DELETE_RULE, request.params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteRuleResponse
          }
        });
      } catch (error) {
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend PUT Rules API.
     */
    _defineProperty(this, "updateRule", async (context, request, response) => {
      try {
        const {
          id,
          title,
          category,
          description,
          detection,
          status,
          author,
          references,
          tags,
          level,
          false_positives
        } = request.body;
        const today = (0, _moment.default)(_moment.default.now()).format('YYYY/MM/DD');
        const {
          ruleId
        } = request.params;
        const jsonPayload = {
          id,
          title,
          description: description || title,
          status,
          author,
          date: today,
          modified: today,
          logsource: {
            category
          },
          level,
          detection: (0, _jsYaml.load)(detection)
        };
        if (tags.length > 0) {
          jsonPayload['tags'] = tags.map(tag => tag.value);
        }
        if (references.length > 0) {
          jsonPayload['references'] = references.map(ref => ref.value);
        }
        if (false_positives.length > 0) {
          jsonPayload['falsepositives'] = false_positives.map(falsePos => falsePos.value);
        }
        const ruleYamlPayload = (0, _jsYaml.safeDump)(jsonPayload);
        const params = {
          body: ruleYamlPayload,
          category,
          ruleId
        };
        const client = this.getClient(request, context);
        const createRuleResponse = await client(_constants.CLIENT_RULE_METHODS.UPDATE_RULE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createRuleResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - RulesService - updateRule:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = RulesService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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