"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupMetricsRoutes = setupMetricsRoutes;
var _constants = require("../utils/constants");
var _configSchema = require("@osd/config-schema");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupMetricsRoutes(services, router) {
  const {
    metricsService
  } = services;
  router.get({
    path: `${_constants.API.METRICS}`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, metricsService.getMetrics);
  router.post({
    path: `${_constants.API.METRICS}`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, metricsService.updateMetrics);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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