"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupFindingsRoutes = setupFindingsRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupFindingsRoutes(services, router) {
  const {
    findingsService
  } = services;
  router.get({
    path: `${_constants.API.GET_FINDINGS}`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        detectorType: _configSchema.schema.maybe(_configSchema.schema.string()),
        detector_id: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortOrder: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.maybe(_configSchema.schema.number()),
        startIndex: _configSchema.schema.maybe(_configSchema.schema.number()),
        detectionType: _configSchema.schema.maybe(_configSchema.schema.string()),
        severity: _configSchema.schema.maybe(_configSchema.schema.string()),
        searchString: _configSchema.schema.maybe(_configSchema.schema.string()),
        findingIds: _configSchema.schema.maybe(_configSchema.schema.string()),
        startTime: _configSchema.schema.maybe(_configSchema.schema.number()),
        endTime: _configSchema.schema.maybe(_configSchema.schema.number())
      })
    }
  }, findingsService.getFindings);
  router.get({
    path: `${_constants.API.THREAT_INTEL_BASE}/findings/_search`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        sortOrder: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.maybe(_configSchema.schema.number()),
        startIndex: _configSchema.schema.maybe(_configSchema.schema.number()),
        searchString: _configSchema.schema.maybe(_configSchema.schema.string()),
        findingIds: _configSchema.schema.maybe(_configSchema.schema.string()),
        startTime: _configSchema.schema.maybe(_configSchema.schema.number()),
        endTime: _configSchema.schema.maybe(_configSchema.schema.number()),
        iocIds: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, findingsService.getThreatIntelFindings);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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