"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupFieldMappingRoutes = setupFieldMappingRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupFieldMappingRoutes(services, router) {
  const {
    fieldMappingService
  } = services;
  router.get({
    path: _constants.API.MAPPINGS_VIEW,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        indexName: _configSchema.schema.string(),
        ruleTopic: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, fieldMappingService.getMappingsView);
  router.get({
    path: _constants.API.MAPPINGS_BASE,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        indexName: _configSchema.schema.string()
      })
    }
  }, fieldMappingService.getMappings);
  router.post({
    path: _constants.API.MAPPINGS_BASE,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, fieldMappingService.createMappings);
  router.get({
    path: `${_constants.API.MAPPINGS_BASE}/fields/{indexName}`,
    validate: {
      params: _configSchema.schema.object({
        indexName: _configSchema.schema.string()
      })
    }
  }, fieldMappingService.getIndexAliasFields);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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