"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityAnalyticsPlugin = void 0;
var _createSecurityAnalyticsCluster = require("./clusters/createSecurityAnalyticsCluster");
var _routes = require("./routes");
var _MetricsRoutes = require("./routes/MetricsRoutes");
var _services = require("./services");
var _LogTypeService = require("./services/LogTypeService");
var _MetricsService = _interopRequireDefault(require("./services/MetricsService"));
var _securityAnalyticsPlugin = require("./clusters/securityAnalyticsPlugin");
var _ThreatIntelService = _interopRequireDefault(require("./services/ThreatIntelService"));
var _ThreatIntel = require("./routes/ThreatIntel");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class SecurityAnalyticsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  async setup(core, {
    dataSource
  }) {
    // Create OpenSearch client that aware of SA API endpoints
    const securityAnalyticsClient = (0, _createSecurityAnalyticsCluster.createSecurityAnalyticsCluster)(core);
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_securityAnalyticsPlugin.securityAnalyticsPlugin);
    }

    // Initialize services
    const services = {
      detectorsService: new _services.DetectorService(securityAnalyticsClient, dataSourceEnabled),
      correlationService: new _services.CorrelationService(securityAnalyticsClient, dataSourceEnabled),
      indexService: new _services.IndexService(securityAnalyticsClient, dataSourceEnabled),
      findingsService: new _services.FindingsService(securityAnalyticsClient, dataSourceEnabled),
      opensearchService: new _services.OpenSearchService(securityAnalyticsClient, dataSourceEnabled),
      fieldMappingService: new _services.FieldMappingService(securityAnalyticsClient, dataSourceEnabled),
      alertService: new _services.AlertService(securityAnalyticsClient, dataSourceEnabled),
      rulesService: new _services.RulesService(securityAnalyticsClient, dataSourceEnabled),
      notificationsService: new _services.NotificationsService(securityAnalyticsClient, dataSourceEnabled),
      logTypeService: new _LogTypeService.LogTypeService(securityAnalyticsClient, dataSourceEnabled),
      metricsService: new _MetricsService.default(),
      threatIntelService: new _ThreatIntelService.default(securityAnalyticsClient, dataSourceEnabled)
    };

    // Create router
    const router = core.http.createRouter();

    // setup routes
    (0, _routes.setupDetectorRoutes)(services, router);
    (0, _routes.setupCorrelationRoutes)(services, router);
    (0, _routes.setupIndexRoutes)(services, router);
    (0, _routes.setupFindingsRoutes)(services, router);
    (0, _routes.setupOpensearchRoutes)(services, router);
    (0, _routes.setupFieldMappingRoutes)(services, router);
    (0, _routes.setupAlertsRoutes)(services, router);
    (0, _routes.setupRulesRoutes)(services, router);
    (0, _routes.setupNotificationsRoutes)(services, router);
    (0, _routes.setupLogTypeRoutes)(services, router);
    (0, _MetricsRoutes.setupMetricsRoutes)(services, router);
    (0, _ThreatIntel.setupThreatIntelRoutes)(services, router);

    // @ts-ignore
    const config$ = this.initializerContext.config.create();
    return {
      config$
    };
  }
  async start(_core) {
    return {};
  }
}
exports.SecurityAnalyticsPlugin = SecurityAnalyticsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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