"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// @ts-check
// workaround for Safari support before https://github.com/niklasvh/html2canvas/pull/2911 is merged
const https = require('https');
const fs = require('fs');
const replace = require('replace-in-file');
const options = {
  files: [__dirname + '/../node_modules/html2canvas/**/*.js', __dirname + '/../node_modules/html2canvas/**/*.js.map'],
  from: 'if (image.width === width && image.height === height) {',
  to: 'if (false && image.width === width && image.height === height) {'
};
try {
  const changedFiles = replace.sync(options);
  console.log('Modified files for html2canvas Safari support:\n', changedFiles.filter(file => file.hasChanged).map(file => file.file).join('\n'));
} catch (error) {
  console.error('Error occurred when modifiying files for html2canvas Safari support:', error);
}

// download tesseract model
const modelFile = fs.createWriteStream(__dirname + '/../common/tesseract/eng.traineddata.gz');
https.get('https://raw.githubusercontent.com/naptha/tessdata/gh-pages/4.0.0_best/eng.traineddata.gz', function (response) {
  response.pipe(modelFile);
  modelFile.on('finish', () => {
    modelFile.close();
    console.log('Downloaded eng.traineddata.gz for tesseract.js');
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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