"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createSqlCluster;
var _sqlPlugin = _interopRequireDefault(require("./sqlPlugin"));
var _constants = require("../../services/utils/constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createSqlCluster(server) {
  const {
    customHeaders,
    ...rest
  } = server.config().get('opensearch');
  server.plugins.opensearch.createCluster(_constants.CLUSTER.SQL, {
    plugins: [_sqlPlugin.default],
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc3FsUGx1Z2luIiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJfY29uc3RhbnRzIiwib2JqIiwiX19lc01vZHVsZSIsImRlZmF1bHQiLCJjcmVhdGVTcWxDbHVzdGVyIiwic2VydmVyIiwiY3VzdG9tSGVhZGVycyIsInJlc3QiLCJjb25maWciLCJnZXQiLCJwbHVnaW5zIiwib3BlbnNlYXJjaCIsImNyZWF0ZUNsdXN0ZXIiLCJDTFVTVEVSIiwiU1FMIiwic3FsUGx1Z2luIiwiREVGQVVMVF9IRUFERVJTIiwibW9kdWxlIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbImNyZWF0ZVNxbENsdXN0ZXIuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5cbmltcG9ydCBzcWxQbHVnaW4gZnJvbSAnLi9zcWxQbHVnaW4nO1xuaW1wb3J0IHsgQ0xVU1RFUiwgREVGQVVMVF9IRUFERVJTIH0gZnJvbSAnLi4vLi4vc2VydmljZXMvdXRpbHMvY29uc3RhbnRzJztcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gY3JlYXRlU3FsQ2x1c3RlcihzZXJ2ZXIpIHtcbiAgY29uc3QgeyBjdXN0b21IZWFkZXJzLCAuLi5yZXN0IH0gPSBzZXJ2ZXIuY29uZmlnKCkuZ2V0KCdvcGVuc2VhcmNoJyk7XG4gIHNlcnZlci5wbHVnaW5zLm9wZW5zZWFyY2guY3JlYXRlQ2x1c3RlcihcbiAgICBDTFVTVEVSLlNRTCxcbiAgICB7XG4gICAgICBwbHVnaW5zOiBbIHNxbFBsdWdpbiBdLFxuICAgICAgY3VzdG9tSGVhZGVyczogeyAuLi5jdXN0b21IZWFkZXJzLCAuLi5ERUZBVUxUX0hFQURFUlMgfSxcbiAgICAgIC4uLnJlc3QsXG4gICAgfVxuICApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFNQSxJQUFBQSxVQUFBLEdBQUFDLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBQyxVQUFBLEdBQUFELE9BQUE7QUFBMEUsU0FBQUQsdUJBQUFHLEdBQUEsV0FBQUEsR0FBQSxJQUFBQSxHQUFBLENBQUFDLFVBQUEsR0FBQUQsR0FBQSxLQUFBRSxPQUFBLEVBQUFGLEdBQUE7QUFQMUU7QUFDQTtBQUNBO0FBQ0E7O0FBTWUsU0FBU0csZ0JBQWdCQSxDQUFDQyxNQUFNLEVBQUU7RUFDL0MsTUFBTTtJQUFFQyxhQUFhO0lBQUUsR0FBR0M7RUFBSyxDQUFDLEdBQUdGLE1BQU0sQ0FBQ0csTUFBTSxDQUFDLENBQUMsQ0FBQ0MsR0FBRyxDQUFDLFlBQVksQ0FBQztFQUNwRUosTUFBTSxDQUFDSyxPQUFPLENBQUNDLFVBQVUsQ0FBQ0MsYUFBYSxDQUNyQ0Msa0JBQU8sQ0FBQ0MsR0FBRyxFQUNYO0lBQ0VKLE9BQU8sRUFBRSxDQUFFSyxrQkFBUyxDQUFFO0lBQ3RCVCxhQUFhLEVBQUU7TUFBRSxHQUFHQSxhQUFhO01BQUUsR0FBR1U7SUFBZ0IsQ0FBQztJQUN2RCxHQUFHVDtFQUNMLENBQ0YsQ0FBQztBQUNIO0FBQUNVLE1BQUEsQ0FBQUMsT0FBQSxHQUFBQSxPQUFBLENBQUFmLE9BQUEifQ==