"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateV1IntegrationToV2Integration = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Documents that may be the old serialization format. Only used in migrations.
 */

const migrateV1IntegrationToV2Integration = doc => {
  const integration = doc.attributes;
  // First check if there's anything to do
  if (Array.isArray(integration.assets)) {
    return doc;
  }

  // Migrate different properties separately
  const copy = {
    ...integration,
    assets: []
  };
  if (integration.assets.savedObjects) {
    const bundle = integration.assets.savedObjects;
    copy.assets.push({
      name: bundle.name,
      version: bundle.version,
      extension: 'ndjson',
      type: 'savedObjectBundle',
      data: bundle.data
    });
  }
  if (integration.assets.queries) {
    copy.assets.push(...integration.assets.queries.map(q => ({
      name: q.name,
      version: q.version,
      extension: q.language,
      type: 'query',
      data: q.data
    })));
  }
  return {
    ...doc,
    attributes: copy
  };
};
exports.migrateV1IntegrationToV2Integration = migrateV1IntegrationToV2Integration;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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