"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandPalette = void 0;
const react_1 = __importDefault(require("react"));
const icons_1 = require("../icons");
const key_tag_1 = require("./key-tag");
class CommandPalette extends react_1.default.PureComponent {
    constructor() {
        super(...arguments);
        this.state = {
            selectedItemIndex: 0,
        };
        this.items = react_1.default.createRef();
        this.handleKeys = (event) => {
            if (event.key === "ArrowDown") {
                this.setState((previous) => {
                    const { children } = this.props;
                    const childLength = Array.isArray(children) ? children.length : 1;
                    const nextIndex = previous.selectedItemIndex + 1 > childLength
                        ? 1
                        : previous.selectedItemIndex + 1;
                    return { selectedItemIndex: nextIndex };
                });
            }
            if (event.key === "ArrowUp") {
                this.setState((previous) => {
                    const { children } = this.props;
                    const childLength = Array.isArray(children) ? children.length : 1;
                    const nextIndex = previous.selectedItemIndex - 1 === 0
                        ? childLength
                        : previous.selectedItemIndex - 1;
                    return { selectedItemIndex: nextIndex };
                });
            }
        };
        this.handleChangeFilter = (e) => {
            this.props.onChangeFilter(e.target.value);
        };
        this.handleInputFocus = () => {
            this.setState({ selectedItemIndex: 0 });
        };
    }
    componentDidMount() {
        const element = document.querySelector(".command-palette input");
        addEventListener("keydown", this.handleKeys);
        element.focus();
    }
    componentWillUnmount() {
        removeEventListener("keydown", this.handleKeys);
    }
    componentDidUpdate() {
        if (this.state.selectedItemIndex !== 0) {
            const item = this.items.current &&
                this.items.current.querySelector(`button:nth-child(${this.state.selectedItemIndex})`);
            if (item) {
                item.focus();
            }
        }
    }
    render() {
        const { isVisible, onClose, shortCut, children } = this.props;
        const mainClassName = isVisible
            ? "command-palette visible"
            : "command-palette";
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("div", { className: "command-palette-overlay", onClick: onClose, role: "button", "aria-label": "Close command palette" }),
            react_1.default.createElement("div", { className: mainClassName, tabIndex: -1 },
                react_1.default.createElement("div", { className: "command-palette-row" },
                    react_1.default.createElement("span", { className: "command-palette-heading" },
                        react_1.default.createElement(icons_1.Commands, { muted: true }),
                        "nteract Command"),
                    react_1.default.createElement(key_tag_1.KeyTag, null,
                        "Hide Menu Bar",
                        shortCut.map((shortcutKey) => (react_1.default.createElement(key_tag_1.KeyTag, { mini: true, key: shortcutKey }, shortcutKey))))),
                react_1.default.createElement("div", { className: "command-palette-input-row" },
                    react_1.default.createElement("label", { htmlFor: "commandFilter" }, "Filter commands"),
                    react_1.default.createElement("input", { onFocus: this.handleInputFocus, onChange: this.handleChangeFilter, type: "text", name: "commandFilter", id: "commandFilter", placeholder: "Filter commands" })),
                react_1.default.createElement("div", { className: "items", ref: this.items }, children))));
    }
}
exports.CommandPalette = CommandPalette;
//# sourceMappingURL=command-palette.js.map