"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileService = void 0;
var _constants = require("./utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

class ProfileService {
  static convertModel(model, id) {
    var _model$target_worker_;
    return {
      id,
      target_worker_nodes: model.target_worker_nodes,
      worker_nodes: model.worker_nodes,
      not_worker_nodes: (_model$target_worker_ = model.target_worker_nodes.filter(nodeId => {
        var _model$worker_nodes;
        return !((_model$worker_nodes = model.worker_nodes) !== null && _model$worker_nodes !== void 0 && _model$worker_nodes.includes(nodeId));
      })) !== null && _model$target_worker_ !== void 0 ? _model$target_worker_ : []
    };
  }
  static async getModel(params) {
    const {
      transport,
      modelId
    } = params;
    const result = (await transport.request({
      method: 'GET',
      path: `${_constants.PROFILE_BASE_API}/models/${modelId}?view=model`
    })).body;
    if (!result.models) {
      return {};
    }
    const model = result.models[modelId];
    return this.convertModel(model, modelId);
  }
}
exports.ProfileService = ProfileService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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