"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOpenSearchClientTransport = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getOpenSearchClientTransport = async ({
  context,
  dataSourceId
}) => {
  if (dataSourceId && context.dataSource) {
    return (await context.dataSource.opensearch.getClient(dataSourceId)).transport;
  }
  return context.core.opensearch.client.asCurrentUser.transport;
};
exports.getOpenSearchClientTransport = getOpenSearchClientTransport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJnZXRPcGVuU2VhcmNoQ2xpZW50VHJhbnNwb3J0IiwiY29udGV4dCIsImRhdGFTb3VyY2VJZCIsImRhdGFTb3VyY2UiLCJvcGVuc2VhcmNoIiwiZ2V0Q2xpZW50IiwidHJhbnNwb3J0IiwiY29yZSIsImNsaWVudCIsImFzQ3VycmVudFVzZXIiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsiZ2V0X29wZW5zZWFyY2hfY2xpZW50X3RyYW5zcG9ydC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IE9wZW5TZWFyY2hDbGllbnQsIFJlcXVlc3RIYW5kbGVyQ29udGV4dCB9IGZyb20gJy4uLy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XG5cbmV4cG9ydCBjb25zdCBnZXRPcGVuU2VhcmNoQ2xpZW50VHJhbnNwb3J0ID0gYXN5bmMgKHtcbiAgY29udGV4dCxcbiAgZGF0YVNvdXJjZUlkLFxufToge1xuICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQgJiB7XG4gICAgZGF0YVNvdXJjZT86IHtcbiAgICAgIG9wZW5zZWFyY2g6IHtcbiAgICAgICAgZ2V0Q2xpZW50OiAoZGF0YVNvdXJjZUlkOiBzdHJpbmcpID0+IFByb21pc2U8T3BlblNlYXJjaENsaWVudD47XG4gICAgICB9O1xuICAgIH07XG4gIH07XG4gIGRhdGFTb3VyY2VJZD86IHN0cmluZztcbn0pID0+IHtcbiAgaWYgKGRhdGFTb3VyY2VJZCAmJiBjb250ZXh0LmRhdGFTb3VyY2UpIHtcbiAgICByZXR1cm4gKGF3YWl0IGNvbnRleHQuZGF0YVNvdXJjZS5vcGVuc2VhcmNoLmdldENsaWVudChkYXRhU291cmNlSWQpKS50cmFuc3BvcnQ7XG4gIH1cbiAgcmV0dXJuIGNvbnRleHQuY29yZS5vcGVuc2VhcmNoLmNsaWVudC5hc0N1cnJlbnRVc2VyLnRyYW5zcG9ydDtcbn07XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQUlPLE1BQU1BLDRCQUE0QixHQUFHLE1BQUFBLENBQU87RUFDakRDLE9BQU87RUFDUEM7QUFVRixDQUFDLEtBQUs7RUFDSixJQUFJQSxZQUFZLElBQUlELE9BQU8sQ0FBQ0UsVUFBVSxFQUFFO0lBQ3RDLE9BQU8sQ0FBQyxNQUFNRixPQUFPLENBQUNFLFVBQVUsQ0FBQ0MsVUFBVSxDQUFDQyxTQUFTLENBQUNILFlBQVksQ0FBQyxFQUFFSSxTQUFTO0VBQ2hGO0VBQ0EsT0FBT0wsT0FBTyxDQUFDTSxJQUFJLENBQUNILFVBQVUsQ0FBQ0ksTUFBTSxDQUFDQyxhQUFhLENBQUNILFNBQVM7QUFDL0QsQ0FBQztBQUFDSSxPQUFBLENBQUFWLDRCQUFBLEdBQUFBLDRCQUFBIn0=