"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PADDING_SIZES = exports.FONT_SIZES = exports.EuiCodeBlockImpl = void 0;

var _react = _interopRequireDefault(require("react"));

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiCodeBlockImpl = function EuiCodeBlockImpl(_ref) {
  var children = _ref.children,
      inline = _ref.inline,
      dataTestSubj = _ref['data-test-subj'];

  var snippet = /*#__PURE__*/_react.default.createElement("code", {
    "data-test-subj": dataTestSubj
  }, children);

  return inline ? /*#__PURE__*/_react.default.createElement("span", null, snippet) : /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("pre", null, snippet));
};

exports.EuiCodeBlockImpl = EuiCodeBlockImpl;
var FONT_SIZES = ['s', 'm', 'l'];
exports.FONT_SIZES = FONT_SIZES;
var PADDING_SIZES = ['none', 's', 'm', 'l'];
exports.PADDING_SIZES = PADDING_SIZES;