"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOnClickCaller = void 0;
var __1 = require("../../..");
var create_selector_1 = require("../../../../state/create_selector");
var get_last_click_1 = require("../../../../state/selectors/get_last_click");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var utils_1 = require("../../../../state/utils");
var get_projected_scaled_values_1 = require("./get_projected_scaled_values");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
function createOnClickCaller() {
    var prevClick = null;
    var selector = null;
    return function (state) {
        if (selector) {
            return selector(state);
        }
        if (state.chartType !== __1.ChartType.XYAxis) {
            return;
        }
        selector = create_selector_1.createCustomCachedSelector([get_last_click_1.getLastClickSelector, get_settings_specs_1.getSettingsSpecSelector, get_tooltip_values_highlighted_geoms_1.getHighlightedGeomsSelector, get_projected_scaled_values_1.getProjectedScaledValues], function (lastClick, _a, indexedGeometries, values) {
            var onElementClick = _a.onElementClick, onProjectionClick = _a.onProjectionClick;
            if (!utils_1.isClicking(prevClick, lastClick)) {
                return;
            }
            var elementClickFired = tryFiringOnElementClick(indexedGeometries, onElementClick);
            if (!elementClickFired) {
                tryFiringOnProjectionClick(values, onProjectionClick);
            }
            prevClick = lastClick;
        });
    };
}
exports.createOnClickCaller = createOnClickCaller;
function tryFiringOnElementClick(indexedGeometries, onElementClick) {
    if (indexedGeometries.length === 0 || !onElementClick) {
        return false;
    }
    var elements = indexedGeometries.map(function (_a) {
        var value = _a.value, seriesIdentifier = _a.seriesIdentifier;
        return [
            value,
            seriesIdentifier,
        ];
    });
    onElementClick(elements);
    return true;
}
function tryFiringOnProjectionClick(values, onProjectionClick) {
    if (values === undefined || !onProjectionClick) {
        return false;
    }
    onProjectionClick(values);
    return true;
}
//# sourceMappingURL=on_click_caller.js.map