"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.coerceYScaleTypes = exports.isStackedSpec = exports.isHistogramEnabled = exports.groupSeriesByYGroup = exports.mergeYDomain = void 0;
var constants_1 = require("../../../scales/constants");
var common_1 = require("../../../utils/common");
var domain_1 = require("../../../utils/domain");
var logger_1 = require("../../../utils/logger");
var spec_1 = require("../state/utils/spec");
var axis_type_utils_1 = require("../utils/axis_type_utils");
var group_data_series_1 = require("../utils/group_data_series");
var specs_1 = require("../utils/specs");
var nice_1 = require("./nice");
function mergeYDomain(dataSeries, yScaleAPIConfig) {
    var dataSeriesByGroupId = group_data_series_1.groupBy(dataSeries, function (_a) {
        var spec = _a.spec;
        return spec_1.getSpecDomainGroupId(spec);
    }, true);
    return dataSeriesByGroupId.reduce(function (acc, groupedDataSeries) {
        var stacked = groupedDataSeries.filter(function (_a) {
            var isStacked = _a.isStacked, isFiltered = _a.isFiltered;
            return isStacked && !isFiltered;
        });
        var nonStacked = groupedDataSeries.filter(function (_a) {
            var isStacked = _a.isStacked, isFiltered = _a.isFiltered;
            return !isStacked && !isFiltered;
        });
        var hasNonZeroBaselineTypes = groupedDataSeries.some(function (_a) {
            var seriesType = _a.seriesType, isFiltered = _a.isFiltered;
            return seriesType === specs_1.SeriesType.Bar || (seriesType === specs_1.SeriesType.Area && !isFiltered);
        });
        var domain = mergeYDomainForGroup(stacked, nonStacked, hasNonZeroBaselineTypes, yScaleAPIConfig);
        if (!domain) {
            return acc;
        }
        return __spread(acc, [domain]);
    }, []);
}
exports.mergeYDomain = mergeYDomain;
function mergeYDomainForGroup(stacked, nonStacked, hasZeroBaselineSpecs, yScaleConfig) {
    var dataSeries = __spread(stacked, nonStacked);
    if (dataSeries.length === 0) {
        return null;
    }
    var _a = __read(dataSeries, 1), _b = _a[0], stackMode = _b.stackMode, spec = _b.spec;
    var groupId = spec_1.getSpecDomainGroupId(spec);
    var _c = yScaleConfig[groupId], customDomain = _c.customDomain, type = _c.type, nice = _c.nice, desiredTickCount = _c.desiredTickCount;
    var newCustomDomain = customDomain ? __assign({}, customDomain) : {};
    var paddingUnit = newCustomDomain.paddingUnit, padding = newCustomDomain.padding, constrainPadding = newCustomDomain.constrainPadding;
    var domain;
    if (stackMode === specs_1.StackMode.Percentage) {
        domain = domain_1.computeContinuousDataDomain([0, 1], common_1.identity, type, customDomain);
    }
    else {
        var stackedDomain = computeYDomain(stacked, hasZeroBaselineSpecs, type, newCustomDomain);
        var nonStackedDomain = computeYDomain(nonStacked, hasZeroBaselineSpecs, type, newCustomDomain);
        domain = domain_1.computeContinuousDataDomain(__spread(stackedDomain, nonStackedDomain), common_1.identity, type, newCustomDomain);
        var _d = __read(domain, 2), computedDomainMin = _d[0], computedDomainMax = _d[1];
        if (newCustomDomain && axis_type_utils_1.isCompleteBound(newCustomDomain)) {
            domain = [newCustomDomain.min, newCustomDomain.max];
        }
        else if (newCustomDomain && axis_type_utils_1.isLowerBound(newCustomDomain)) {
            if (newCustomDomain.min > computedDomainMax) {
                logger_1.Logger.warn("custom yDomain for " + groupId + " is invalid, custom min is greater than computed max.");
                domain = [newCustomDomain.min, newCustomDomain.min];
            }
            else {
                domain = [newCustomDomain.min, computedDomainMax];
            }
        }
        else if (newCustomDomain && axis_type_utils_1.isUpperBound(newCustomDomain)) {
            if (computedDomainMin > newCustomDomain.max) {
                logger_1.Logger.warn("custom yDomain for " + groupId + " is invalid, custom max is less than computed max.");
                domain = [newCustomDomain.max, newCustomDomain.max];
            }
            else {
                domain = [computedDomainMin, newCustomDomain.max];
            }
        }
    }
    return {
        type: type,
        nice: nice,
        isBandScale: false,
        groupId: groupId,
        domain: domain,
        logBase: customDomain === null || customDomain === void 0 ? void 0 : customDomain.logBase,
        logMinLimit: customDomain === null || customDomain === void 0 ? void 0 : customDomain.logMinLimit,
        desiredTickCount: desiredTickCount,
        domainPixelPadding: paddingUnit === specs_1.DomainPaddingUnit.Pixel ? padding : 0,
        constrainDomainPadding: constrainPadding,
    };
}
function computeYDomain(dataSeries, hasZeroBaselineSpecs, scaleType, customDomain) {
    var yValues = new Set();
    dataSeries.forEach(function (_a) {
        var data = _a.data;
        for (var i = 0; i < data.length; i++) {
            var datum = data[i];
            yValues.add(datum.y1);
            if (hasZeroBaselineSpecs && datum.y0 != null) {
                yValues.add(datum.y0);
            }
        }
    });
    if (yValues.size === 0) {
        return [];
    }
    var domainOptions = __assign(__assign({}, customDomain), { padding: 0 });
    return domain_1.computeContinuousDataDomain(__spread(yValues.values()), common_1.identity, scaleType, domainOptions);
}
function groupSeriesByYGroup(specs) {
    var specsByGroupIds = new Map();
    var histogramEnabled = isHistogramEnabled(specs);
    specs.forEach(function (spec) {
        var group = specsByGroupIds.get(spec.groupId) || {
            stackMode: undefined,
            stacked: [],
            nonStacked: [],
        };
        if (isStackedSpec(spec, histogramEnabled)) {
            group.stacked.push(spec);
        }
        else {
            group.nonStacked.push(spec);
        }
        if (group.stackMode === undefined && spec.stackMode !== undefined) {
            group.stackMode = spec.stackMode;
        }
        if (spec.stackMode !== undefined && group.stackMode !== undefined && group.stackMode !== spec.stackMode) {
            logger_1.Logger.warn("Is not possible to mix different stackModes, please align all stackMode on the same GroupId\n      to the same mode. The default behaviour will be to use the first encountered stackMode on the series");
        }
        specsByGroupIds.set(spec.groupId, group);
    });
    return specsByGroupIds;
}
exports.groupSeriesByYGroup = groupSeriesByYGroup;
function isHistogramEnabled(specs) {
    return specs.some(function (_a) {
        var seriesType = _a.seriesType, enableHistogramMode = _a.enableHistogramMode;
        return seriesType === specs_1.SeriesType.Bar && enableHistogramMode;
    });
}
exports.isHistogramEnabled = isHistogramEnabled;
function isStackedSpec(spec, histogramEnabled) {
    var isBarAndHistogram = spec.seriesType === specs_1.SeriesType.Bar && histogramEnabled;
    var hasStackAccessors = spec.stackAccessors && spec.stackAccessors.length > 0;
    return isBarAndHistogram || hasStackAccessors;
}
exports.isStackedSpec = isStackedSpec;
function coerceYScaleTypes(scales) {
    var scaleCollection = scales.reduce(function (acc, scale) {
        acc.types.add(scale.type);
        acc.nice.push(scale.nice);
        return acc;
    }, {
        types: new Set(),
        nice: [],
    });
    var nice = nice_1.areAllNiceDomain(scaleCollection.nice);
    return scaleCollection.types.size === 1
        ? { type: scaleCollection.types.values().next().value, nice: nice }
        : {
            type: constants_1.ScaleType.Linear,
            nice: nice,
        };
}
exports.coerceYScaleTypes = coerceYScaleTypes;
//# sourceMappingURL=y_domain.js.map