"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getXAxisRightOverflow = void 0;
var scales_1 = require("../../../../scales");
var constants_1 = require("../../../../scales/constants");
var create_selector_1 = require("../../../../state/create_selector");
var canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
var get_heatmap_config_1 = require("./get_heatmap_config");
var get_heatmap_table_1 = require("./get_heatmap_table");
exports.getXAxisRightOverflow = create_selector_1.createCustomCachedSelector([get_heatmap_config_1.getHeatmapConfigSelector, get_heatmap_table_1.getHeatmapTableSelector], function (_a, _b) {
    var _c = _a.xAxisLabel, fontSize = _c.fontSize, fontFamily = _c.fontFamily, padding = _c.padding, formatter = _c.formatter, width = _c.width, timeZone = _a.timeZone;
    var xDomain = _b.xDomain;
    if (xDomain.type !== constants_1.ScaleType.Time) {
        return 0;
    }
    if (typeof width === 'number') {
        return width / 2;
    }
    var timeScale = new scales_1.ScaleContinuous({
        type: constants_1.ScaleType.Time,
        domain: xDomain.domain,
        range: [0, 1],
    }, {
        timeZone: timeZone,
    });
    var bboxCompute = new canvas_text_bbox_calculator_1.CanvasTextBBoxCalculator();
    var maxTextWidth = timeScale.ticks().reduce(function (acc, d) {
        var text = formatter(d);
        var textSize = bboxCompute.compute(text, padding, fontSize, fontFamily, 1);
        return Math.max(acc, textSize.width + padding);
    }, 0);
    bboxCompute.destroy();
    return maxTextWidth / 2;
});
//# sourceMappingURL=get_x_axis_right_overflow.js.map