/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.header.Parameters;
import aQute.bnd.memoize.Memoize;
import aQute.bnd.osgi.About;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.base64.Base64;
import aQute.lib.date.Dates;
import aQute.lib.filter.ExtendedFilter;
import aQute.lib.formatter.Formatters;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.glob.Glob;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class Macro {
    private static final String NULLVALUE = "c29e43048791e250dfd5723e7b8aa048df802c9262cfa8fbc4475b2e392a8ad2";
    private static final String LITERALVALUE = "017a3ddbfc0fcd27bcdb2590cdb713a379ae59ef";
    private static final Pattern NUMERIC_P = Pattern.compile("[-+]?(\\d*\\.?\\d+|\\d+\\.)(e[-+]?[0-9]+)?");
    Processor domain;
    Reporter reporter;
    Object[] targets;
    boolean flattening;
    private boolean nosystem;
    public boolean inTest;
    private final Map<Class<?>, Map<String, BiFunction<Object, String[], Object>>> macrosByClass = new ConcurrentHashMap();
    private static final String ESCAPING = "(?<!(?<!(?<!(?<!\\\\)\\\\)\\\\)\\\\)";
    private static final String SEMICOLON = ";";
    private static final String ESCAPED_SEMICOLON = "\\\\;";
    private static final Pattern SEMICOLON_P = Pattern.compile("(?<!(?<!(?<!(?<!\\\\)\\\\)\\\\)\\\\);");
    private static final Pattern ESCAPED_SEMICOLON_P = Pattern.compile("(?<!(?<!(?<!(?<!\\\\)\\\\)\\\\)\\\\)\\\\;");
    static final String _uniqHelp = "${uniq;<list> ...}";
    static final String _removeallHelp = "${removeall;<list>;<list>}";
    static final String _retainallHelp = "${retainall;<list>;<list>}";
    static final String _filterHelp = "${%s;<list>;<regex>}";
    static final String _sortHelp = "${sort;<list>...}";
    static final String _nsortHelp = "${nsort;<list>...}";
    static final String _joinHelp = "${join;<list>...}";
    static final String _sjoinHelp = "${sjoin;<separator>;<list>...}";
    static final String _ifHelp = "${if;<condition>;<iftrue> [;<iffalse>] } condition is either a filter expression or truthy";
    private static final DateTimeFormatter DATE_TOSTRING = Dates.DATE_TOSTRING.withZone(Dates.UTC_ZONE_ID);
    public static final String _nowHelp = "${now;pattern|'long'}, returns current time";
    public static final String _fmodifiedHelp = "${fmodified;<list of filenames>...}, return latest modification date";
    static final String _defHelp = "${def;<name>[;<value>]}, get the property or a default value if unset";
    static final String _listHelp = "${list;[<name>...]}, returns a list of the values of the named properties with escaped semicolons";
    static final String _replaceHelp = "${replace;<list>;<regex>;[<replace>[;delimiter]]}";
    static final String _replacelistHelp = "${replacelist;<list>;<regex>;[<replace>[;delimiter]]}";
    static final String _replacestringHelp = "${replacesting;<target>;<regex>;[<replace>]}";
    private static final Pattern ANY = Pattern.compile(".*");
    private static final Pattern ERROR_P = Pattern.compile("\\$\\{error;");
    private static final Pattern WARNING_P = Pattern.compile("\\$\\{warning;");
    static final String _toclassnameHelp = "${toclassname;<list of class paths>}, convert class paths to FQN class names ";
    static final String _toclasspathHelp = "${toclasspath;<list>[;boolean]}, convert a list of class names to paths";
    static final String _lsrHelp = "${lsr;<dir>;[<selector>...]}";
    static final String _lsaHelp = "${lsa;<dir>;[<selector>...]}";
    private static final String MASK_M = "[-+=~\\d]";
    private static final String MASK_Q = "[=~sS\\d]";
    private static final String MASK_STRING = "[-+=~\\d](?:[-+=~\\d](?:[-+=~\\d](?:[=~sS\\d])?)?)?";
    private static final Pattern VERSION_MASK = Pattern.compile("[-+=~\\d](?:[-+=~\\d](?:[-+=~\\d](?:[=~sS\\d])?)?)?");
    static final String _versionmaskHelp = "${versionmask;<mask>;<version>}, modify a version\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='";
    static final String _versionHelp = "${versionmask;<mask>;<version>}, modify a version\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='";
    static final Pattern[] _versionPattern = new Pattern[]{null, VERSION_MASK};
    private static final Pattern RANGE_MASK = Pattern.compile("(\\[|\\()([-+=~\\d](?:[-+=~\\d](?:[-+=~\\d](?:[=~sS\\d])?)?)?),([-+=~\\d](?:[-+=~\\d](?:[-+=~\\d](?:[=~sS\\d])?)?)?)(\\]|\\))");
    static final String _rangeHelp = "${range;<mask>[;<version>]}, range for version, if version not specified lookup ${@}\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='";
    static final Pattern[] _rangePattern = new Pattern[]{null, RANGE_MASK};
    private static final String LOCALTARGET_NAME = "@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*";
    private static final Pattern LOCALTARGET_P = Pattern.compile("\\$(\\{@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\\}|\\[@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\\]|\\(@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\\)|<@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*>|\u00ab@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\u00bb|\u2039@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\u203a)");
    static final String _systemHelp = "${system;<command>[;<in>]}, execute a system command";
    static final String _system_allow_failHelp = "${system-allow-fail;<command>[;<in>]}, execute a system command allowing command failure";
    static final String _envHelp = "${env;<name>[;alternative]}, get the environment variable";
    static final String _catHelp = "${cat;<in>}, get the content of a file";
    static final String _base64Help = "${base64;<file>[;fileSizeLimit]}, get the Base64 encoding of a file";
    static final String _digestHelp = "${digest;<algo>;<in>}, get a digest (e.g. MD5, SHA-256) of a file";
    public static final String _fileHelp = "${file;<base>;<paths>...}, create correct OS dependent path";
    static final String _osfileHelp = "${osfile;<base>;<path>}, create correct OS dependent path";
    public static final String _sizeHelp = "${size;<collection>;...}, count the number of elements (of all collections combined)";
    static final String _startswithHelp = "${startswith;<string>;<prefix>}";
    static final String _endswithHelp = "${endswith;<string>;<suffix>}";
    static final String _extensionHelp = "${extension;<string>}";
    static final String _basenameextHelp = "${basenameext;<path>[;<extension>]}";
    static final String _bndversionHelp = "${bndversion}, returns the currently running bnd version";
    static final String _stemHelp = "${stem;<string>}";
    static final String _substringHelp = "${substring;<string>;<start>[;<end>]}";
    static final String _randHelp = "${rand;[<min>[;<end>]]}";
    static final Random random = new Random();
    static final String _lengthHelp = "${length;<string>}";
    static final String _getHelp = "${get;<index>;<list>}";
    static final String _sublistHelp = "${sublist;<start>;<end>[;<list>...]}";
    static final String _firstHelp = "${first;<list>[;<list>...]}";
    static final String _lastHelp = "${last;<list>[;<list>...]}";
    static final String _maxHelp = "${max;<list>[;<list>...]}";
    static final String _minHelp = "${min;<list>[;<list>...]}";
    static final String _nmaxHelp = "${nmax;<list>[;<list>...]}";
    static final String _nminHelp = "${nmin;<list>[;<list>...]}";
    static final String _vmaxHelp = "${vmax;<list>[;<list>...]}";
    static final String _vminHelp = "${vmin;<list>[;<list>...]}";
    static final String _sumHelp = "${sum;<list>[;<list>...]}";
    static final String _averageHelp = "${average;<list>[;<list>...]}";
    static final String _reverseHelp = "${reverse;<list>[;<list>...]}";
    static final String _indexofHelp = "${indexof;<value>;<list>[;<list>...]}";
    static final String _lastindexofHelp = "${lastindexof;<value>;<list>[;<list>...]}";
    static final String _findHelp = "${find;<target>;<searched>}";
    static final String _findlastHelp = "${findlast;<find>;<target>}";
    static final String _splitHelp = "${split;<regex>[;<target>...]}";
    static final String _jsHelp = "${js [;<js expr>...]}";
    static final String _toupperHelp = "${toupper;<target>}";
    static final String _tolowerHelp = "${tolower;<target>}";
    static final String _compareHelp = "${compare;<astring>;<bstring>}";
    static final String _ncompareHelp = "${ncompare;<anumber>;<bnumber>}";
    static final String _vcompareHelp = "${vcompare;<aversion>;<bversion>}";
    static final String _matchesHelp = "${matches;<target>;<regex>}";
    static final String _substHelp = "${subst;<target>;<regex>[;<replace>[;count]]}";
    static final String _trimHelp = "${trim;<target>}";
    static final String _formatHelp = "${format;<format>[;args...]}";
    static final String _isemptyHelp = "${isempty;[<target>...]}";
    static final String _isnumberHelp = "${isnumber;<target>[;<target>...]}";
    static final String _isHelp = "${is;<a>;<b>}";
    static final String _mapHelp = "${map;<macro>[;<list>...]}";
    static final String _foreachHelp = "${foreach;<macro>[;<list>...]}";
    static final String _applyHelp = "${apply;<macro>[;<list>...]}";
    static final String _globHelp = "${glob;<globexp>} (turn it into a regular expression)";
    static final String _templateHelp = "${template;macro-name[;template]+}";
    static final String _decoratedHelp = "${decorated;macro-name[;literals]}";
    static final String _fileuriHelp = "${fileuri;<path>}, Return a file uri for the specified path. Relative paths are resolved against the processor base.";
    static final String _version_cleanupHelp = "${version_cleanup;<version>}, Cleanup a potential maven version to make it match the OSGi Version syntax.";

    public Macro(Processor domain, Object ... targets) {
        this.domain = domain;
        this.reporter = domain;
        this.targets = targets;
        if (targets != null) {
            for (Object o : targets) {
                assert (o != null);
            }
        }
    }

    public String process(String line, Processor source) {
        return this.process((CharSequence)line, new Link(source, null, line));
    }

    String process(CharSequence line, Link link) {
        StringBuilder sb = new StringBuilder();
        this.process(line, 0, '\u0000', '\u0000', sb, link, false);
        return sb.toString();
    }

    int process(CharSequence org, int index, char begin, char end, StringBuilder result, Link link, boolean inMacro) {
        if (org == null) {
            return index;
        }
        StringBuilder line = new StringBuilder(org);
        int nesting = 1;
        ArrayList<String> args = inMacro ? new ArrayList<String>() : Collections.emptyList();
        StringBuilder variable = new StringBuilder();
        int pStart = 0;
        while (index < line.length()) {
            char c1;
            if ((c1 = line.charAt(index++)) == end) {
                if (--nesting == 0) {
                    args.add(variable.substring(pStart));
                    result.append(this.replace(variable.toString(), args, link, begin, end));
                    return index;
                }
            } else if (c1 == begin) {
                ++nesting;
            } else {
                if (c1 == '\\' && index < line.length() - 1 && (line.charAt(index) == '$' || line.charAt(index) == ';')) {
                    variable.append(line.charAt(index));
                    ++index;
                    continue;
                }
                if (c1 == '$' && index < line.length() - 2 && !inMacro) {
                    char c2 = line.charAt(index);
                    char terminator = Macro.getTerminator(c2);
                    if (terminator != '\u0000') {
                        index = this.process(line, index + 1, c2, terminator, variable, link, true);
                        continue;
                    }
                } else if (c1 == '.' && index < line.length() && line.charAt(index) == '/') {
                    if (index == 1 || Character.isWhitespace(line.charAt(index - 2))) {
                        ++index;
                        variable.append(IO.absolutePath(this.domain.getBase()));
                        variable.append('/');
                        continue;
                    }
                } else if (inMacro && c1 == ';' && nesting == 1) {
                    args.add(variable.substring(pStart));
                    pStart = variable.length() + 1;
                }
            }
            variable.append(c1);
        }
        result.append((CharSequence)variable);
        return index;
    }

    public static char getTerminator(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case '<': {
                return '>';
            }
            case '\u00ab': {
                return '\u00bb';
            }
            case '\u2039': {
                return '\u203a';
            }
        }
        return '\u0000';
    }

    protected String getMacro(String key, Link link) {
        return this.getMacro(key, null, link, '{', '}');
    }

    private String getMacro(String key, List<String> args2, Link link, char begin, char end) {
        if (link != null && link.contains(key)) {
            return "${infinite:" + link.toString() + "}";
        }
        if (key != null) {
            String[] args;
            key = key.trim();
            if (args2 == null) {
                args = SEMICOLON_P.split(key, 0);
            } else {
                args = args2.toArray(new String[args2.size()]);
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this.process((CharSequence)args[i], link);
                }
            }
            if (!args[0].isEmpty()) {
                String profile;
                String value;
                if (args.length == 1) {
                    Instruction ins = new Instruction(args[0]);
                    if (!ins.isLiteral()) {
                        String keyname = key;
                        return this.domain.stream().filter(ins::matches).sorted().map(k -> this.replace((String)k, null, new Link(this.domain, link, keyname), begin, end)).filter(Objects::nonNull).collect(Strings.joining());
                    }
                    args[0] = ins.getLiteral();
                }
                if ((value = this.domain.getUnexpandedProperty(args[0])) != null) {
                    Link next = new Link(this.domain, link, key);
                    if (args.length > 1) {
                        return this.processWithArgs(value, args, next);
                    }
                    return this.process((CharSequence)value, next);
                }
                value = this.doCommands(args, link);
                if (value != null) {
                    if (value == NULLVALUE) {
                        return null;
                    }
                    if (value == LITERALVALUE) {
                        return LITERALVALUE;
                    }
                    return this.process((CharSequence)value, new Link(this.domain, link, key));
                }
                if (args.length == 1) {
                    value = System.getProperty(args[0]);
                    if (value != null) {
                        return value;
                    }
                    if (key.startsWith("env.") && (value = System.getenv(args[0].substring(4))) != null) {
                        return value;
                    }
                }
                if (!args[0].startsWith("[") && (profile = this.domain.getUnexpandedProperty("-profile")) != null) {
                    profile = this.process((CharSequence)profile, link);
                    String profiledKey = "[" + profile + "]" + args[0];
                    value = this.domain.getUnexpandedProperty(profiledKey);
                    if (value != null) {
                        Link next = new Link(this.domain, link, key);
                        if (args.length > 1) {
                            return this.processWithArgs(value, args, next);
                        }
                        return this.process((CharSequence)value, next);
                    }
                }
            } else {
                this.reporter.warning("Found empty macro key '%s'", key);
            }
        } else {
            this.reporter.warning("Found null macro key", new Object[0]);
        }
        return null;
    }

    private String processWithArgs(String template, String[] args, Link next) {
        String string;
        Processor custom = new Processor(this.domain);
        try {
            for (int i = 0; i < 16; ++i) {
                custom.setProperty(Integer.toString(i), i < args.length ? args[i] : "null");
            }
            String joinedArgs = Arrays.stream(args, 1, args.length).collect(Strings.joining());
            custom.setProperty("#", joinedArgs);
            string = custom.getReplacer().process((CharSequence)template, next);
        }
        catch (Throwable throwable) {
            try {
                try {
                    custom.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Exceptions.duck(e);
            }
        }
        custom.close();
        return string;
    }

    public String replace(String key, Link link) {
        return this.replace(key, null, link, '{', '}');
    }

    private String replace(String key, List<String> args, Link link, char begin, char end) {
        String value = this.getMacro(key, args, link, begin, end);
        if (value != LITERALVALUE) {
            if (value != null) {
                return value;
            }
            if (!this.flattening && !key.startsWith("@")) {
                this.reporter.warning("No translation found for macro: %s", key);
            }
        }
        return "$" + begin + key + end;
    }

    private String doCommands(String[] args, Link source) {
        if (args == null || args.length == 0) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].indexOf(92) < 0) continue;
            args[i] = ESCAPED_SEMICOLON_P.matcher(args[i]).replaceAll(SEMICOLON);
        }
        if (args[0].startsWith("^")) {
            Processor parent;
            String varname = args[0].substring(1).trim();
            if (source != null && (parent = source.start.getParent()) != null) {
                return parent.getProperty(varname);
            }
            return null;
        }
        for (Processor rover = this.domain; rover != null; rover = rover.getParent()) {
            String result = this.doCommand(rover, args[0], args);
            if (result == null) continue;
            return result;
        }
        for (int i = 0; this.targets != null && i < this.targets.length; ++i) {
            String result = this.doCommand(this.targets[i], args[0], args);
            if (result == null) continue;
            return result;
        }
        return this.doCommand(this, args[0], args);
    }

    private String doCommand(Object target, String method, String[] args) {
        if (target != null) {
            String macro;
            int len = method.length();
            for (int i = 0; i < len; ++i) {
                char c2 = method.charAt(i);
                if (!(c2 == '-' ? i == 0 : !Character.isJavaIdentifierPart(c2))) continue;
                return null;
            }
            Map macros = this.macrosByClass.computeIfAbsent(target.getClass(), c -> Arrays.stream(c.getMethods()).filter(m -> m.getName().charAt(0) == '_' && m.getParameterCount() == 1 && m.getParameterTypes()[0] == String[].class).collect(Collectors.toMap(m -> m.getName().substring(1), m -> {
                Memoize<MethodHandle> mh = Memoize.supplier(() -> {
                    try {
                        return MethodHandles.publicLookup().unreflect((Method)m);
                    }
                    catch (Exception e) {
                        throw Exceptions.duck(e);
                    }
                });
                if (Modifier.isStatic(m.getModifiers())) {
                    return (t, a) -> {
                        try {
                            return ((MethodHandle)mh.get()).invoke((String[])a);
                        }
                        catch (Throwable e) {
                            throw Exceptions.duck(e);
                        }
                    };
                }
                return (t, a) -> {
                    try {
                        return ((MethodHandle)mh.get()).invoke(t, (String[])a);
                    }
                    catch (Throwable e) {
                        throw Exceptions.duck(e);
                    }
                };
            })));
            BiFunction invoker = (BiFunction)macros.get(macro = method.replace('-', '_'));
            if (invoker == null) {
                return null;
            }
            try {
                Object result = invoker.apply(target, args);
                return result == null ? NULLVALUE : result.toString();
            }
            catch (Error e) {
                throw e;
            }
            catch (WrongMethodTypeException e) {
                this.reporter.warning("Exception in replace: method=%s %s ", method, Exceptions.toString(e));
                return NULLVALUE;
            }
            catch (Exception e) {
                this.reporter.error("%s, for cmd: %s, arguments; %s", e.getMessage(), method, Arrays.toString(args));
                return NULLVALUE;
            }
            catch (Throwable e) {
                this.reporter.warning("Exception in replace: method=%s %s ", method, Exceptions.toString(e));
                return NULLVALUE;
            }
        }
        return null;
    }

    public String _uniq(String[] args) {
        Macro.verifyCommand(args, _uniqHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).distinct().collect(Strings.joining());
        return result;
    }

    public String _removeall(String[] args) {
        Macro.verifyCommand(args, _removeallHelp, null, 1, 3);
        if (args.length < 2) {
            return "";
        }
        List<String> result = Strings.splitQuoted(args[1]);
        if (args.length > 2) {
            result.removeAll(Strings.splitQuoted(args[2]));
        }
        return Strings.join(result);
    }

    public String _retainall(String[] args) {
        Macro.verifyCommand(args, _retainallHelp, null, 1, 3);
        if (args.length < 3) {
            return "";
        }
        List<String> result = Strings.splitQuoted(args[1]);
        result.retainAll(Strings.splitQuoted(args[2]));
        return Strings.join(result);
    }

    public String _pathseparator(String[] args) {
        return File.pathSeparator;
    }

    public String _separator(String[] args) {
        return File.separator;
    }

    public String _filter(String[] args) {
        return this.filter(args, false);
    }

    public String _select(String[] args) {
        return this.filter(args, false);
    }

    public String _filterout(String[] args) {
        return this.filter(args, true);
    }

    public String _reject(String[] args) {
        return this.filter(args, true);
    }

    String filter(String[] args, boolean include) {
        Macro.verifyCommand(args, String.format(_filterHelp, args[0]), null, 3, 3);
        Pattern pattern = Pattern.compile(args[2]);
        String result = Strings.splitQuotedAsStream(args[1]).filter(s -> pattern.matcher((CharSequence)s).matches() != include).collect(Strings.joining());
        return result;
    }

    public String _sort(String[] args) {
        Macro.verifyCommand(args, _sortHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).sorted().collect(Strings.joining());
        return result;
    }

    public String _nsort(String[] args) {
        Macro.verifyCommand(args, _nsortHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).sorted((a, b) -> {
            while (a.startsWith("0")) {
                a = a.substring(1);
            }
            while (b.startsWith("0")) {
                b = b.substring(1);
            }
            if (a.length() == b.length()) {
                return a.compareTo((String)b);
            }
            return a.length() > b.length() ? 1 : -1;
        }).collect(Strings.joining());
        return result;
    }

    public String _join(String[] args) {
        Macro.verifyCommand(args, _joinHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).collect(Strings.joining());
        return result;
    }

    public String _sjoin(String[] args) throws Exception {
        Macro.verifyCommand(args, _sjoinHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 2, args.length).flatMap(Strings::splitQuotedAsStream).collect(Collectors.joining(args[1]));
        return result;
    }

    public String _if(String[] args) throws Exception {
        Macro.verifyCommand(args, _ifHelp, null, 2, 4);
        String condition = args[1];
        if (this.isTruthy(condition)) {
            return args.length > 2 ? args[2] : "true";
        }
        if (args.length > 3) {
            return args[3];
        }
        return "";
    }

    public boolean isTruthy(String condition) throws Exception {
        if (condition == null) {
            return false;
        }
        if ((condition = condition.trim()).startsWith("(") && condition.endsWith(")")) {
            return this.doCondition(condition);
        }
        return !condition.equalsIgnoreCase("false") && !condition.equals("0") && !condition.equals("0.0") && condition.length() != 0;
    }

    public Object _now(String[] args) {
        Macro.verifyCommand(args, _nowHelp, null, 1, 2);
        long now = this.getBuildNow();
        if (args.length == 2) {
            if ("long".equals(args[1])) {
                return Long.toString(now);
            }
            SimpleDateFormat df = new SimpleDateFormat(args[1], Locale.ROOT);
            df.setTimeZone(Dates.UTC_TIME_ZONE);
            return df.format(new Date(now));
        }
        return Dates.formatMillis(DATE_TOSTRING, now);
    }

    public String _fmodified(String[] args) throws Exception {
        Macro.verifyCommand(args, _fmodifiedHelp, null, 2, Integer.MAX_VALUE);
        long time = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).map(File::new).filter(File::exists).mapToLong(File::lastModified).max().orElse(0L);
        return Long.toString(time);
    }

    public String _long2date(String[] args) {
        try {
            return Dates.formatMillis(DATE_TOSTRING, Long.parseLong(args[1]));
        }
        catch (Exception e) {
            return "not a valid long";
        }
    }

    public String _literal(String[] args) {
        if (args.length != 2) {
            throw new RuntimeException("Need a value for the ${literal;<value>} macro");
        }
        return "${" + args[1] + "}";
    }

    public String _def(String[] args) {
        Macro.verifyCommand(args, _defHelp, null, 2, 3);
        return this.domain.getProperty(args[1], args.length == 3 ? args[2] : "");
    }

    public String _list(String[] args) {
        Macro.verifyCommand(args, _listHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).map(this.domain::getProperty).flatMap(Strings::splitQuotedAsStream).map(element -> element.indexOf(59) < 0 ? element : SEMICOLON_P.matcher((CharSequence)element).replaceAll(ESCAPED_SEMICOLON)).collect(Strings.joining());
        return result;
    }

    public String _replace(String[] args) {
        return this.replace0(_replaceHelp, Strings::splitAsStream, args);
    }

    public String _replacelist(String[] args) {
        return this.replace0(_replacelistHelp, Strings::splitQuotedAsStream, args);
    }

    private String replace0(String help, Function<String, Stream<String>> splitter, String[] args) {
        Macro.verifyCommand(args, help, null, 3, 5);
        Pattern regex = Pattern.compile(args[2]);
        String replace = args.length > 3 ? args[3] : "";
        Collector<CharSequence, ?, String> joining = args.length > 4 ? Collectors.joining(args[4]) : Strings.joining();
        String result = splitter.apply(args[1]).map(element -> regex.matcher((CharSequence)element).replaceAll(replace)).collect(joining);
        return result;
    }

    public String _replacestring(String[] args) {
        Macro.verifyCommand(args, _replacestringHelp, null, 3, 4);
        Pattern regex = Pattern.compile(args[2]);
        String replace = args.length > 3 ? args[3] : "";
        String result = regex.matcher(args[1]).replaceAll(replace);
        return result;
    }

    public String _warning(String[] args) throws Exception {
        for (int i = 1; i < args.length; ++i) {
            Reporter.SetLocation warning = this.reporter.warning("%s", this.process(args[i]));
            Processor.FileLine header = this.domain.getHeader(ANY, WARNING_P);
            if (header == null) continue;
            header.set(warning);
        }
        return "";
    }

    public String _error(String[] args) throws Exception {
        for (int i = 1; i < args.length; ++i) {
            Reporter.SetLocation error = this.reporter.error("%s", this.process(args[i]));
            Processor.FileLine header = this.domain.getHeader(ANY, ERROR_P);
            if (header == null) continue;
            header.set(error);
        }
        return "";
    }

    public String _toclassname(String[] args) {
        Macro.verifyCommand(args, _toclassnameHelp, null, 2, 2);
        String result = Strings.splitAsStream(args[1]).map(path -> {
            if (path.endsWith(".class")) {
                return path.substring(0, path.length() - 6).replace('/', '.');
            }
            if (path.endsWith(".java")) {
                return path.substring(0, path.length() - 5).replace('/', '.');
            }
            this.reporter.warning("in toclassname, %s is not a class path because it does not end in .class", path);
            return null;
        }).filter(Objects::nonNull).collect(Strings.joining());
        return result;
    }

    public String _toclasspath(String[] args) {
        Macro.verifyCommand(args, _toclasspathHelp, null, 2, 3);
        boolean cl = args.length > 2 ? Boolean.parseBoolean(args[2]) : true;
        Function<String, String> mapper = cl ? name -> name.replace('.', '/') + ".class" : name -> name.replace('.', '/');
        String result = Strings.splitAsStream(args[1]).map(mapper).collect(Strings.joining());
        return result;
    }

    public String _dir(String[] args) {
        if (args.length < 2) {
            this.reporter.warning("Need at least one file name for ${dir;...}", new Object[0]);
            return null;
        }
        String result = Arrays.stream(args, 1, args.length).map(this.domain::getFile).filter(File::exists).map(File::getParentFile).map(IO::absolutePath).collect(Strings.joining());
        return result;
    }

    public String _basename(String[] args) {
        if (args.length < 2) {
            this.reporter.warning("Need at least one file name for ${basename;...}", new Object[0]);
            return null;
        }
        String result = Arrays.stream(args, 1, args.length).map(this.domain::getFile).filter(File::exists).map(File::getName).collect(Strings.joining());
        return result;
    }

    public String _isfile(String[] args) {
        if (args.length < 2) {
            this.reporter.warning("Need at least one file name for ${isfile;...}", new Object[0]);
            return null;
        }
        boolean isfile = Arrays.stream(args, 1, args.length).map(File::new).map(File::getAbsoluteFile).allMatch(File::isFile);
        return Boolean.toString(isfile);
    }

    public String _isdir(String[] args) {
        boolean isdir = args.length < 2 ? false : Arrays.stream(args, 1, args.length).map(File::new).map(File::getAbsoluteFile).allMatch(File::isDirectory);
        return Boolean.toString(isdir);
    }

    public String _tstamp(String[] args) {
        String format = args.length > 1 ? args[1] : "yyyyMMddHHmm";
        TimeZone tz = args.length > 2 ? TimeZone.getTimeZone(args[2]) : Dates.UTC_TIME_ZONE;
        long now = args.length > 3 ? Long.parseLong(args[3]) : this.getBuildNow();
        if (args.length > 4) {
            this.reporter.warning("Too many arguments for tstamp: %s", Arrays.toString(args));
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
        sdf.setTimeZone(tz);
        return sdf.format(new Date(now));
    }

    private long getBuildNow() {
        long now;
        String tstamp = this.domain.getProperty("_@tstamp");
        if (tstamp != null) {
            try {
                now = Long.parseLong(tstamp);
            }
            catch (NumberFormatException e) {
                now = System.currentTimeMillis();
            }
        } else {
            now = System.currentTimeMillis();
        }
        return now;
    }

    public String _lsr(String[] args) {
        return this.ls(_lsrHelp, args, true);
    }

    public String _lsa(String[] args) {
        return this.ls(_lsaHelp, args, false);
    }

    private String ls(String help, String[] args, boolean relative) {
        Function<File, String> mapper;
        Macro.verifyCommand(args, help, null, 2, Integer.MAX_VALUE);
        File dir = this.domain.getFile(args[1]);
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException(String.format("the ${%s} macro directory parameter is not absolute: %s", args[0], dir));
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException(String.format("the ${%s} macro directory parameter does not exist: %s", args[0], dir));
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(String.format("the ${%s} macro directory parameter points to a file instead of a directory: %s", args[0], dir));
        }
        Object[] array = dir.listFiles();
        if (array == null || array.length == 0) {
            return "";
        }
        Arrays.sort(array);
        Function<File, String> function = mapper = relative ? File::getName : IO::absolutePath;
        if (args.length < 3) {
            String result = Arrays.stream(array).map(mapper).collect(Strings.joining());
            return result;
        }
        LinkedList files = new LinkedList();
        Collections.addAll(files, array);
        ArrayList result = new ArrayList(array.length);
        Arrays.stream(args, 2, args.length).flatMap(Strings::splitQuotedAsStream).map(Instruction::new).forEachOrdered(ins -> {
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                if (!ins.matches(file.getPath())) continue;
                iter.remove();
                if (ins.isNegated()) continue;
                result.add((String)mapper.apply(file));
            }
        });
        return Strings.join(result);
    }

    public String _currenttime(String[] args) {
        return Long.toString(System.currentTimeMillis());
    }

    public String _version(String[] args) {
        return this._versionmask(args);
    }

    public String _versionmask(String[] args) {
        Version version;
        Macro.verifyCommand(args, "${versionmask;<mask>;<version>}, modify a version\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='", _versionPattern, 2, 3);
        String mask = args[1];
        if (args.length >= 3) {
            if (this.isLocalTarget(args[2])) {
                return LITERALVALUE;
            }
            version = Version.parseVersion(args[2]);
        } else {
            String v = this.domain.getProperty("@");
            if (v == null) {
                return LITERALVALUE;
            }
            version = new Version(v);
        }
        return Macro.version(version, mask);
    }

    static String version(Version version, String mask) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        int len = mask.length();
        block14: for (int i = 0; i < len; ++i) {
            char c = mask.charAt(i);
            if (i == 3) {
                switch (c) {
                    case '~': {
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        sb.append(del).append(c);
                        break;
                    }
                    case 's': {
                        MavenVersion mv = new MavenVersion(version);
                        if (!mv.isSnapshot()) break;
                        sb.append("-SNAPSHOT");
                        break;
                    }
                    case 'S': {
                        MavenVersion mv = new MavenVersion(version);
                        if (mv.isSnapshot()) {
                            sb.append("-SNAPSHOT");
                            break;
                        }
                    }
                    case '=': {
                        String qualifier = version.getQualifier();
                        if (qualifier == null) break;
                        sb.append(del).append(qualifier);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid mask character " + c + " at index " + i);
                    }
                }
                return sb.toString();
            }
            switch (c) {
                case '~': {
                    continue block14;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    sb.append(del).append(c);
                    break;
                }
                case '+': {
                    sb.append(del).append(version.get(i) + 1);
                    break;
                }
                case '-': {
                    sb.append(del).append(Math.max(0, version.get(i) - 1));
                    break;
                }
                case '=': {
                    sb.append(del).append(version.get(i));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid mask character " + c + " at index " + i);
                }
            }
            del = ".";
        }
        return sb.toString();
    }

    public String _range(String[] args) {
        Version version;
        Macro.verifyCommand(args, _rangeHelp, _rangePattern, 2, 3);
        if (args.length >= 3) {
            String string = args[2];
            if (this.isLocalTarget(string)) {
                return LITERALVALUE;
            }
            version = new Version(string);
        } else {
            String v = this.domain.getProperty("@");
            if (v == null) {
                return LITERALVALUE;
            }
            version = new Version(v);
        }
        String spec = args[1];
        Matcher m = RANGE_MASK.matcher(spec);
        m.matches();
        String floor = m.group(1);
        String floorMask = m.group(2);
        String ceilingMask = m.group(3);
        String ceiling = m.group(4);
        String left = Macro.version(version, floorMask);
        String right = Macro.version(version, ceilingMask);
        StringBuilder sb = new StringBuilder();
        sb.append(floor);
        sb.append(left);
        sb.append(",");
        sb.append(right);
        sb.append(ceiling);
        String s = sb.toString();
        VersionRange vr = new VersionRange(s);
        if (!vr.includes(vr.getHigh()) && !vr.includes(vr.getLow())) {
            this.reporter.error("${range} macro created an invalid range %s from %s and mask %s", s, version, spec);
        }
        return sb.toString();
    }

    boolean isLocalTarget(String string) {
        return LOCALTARGET_P.matcher(string).matches();
    }

    public String system_internal(boolean allowFail, String[] args) throws Exception {
        if (this.nosystem) {
            throw new RuntimeException("Macros in this mode cannot excute system commands");
        }
        Macro.verifyCommand(args, allowFail ? _system_allow_failHelp : _systemHelp, null, 2, 3);
        String command = args[1];
        String input = null;
        if (args.length > 2) {
            input = args[2];
        }
        return this.domain.system(allowFail, command, input);
    }

    public String _system(String[] args) throws Exception {
        return this.system_internal(false, args);
    }

    public String _system_allow_fail(String[] args) throws Exception {
        String result = "";
        try {
            result = this.system_internal(true, args);
            return result == null ? "" : result;
        }
        catch (Throwable t) {
            return "";
        }
    }

    public String _env(String[] args) {
        Macro.verifyCommand(args, _envHelp, null, 2, 3);
        try {
            String ret = System.getenv(args[1]);
            if (ret != null) {
                return ret;
            }
            if (args.length > 2) {
                return args[2];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    public String _cat(String[] args) throws IOException {
        Macro.verifyCommand(args, _catHelp, null, 2, 2);
        File f = this.domain.getFile(args[1]);
        if (f.isFile()) {
            return IO.collect(f).replaceAll("\\\\", "\\\\\\\\");
        }
        if (f.isDirectory()) {
            return Arrays.toString(f.list());
        }
        try {
            URL url = new URL(args[1]);
            return IO.collect(url, StandardCharsets.UTF_8);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String _base64(String ... args) throws IOException {
        Macro.verifyCommand(args, _base64Help, null, 2, 3);
        File file = this.domain.getFile(args[1]);
        long maxLength = 100000L;
        if (args.length > 2) {
            maxLength = Long.parseLong(args[2]);
        }
        if (file.length() > maxLength) {
            throw new IllegalArgumentException("Maximum file size (" + maxLength + ") for base64 macro exceeded for file " + file);
        }
        return Base64.encodeBase64(file);
    }

    public String _digest(String ... args) throws NoSuchAlgorithmException, IOException {
        Macro.verifyCommand(args, _digestHelp, null, 3, 3);
        MessageDigest digester = MessageDigest.getInstance(args[1]);
        File f = this.domain.getFile(args[2]);
        IO.copy(f, digester);
        byte[] digest = digester.digest();
        return Hex.toHexString(digest);
    }

    public static void verifyCommand(String[] args, String help, Pattern[] patterns, int low, int high) {
        String message = "";
        if (args.length > high) {
            message = "too many arguments";
        } else if (args.length < low) {
            message = "too few arguments";
        } else {
            for (int i = 0; patterns != null && i < patterns.length && i < args.length; ++i) {
                Matcher m;
                if (patterns[i] == null || (m = patterns[i].matcher(args[i])).matches()) continue;
                message = message + String.format("Argument %s (%s) does not match %s%n", i, args[i], patterns[i].pattern());
            }
        }
        if (message.length() != 0) {
            StringBuilder sb = new StringBuilder();
            String del = "${";
            for (String arg : args) {
                sb.append(del);
                sb.append(arg);
                del = SEMICOLON;
            }
            sb.append("}, is not understood. ");
            sb.append(message);
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public Properties getFlattenedProperties() {
        return this.getFlattenedProperties(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getFlattenedProperties(boolean ignoreInstructions) {
        this.flattening = true;
        try {
            Properties flattened;
            Stream<String> keys = StreamSupport.stream(this.domain.spliterator(), false);
            Properties properties = flattened = (Properties)keys.filter(key -> !key.startsWith("_")).map(key -> {
                String value = null;
                for (Processor proc = this.domain; proc != null; proc = proc.getParent()) {
                    Object raw = proc.getProperties().get(key);
                    if (raw != null) {
                        if (raw instanceof String) {
                            value = (String)raw;
                            break;
                        }
                        if (!this.reporter.isPedantic()) break;
                        this.reporter.warning("Key '%s' has a non-String value: %s:%s", key, raw.getClass().getName(), raw);
                        break;
                    }
                    Collection<String> keyFilter = proc.filter;
                    if (keyFilter != null && keyFilter.contains(key)) break;
                }
                if (value == null) {
                    return null;
                }
                if (!ignoreInstructions || !key.startsWith("-")) {
                    value = this.process(value);
                }
                return new AbstractMap.SimpleEntry<String, String>((String)key, value);
            }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue, UTF8Properties::new));
            return properties;
        }
        finally {
            this.flattening = false;
        }
    }

    public String _osfile(String[] args) {
        Macro.verifyCommand(args, _osfileHelp, null, 3, 3);
        File base = new File(args[1]);
        File f = IO.getFile(base, args[2]);
        return IO.absolutePath(f);
    }

    public String _path(String[] args) {
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).collect(Collectors.joining(File.pathSeparator));
        return result;
    }

    public int _size(String[] args) {
        Macro.verifyCommand(args, _sizeHelp, null, 1, Integer.MAX_VALUE);
        long size = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).count();
        return (int)size;
    }

    public static Properties getParent(Properties p) {
        try {
            Field f = Properties.class.getDeclaredField("defaults");
            f.setAccessible(true);
            MethodHandle mh = MethodHandles.publicLookup().unreflectGetter(f);
            return mh.invoke(p);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String process(String line) {
        return this.process(line, this.domain);
    }

    public boolean isNosystem() {
        return this.nosystem;
    }

    public boolean setNosystem(boolean nosystem) {
        boolean tmp = this.nosystem;
        this.nosystem = nosystem;
        return tmp;
    }

    public String _unescape(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            sb.append(args[i]);
        }
        block8: for (int j = 0; j < sb.length() - 1; ++j) {
            if (sb.charAt(j) != '\\') continue;
            switch (sb.charAt(j + 1)) {
                case 'n': {
                    sb.replace(j, j + 2, "\n");
                    continue block8;
                }
                case 'r': {
                    sb.replace(j, j + 2, "\r");
                    continue block8;
                }
                case 'b': {
                    sb.replace(j, j + 2, "\b");
                    continue block8;
                }
                case 'f': {
                    sb.replace(j, j + 2, "\f");
                    continue block8;
                }
                case 't': {
                    sb.replace(j, j + 2, "\t");
                    continue block8;
                }
            }
        }
        return sb.toString();
    }

    public String _startswith(String[] args) throws Exception {
        Macro.verifyCommand(args, _startswithHelp, null, 3, 3);
        if (args[1].startsWith(args[2])) {
            return args[1];
        }
        return "";
    }

    public String _endswith(String[] args) throws Exception {
        Macro.verifyCommand(args, _endswithHelp, null, 3, 3);
        if (args[1].endsWith(args[2])) {
            return args[1];
        }
        return "";
    }

    public String _extension(String[] args) throws Exception {
        Macro.verifyCommand(args, _extensionHelp, null, 2, 2);
        String result = Optional.of(args[1]).map(IO::normalizePath).map(path -> Optional.ofNullable(Strings.lastPathSegment(path)).map(tuple -> tuple[1]).orElse((String)path)).flatMap(name -> Optional.ofNullable(Strings.extension(name)).map(tuple -> tuple[1])).orElse("");
        return result;
    }

    public String _basenameext(String[] args) throws Exception {
        Macro.verifyCommand(args, _basenameextHelp, null, 2, 3);
        String extension = Optional.ofNullable(args.length > 2 && !args[2].isEmpty() ? args[2] : null).map(ext -> ext.startsWith(".") ? ext.substring(1) : ext).orElse(".");
        String result = Optional.of(args[1]).map(IO::normalizePath).map(path -> Optional.ofNullable(Strings.lastPathSegment(path)).map(tuple -> tuple[1]).orElse((String)path)).map(name -> Optional.ofNullable(Strings.extension(name)).filter(tuple -> extension.equals(tuple[1])).map(tuple -> tuple[0]).orElse((String)name)).orElse("");
        return result;
    }

    public String _bndversion(String[] args) throws Exception {
        Macro.verifyCommand(args, _bndversionHelp, null, 1, 1);
        return About.CURRENT.toStringWithoutQualifier();
    }

    public String _stem(String[] args) throws Exception {
        Macro.verifyCommand(args, _stemHelp, null, 2, 2);
        String name = args[1];
        int n = name.indexOf(46);
        if (n < 0) {
            return name;
        }
        return name.substring(0, n);
    }

    public String _substring(String[] args) throws Exception {
        Macro.verifyCommand(args, _substringHelp, null, 3, 4);
        String string = args[1];
        int start = Integer.parseInt(args[2].equals("") ? "0" : args[2]);
        int end = string.length();
        if (args.length > 3 && (end = Integer.parseInt(args[3])) < 0) {
            end = string.length() + end;
        }
        if (start < 0) {
            start = string.length() + start;
        }
        if (start > end) {
            int t = start;
            start = end;
            end = t;
        }
        return string.substring(start, end);
    }

    public long _rand(String[] args) throws Exception {
        Macro.verifyCommand(args, _randHelp, null, 2, 3);
        int min = 0;
        int max = 100;
        if (args.length > 1) {
            max = Integer.parseInt(args[1]);
            if (args.length > 2) {
                min = Integer.parseInt(args[2]);
            }
        }
        int diff = max - min;
        double d = random.nextDouble() * (double)diff + (double)min;
        return Math.round(d);
    }

    public int _length(String[] args) throws Exception {
        Macro.verifyCommand(args, _lengthHelp, null, 1, 2);
        if (args.length == 1) {
            return 0;
        }
        return args[1].length();
    }

    public String _get(String[] args) throws Exception {
        Macro.verifyCommand(args, _getHelp, null, 3, 3);
        int index = Integer.parseInt(args[1]);
        List<String> list = this.toList(args, 2, args.length);
        if (index < 0) {
            index = list.size() + index;
        }
        return list.get(index);
    }

    public String _sublist(String[] args) throws Exception {
        Macro.verifyCommand(args, _sublistHelp, null, 4, Integer.MAX_VALUE);
        int start = Integer.parseInt(args[1]);
        int end = Integer.parseInt(args[2]);
        List<String> list = this.toList(args, 3, args.length);
        if (start < 0) {
            start = list.size() + start + 1;
        }
        if (end < 0) {
            end = list.size() + end + 1;
        }
        if (start > end) {
            int t = start;
            start = end;
            end = t;
        }
        return Strings.join(list.subList(start, end));
    }

    private List<String> toList(String[] args, int startInclusive, int endExclusive) {
        List<String> list = Arrays.stream(args, startInclusive, endExclusive).flatMap(Strings::splitQuotedAsStream).collect(Collectors.toList());
        return list;
    }

    public String _first(String[] args) throws Exception {
        Macro.verifyCommand(args, _firstHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).findFirst().orElse("");
        return result;
    }

    public String _last(String[] args) throws Exception {
        Macro.verifyCommand(args, _lastHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).reduce((first, second) -> second).orElse("");
        return result;
    }

    public String _max(String[] args) throws Exception {
        Macro.verifyCommand(args, _maxHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).max(String::compareTo).orElse("");
        return result;
    }

    public String _min(String[] args) throws Exception {
        Macro.verifyCommand(args, _minHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).min(String::compareTo).orElse("");
        return result;
    }

    public String _nmax(String[] args) throws Exception {
        Macro.verifyCommand(args, _nmaxHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).max(Comparator.comparingDouble(Double::parseDouble)).orElse("NaN");
        return result;
    }

    public String _nmin(String[] args) throws Exception {
        Macro.verifyCommand(args, _nminHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).min(Comparator.comparingDouble(Double::parseDouble)).orElse("NaN");
        return result;
    }

    public String _vmax(String[] args) throws Exception {
        Macro.verifyCommand(args, _vmaxHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).max(Comparator.comparing(Version::valueOf)).orElse("0");
        return result;
    }

    public String _vmin(String[] args) throws Exception {
        Macro.verifyCommand(args, _vminHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).min(Comparator.comparing(Version::valueOf)).orElse("0");
        return result;
    }

    public String _sum(String[] args) throws Exception {
        Macro.verifyCommand(args, _sumHelp, null, 2, Integer.MAX_VALUE);
        double result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).mapToDouble(Double::parseDouble).sum();
        return this.toString(result);
    }

    public String _average(String[] args) throws Exception {
        Macro.verifyCommand(args, _sumHelp, null, 2, Integer.MAX_VALUE);
        double result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).mapToDouble(Double::parseDouble).average().orElseThrow(() -> new IllegalArgumentException("No members in list to calculate average"));
        return this.toString(result);
    }

    public String _reverse(String[] args) throws Exception {
        Macro.verifyCommand(args, _reverseHelp, null, 2, Integer.MAX_VALUE);
        Deque reversed = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).collect(Collector.of(ArrayDeque::new, ArrayDeque::addFirst, (d1, d2) -> {
            d2.addAll(d1);
            return d2;
        }, new Collector.Characteristics[0]));
        return Strings.join(reversed);
    }

    public int _indexof(String[] args) throws Exception {
        Macro.verifyCommand(args, _indexofHelp, null, 3, Integer.MAX_VALUE);
        String value = args[1];
        List<String> list = this.toList(args, 2, args.length);
        return list.indexOf(value);
    }

    public int _lastindexof(String[] args) throws Exception {
        Macro.verifyCommand(args, _lastindexofHelp, null, 3, Integer.MAX_VALUE);
        String value = args[1];
        List<String> list = this.toList(args, 2, args.length);
        return list.lastIndexOf(value);
    }

    public int _find(String[] args) throws Exception {
        Macro.verifyCommand(args, _findHelp, null, 3, 3);
        return args[1].indexOf(args[2]);
    }

    public int _findlast(String[] args) throws Exception {
        Macro.verifyCommand(args, _findlastHelp, null, 3, 3);
        return args[2].lastIndexOf(args[1]);
    }

    public String _split(String[] args) throws Exception {
        Macro.verifyCommand(args, _splitHelp, null, 2, Integer.MAX_VALUE);
        Pattern regex = Pattern.compile(args[1]);
        String result = Arrays.stream(args, 2, args.length).flatMap(regex::splitAsStream).filter(element -> !element.isEmpty()).collect(Strings.joining());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _js(String[] args) throws Exception {
        Macro.verifyCommand(args, _jsHelp, null, 2, Integer.MAX_VALUE);
        String script = Arrays.stream(args, 1, args.length).collect(Collectors.joining(SEMICOLON));
        StringWriter stdout = new StringWriter();
        StringWriter stderr = new StringWriter();
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
            ScriptContext context = engine.getContext();
            Bindings bindings = context.getBindings(100);
            bindings.put("domain", (Object)this.domain);
            String javascript = this.domain.mergeProperties("javascript", SEMICOLON);
            if (javascript != null && javascript.length() > 0) {
                engine.eval(javascript, context);
            }
            context.setErrorWriter(stderr);
            context.setWriter(stdout);
            Object eval = engine.eval(script, context);
            String out = stdout.toString();
            if (!out.isEmpty()) {
                this.reporter.error("Executing js: %s: %s", script, out);
            }
            if (eval != null) {
                String string = this.toString(eval);
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            stdout.getBuffer().setLength(0);
            stderr.getBuffer().setLength(0);
        }
    }

    private String toString(Object eval) {
        if (eval == null) {
            return "null";
        }
        if (eval instanceof Double || eval instanceof Float) {
            String v = eval.toString();
            return v.endsWith(".0") ? v.substring(0, v.length() - 2) : v;
        }
        return eval.toString();
    }

    private String toString(double eval) {
        String v = Double.toString(eval);
        return v.endsWith(".0") ? v.substring(0, v.length() - 2) : v;
    }

    public String _toupper(String[] args) throws Exception {
        Macro.verifyCommand(args, _tolowerHelp, null, 2, 2);
        return args[1].toUpperCase();
    }

    public String _tolower(String[] args) throws Exception {
        Macro.verifyCommand(args, _tolowerHelp, null, 2, 2);
        return args[1].toLowerCase();
    }

    public int _compare(String[] args) throws Exception {
        Macro.verifyCommand(args, _compareHelp, null, 3, 3);
        int n = args[1].compareTo(args[2]);
        return Integer.signum(n);
    }

    public int _ncompare(String[] args) throws Exception {
        Macro.verifyCommand(args, _ncompareHelp, null, 3, 3);
        double a = Double.parseDouble(args[1]);
        double b = Double.parseDouble(args[2]);
        return Integer.signum(Double.compare(a, b));
    }

    public int _vcompare(String[] args) throws Exception {
        Macro.verifyCommand(args, _vcompareHelp, null, 3, 3);
        Version a = Version.valueOf(args[1]);
        Version b = Version.valueOf(args[2]);
        return Integer.signum(a.compareTo(b));
    }

    public boolean _matches(String[] args) throws Exception {
        Macro.verifyCommand(args, _matchesHelp, null, 3, 3);
        return args[1].matches(args[2]);
    }

    public StringBuffer _subst(String[] args) throws Exception {
        Macro.verifyCommand(args, _substHelp, null, 3, 5);
        Pattern p = Pattern.compile(args[2]);
        Matcher matcher = p.matcher(args[1]);
        String replace = args.length > 3 ? args[3] : "";
        int count = args.length > 4 ? Integer.parseInt(args[4]) : Integer.MAX_VALUE;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count && matcher.find(); ++i) {
            matcher.appendReplacement(sb, replace);
        }
        matcher.appendTail(sb);
        return sb;
    }

    public String _trim(String[] args) throws Exception {
        Macro.verifyCommand(args, _trimHelp, null, 2, 2);
        return args[1].trim();
    }

    public String _format(String[] macroArgs) throws Exception {
        Macro.verifyCommand(macroArgs, _formatHelp, null, 2, Integer.MAX_VALUE);
        return Formatters.format(macroArgs[1], FunctionWithException.asFunction(this::isTruthy), 2, macroArgs);
    }

    public boolean _isempty(String[] args) throws Exception {
        Macro.verifyCommand(args, _isemptyHelp, null, 1, Integer.MAX_VALUE);
        boolean result = Arrays.stream(args, 1, args.length).noneMatch(s -> !s.trim().isEmpty());
        return result;
    }

    public boolean _isnumber(String[] args) throws Exception {
        Macro.verifyCommand(args, _isnumberHelp, null, 2, Integer.MAX_VALUE);
        boolean result = Arrays.stream(args, 1, args.length).allMatch(s -> NUMERIC_P.matcher((CharSequence)s).matches());
        return result;
    }

    public boolean _is(String[] args) throws Exception {
        Macro.verifyCommand(args, _isHelp, null, 3, Integer.MAX_VALUE);
        String a = args[1];
        boolean result = Arrays.stream(args, 2, args.length).allMatch(a::equals);
        return result;
    }

    public String _map(String[] args) throws Exception {
        Macro.verifyCommand(args, _mapHelp, null, 2, Integer.MAX_VALUE);
        String delimiter = SEMICOLON;
        String prefix = "${" + args[1] + delimiter;
        String suffix = "}";
        String result = Arrays.stream(args, 2, args.length).flatMap(Strings::splitQuotedAsStream).map(s -> this.process(prefix + s + suffix)).collect(Strings.joining());
        return result;
    }

    public String _foreach(String[] args) throws Exception {
        Macro.verifyCommand(args, _foreachHelp, null, 2, Integer.MAX_VALUE);
        String delimiter = SEMICOLON;
        String prefix = "${" + args[1] + delimiter;
        String suffix = "}";
        List<String> list = this.toList(args, 2, args.length);
        String result = IntStream.range(0, list.size()).mapToObj(n -> this.process(prefix + (String)list.get(n) + delimiter + n + suffix)).collect(Strings.joining());
        return result;
    }

    public String _apply(String[] args) throws Exception {
        Macro.verifyCommand(args, _applyHelp, null, 2, Integer.MAX_VALUE);
        String delimiter = SEMICOLON;
        String prefix = "${" + args[1] + delimiter;
        String suffix = "}";
        String result = Arrays.stream(args, 2, args.length).flatMap(Strings::splitQuotedAsStream).collect(Collectors.joining(delimiter, prefix, suffix));
        return this.process(result);
    }

    public String _bytes(String[] args) {
        try (Formatter sb = new Formatter();){
            for (String arg : args) {
                long l = Long.parseLong(arg);
                this.bytes(sb, l, 0, new String[]{"b", "Kb", "Mb", "Gb", "Tb", "Pb", "Eb", "Zb", "Yb", "Bb", "Geopbyte"});
            }
            String string = sb.toString();
            return string;
        }
    }

    private void bytes(Formatter sb, double l, int i, String[] strings) {
        if (l > 1024.0 && i < strings.length - 1) {
            this.bytes(sb, l / 1024.0, i + 1, strings);
            return;
        }
        l = Math.round(l * 10.0) / 10L;
        sb.format("%s %s", l, strings[i]);
    }

    public String _glob(String[] args) {
        Macro.verifyCommand(args, _globHelp, null, 2, 2);
        String glob = args[1];
        boolean negate = false;
        if (glob.startsWith("!")) {
            glob = glob.substring(1);
            negate = true;
        }
        Pattern pattern = Glob.toPattern(glob);
        if (negate) {
            return "(?!" + pattern.pattern() + ")";
        }
        return pattern.pattern();
    }

    public boolean doCondition(String arg) throws Exception {
        ExtendedFilter f = new ExtendedFilter(arg);
        return f.match(key -> {
            if (key.endsWith("[]")) {
                key = key.substring(0, key.length() - 2);
                return Strings.split(this.domain.getProperty(key));
            }
            return this.domain.getProperty(key);
        });
    }

    public Map<String, String> getCommands() {
        LinkedHashSet<Object> targets = new LinkedHashSet<Object>();
        Collections.addAll(targets, this.targets);
        for (Processor rover = this.domain; rover != null; rover = rover.getParent()) {
            targets.add(rover);
        }
        targets.add(this);
        return targets.stream().map(Object::getClass).map(Class::getMethods).flatMap(Arrays::stream).filter(m -> !Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && m.getName().startsWith("_")).collect(Collectors.toMap(m -> m.getName().substring(1), m -> {
            try {
                Field f = m.getDeclaringClass().getDeclaredField(m.getName() + "Help");
                f.setAccessible(true);
                MethodHandle mh = MethodHandles.publicLookup().unreflectGetter(f);
                return mh.invoke();
            }
            catch (NoSuchFieldException nsfe) {
                return "";
            }
            catch (Exception e) {
                return "";
            }
            catch (Throwable e) {
                throw Exceptions.duck(e);
            }
        }, (u, v) -> u, TreeMap::new));
    }

    public String _template(String[] args) throws IOException {
        Macro.verifyCommand(args, _templateHelp, null, 3, 30);
        Parameters parameters = this.domain.decorated(args[1]);
        String template = Arrays.stream(args, 2, args.length).collect(Collectors.joining(SEMICOLON));
        try (Processor scope = new Processor(this.domain);){
            String templated;
            Properties properties = scope.getProperties();
            Macro replacer = scope.getReplacer();
            String string = templated = parameters.stream().mapToObj((key, value) -> {
                properties.clear();
                properties.setProperty("@", Processor.removeDuplicateMarker(key));
                value.forEach((attrKey, attrValue) -> properties.setProperty("@".concat((String)attrKey), (String)attrValue));
                String instance = replacer.process(template);
                return instance;
            }).collect(Strings.joining());
            return string;
        }
    }

    public String _decorated(String[] args) throws Exception {
        Macro.verifyCommand(args, _decoratedHelp, null, 2, 3);
        boolean literals = args.length < 3 ? false : this.isTruthy(args[2]);
        Parameters decorated = this.domain.decorated(args[1], literals);
        return decorated.toString();
    }

    public String __testdebug(String[] args) throws Throwable {
        if (this.inTest && "exception".equals(args[1])) {
            Class<RuntimeException> c = args.length > 2 ? Class.forName(args[2]) : RuntimeException.class;
            Throwable e = args.length > 3 ? (Throwable)c.getConstructor(String.class).newInstance(args[3]) : (Throwable)c.newInstance();
            throw e;
        }
        return null;
    }

    public String _fileuri(String[] args) throws Exception {
        Macro.verifyCommand(args, _fileuriHelp, null, 2, 2);
        File f = this.domain.getFile(args[1]).getCanonicalFile();
        return f.toURI().toString();
    }

    public String _version_cleanup(String[] args) {
        Macro.verifyCommand(args, _version_cleanupHelp, null, 2, 2);
        return Analyzer.cleanupVersion(args[1]);
    }

    static class Link {
        final Link previous;
        final String key;
        final Processor start;

        public Link(Processor start, Link previous, String key) {
            this.start = Objects.requireNonNull(start);
            this.previous = previous;
            this.key = key;
        }

        public boolean contains(String key) {
            if (this.key.equals(key)) {
                return true;
            }
            if (this.previous == null) {
                return false;
            }
            return this.previous.contains(key);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String del = "[";
            Link r = this;
            while (r != null) {
                sb.append(del);
                sb.append(r.key);
                del = ",";
                r = r.previous;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

