/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.http;

import aQute.bnd.service.url.TaggedData;
import aQute.lib.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class HttpRequestException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public final int responseCode;

    public HttpRequestException(HttpURLConnection conn) throws IOException {
        super(HttpRequestException.getMessage(conn));
        this.responseCode = conn.getResponseCode();
    }

    public HttpRequestException(TaggedData tag) {
        this(tag, null);
    }

    public HttpRequestException(TaggedData tag, Throwable cause) {
        super(HttpRequestException.getMessage(tag), cause);
        this.responseCode = tag.getResponseCode();
    }

    private static String getMessage(TaggedData tag) {
        return tag.getUrl() + ":" + tag.getResponseCode() + ":" + tag.getTag();
    }

    private static String getMessage(HttpURLConnection conn) throws IOException {
        StringBuilder message = new StringBuilder().append(conn.getURL()).append(':').append(conn.getResponseCode());
        String responseMessage = conn.getResponseMessage();
        if (responseMessage != null) {
            message.append(':').append(responseMessage);
        } else {
            try (InputStream in = conn.getErrorStream();){
                if (in != null) {
                    String error = IO.collect(in);
                    message.append(':').append(error);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return message.toString();
    }
}

