/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.annotation.ActionInput;
import org.openhab.core.automation.handler.BaseActionModuleHandler;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.Input;
import org.openhab.core.automation.type.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class AnnotationActionHandler
extends BaseActionModuleHandler {
    private static final String MODULE_RESULT = "result";
    private final Logger logger = LoggerFactory.getLogger(AnnotationActionHandler.class);
    private final Method method;
    private final ActionType moduleType;
    private final Object actionProvider;

    public AnnotationActionHandler(Action module, ActionType mt, Method method, Object actionProvider) {
        super(module);
        this.method = method;
        this.moduleType = mt;
        this.actionProvider = actionProvider;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @Nullable Map<String, Object> execute(Map<String, Object> context) {
        Object object;
        HashMap<String, Object> output = new HashMap<String, Object>();
        Annotation[][] annotations = this.method.getParameterAnnotations();
        ArrayList<@Nullable Object> args = new ArrayList<Object>();
        int i = 0;
        while (i < annotations.length) {
            Annotation[] annotationsOnParam = annotations[i];
            if (annotationsOnParam != null && annotationsOnParam.length == 1) {
                object = annotationsOnParam[0];
                if (object instanceof ActionInput) {
                    ActionInput actionInput;
                    ActionInput cfr_ignored_0 = (ActionInput)object;
                    ActionInput cfr_ignored_1 = (ActionInput)object;
                    if (!this.hasInput(this.moduleType, actionInput.name())) {
                        this.logger.error("Annotated method defines input '{}' but the module type '{}' does not specify an input with this name.", (Object)actionInput.name(), (Object)this.moduleType);
                        return output;
                    }
                    args.add(i, context.get(actionInput.name()));
                }
            } else {
                args.add(i, context.get("p" + i));
            }
            ++i;
        }
        Object result = null;
        try {
            result = this.method.invoke(this.actionProvider, args.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Could not call method '{}' from module type '{}'.", new Object[]{this.method, this.moduleType.getUID(), e});
        }
        if (result == null) return output;
        if (result instanceof Map) {
            try {
                Map resultMap = (Map)result;
                object = resultMap.entrySet().iterator();
                while (true) {
                    if (!object.hasNext()) {
                        return output;
                    }
                    Map.Entry entry = (Map.Entry)object.next();
                    if (!this.hasOutput(this.moduleType, (String)entry.getKey())) continue;
                    output.put((String)entry.getKey(), entry.getValue());
                }
            }
            catch (ClassCastException ex) {
                this.logger.error("The return type of action method '{}' from module type '{}' should be Map<String, Object>, because {}", new Object[]{this.method, this.moduleType.getUID(), ex.getMessage()});
                return output;
            }
        }
        Object object2 = result;
        if (object2 instanceof Boolean) {
            void booleanValue;
            Boolean ex = (Boolean)object2;
            Boolean cfr_ignored_2 = (Boolean)object2;
            output.put(MODULE_RESULT, booleanValue);
            return output;
        }
        if (result instanceof String) {
            output.put(MODULE_RESULT, result);
            return output;
        }
        if (result instanceof Integer) {
            output.put(MODULE_RESULT, result);
            return output;
        }
        Object object3 = result;
        if (object3 instanceof Double) {
            void doubleValue;
            object = (Double)object3;
            Double cfr_ignored_3 = (Double)object3;
            output.put(MODULE_RESULT, doubleValue);
            return output;
        }
        Object object4 = result;
        if (object4 instanceof Float) {
            void floatValue;
            Float f = (Float)object4;
            Float cfr_ignored_4 = (Float)object4;
            output.put(MODULE_RESULT, floatValue);
            return output;
        }
        this.logger.warn("Non compatible return type '{}' on action method.", result.getClass());
        return output;
    }

    private boolean hasInput(ActionType moduleType, String in) {
        for (Input i : moduleType.getInputs()) {
            if (!i.getName().equals(in)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOutput(ActionType moduleType, String out) {
        for (Output o : moduleType.getOutputs()) {
            if (!o.getName().equals(out)) continue;
            return true;
        }
        return false;
    }
}

