/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.ModuleHandlerCallback;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleExecution;
import org.openhab.core.automation.RuleManager;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.RuleStatusDetail;
import org.openhab.core.automation.RuleStatusInfo;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.events.RuleStatusInfoEvent;
import org.openhab.core.automation.handler.ActionHandler;
import org.openhab.core.automation.handler.ConditionHandler;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.handler.TriggerHandler;
import org.openhab.core.automation.internal.Connection;
import org.openhab.core.automation.internal.ConnectionValidator;
import org.openhab.core.automation.internal.RuleEventFactory;
import org.openhab.core.automation.internal.RuleExecutionSimulator;
import org.openhab.core.automation.internal.TriggerHandlerCallbackImpl;
import org.openhab.core.automation.internal.composite.CompositeModuleHandlerFactory;
import org.openhab.core.automation.internal.ruleengine.WrappedAction;
import org.openhab.core.automation.internal.ruleengine.WrappedCondition;
import org.openhab.core.automation.internal.ruleengine.WrappedModule;
import org.openhab.core.automation.internal.ruleengine.WrappedRule;
import org.openhab.core.automation.internal.ruleengine.WrappedTrigger;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.automation.type.CompositeConditionType;
import org.openhab.core.automation.type.CompositeTriggerType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.Input;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.automation.type.Output;
import org.openhab.core.automation.type.TriggerType;
import org.openhab.core.automation.util.ReferenceResolver;
import org.openhab.core.common.NamedThreadFactory;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.events.system.SystemEventFactory;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyMarkerFilter;
import org.openhab.core.service.ReadyService;
import org.openhab.core.service.StartLevelService;
import org.openhab.core.storage.Storage;
import org.openhab.core.storage.StorageService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={RuleManager.class})
@NonNullByDefault
public class RuleEngineImpl
implements RuleManager,
RegistryChangeListener<ModuleType>,
ReadyService.ReadyTracker {
    public static final char OUTPUT_SEPARATOR = '.';
    private static final String DISABLED_RULE_STORAGE = "automation_rules_disabled";
    private static final int RULE_INIT_DELAY = 500;
    private static final ReadyMarker MARKER = new ReadyMarker("ruleengine", "start");
    private final Map<String, WrappedRule> managedRules = new ConcurrentHashMap<String, WrappedRule>();
    private final Map<String, TriggerHandlerCallbackImpl> thCallbacks = new HashMap<String, TriggerHandlerCallbackImpl>();
    private final Map<String, Set<String>> mapModuleTypeToRules = new HashMap<String, Set<String>>();
    private final Map<String, ModuleHandlerFactory> moduleHandlerFactories = new HashMap<String, ModuleHandlerFactory>(20);
    private final Set<ModuleHandlerFactory> allModuleHandlerFactories = new CopyOnWriteArraySet<ModuleHandlerFactory>();
    private final Storage<Boolean> disabledRulesStorage;
    private final StartLevelService startLevelService;
    private boolean isDisposed = false;
    private boolean started = false;
    protected final Logger logger = LoggerFactory.getLogger(RuleEngineImpl.class);
    private final RuleRegistry ruleRegistry;
    private final ReadyService readyService;
    private final Map<String, Map<String, Object>> contextMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private final ModuleTypeRegistry mtRegistry;
    private final CompositeModuleHandlerFactory compositeFactory;
    private final Map<String, Future<?>> scheduleTasks = new HashMap(31);
    private @Nullable ScheduledExecutorService executor;
    private final RegistryChangeListener<Rule> listener;
    private @Nullable EventPublisher eventPublisher;
    private static final String SOURCE = RuleEngineImpl.class.getSimpleName();
    private final ModuleHandlerCallback moduleHandlerCallback = new ModuleHandlerCallback(){

        @Override
        public @Nullable Boolean isEnabled(String ruleUID) {
            return RuleEngineImpl.this.isEnabled(ruleUID);
        }

        @Override
        public void setEnabled(String uid, boolean isEnabled) {
            RuleEngineImpl.this.setEnabled(uid, isEnabled);
        }

        @Override
        public @Nullable RuleStatusInfo getStatusInfo(String ruleUID) {
            return RuleEngineImpl.this.getStatusInfo(ruleUID);
        }

        @Override
        public @Nullable RuleStatus getStatus(String ruleUID) {
            return RuleEngineImpl.this.getStatus(ruleUID);
        }

        @Override
        public void runNow(String uid) {
            RuleEngineImpl.this.runNow(uid);
        }

        @Override
        public void runNow(String uid, boolean considerConditions, @Nullable Map<String, Object> context) {
            RuleEngineImpl.this.runNow(uid, considerConditions, context);
        }
    };

    @Activate
    public RuleEngineImpl(@Reference ModuleTypeRegistry moduleTypeRegistry, @Reference RuleRegistry ruleRegistry, @Reference StorageService storageService, @Reference ReadyService readyService, @Reference StartLevelService startLevelService) {
        this.disabledRulesStorage = storageService.getStorage(DISABLED_RULE_STORAGE, this.getClass().getClassLoader());
        this.mtRegistry = moduleTypeRegistry;
        this.mtRegistry.addRegistryChangeListener(this);
        this.compositeFactory = new CompositeModuleHandlerFactory(this.mtRegistry, this);
        this.ruleRegistry = ruleRegistry;
        this.readyService = readyService;
        this.startLevelService = startLevelService;
        this.listener = new RegistryChangeListener<Rule>(){

            public void added(Rule rule) {
                RuleEngineImpl.this.addRule(rule);
            }

            public void removed(Rule rule) {
                RuleEngineImpl.this.removeRule(rule.getUID());
            }

            public void updated(Rule oldRule, Rule rule) {
                this.removed(oldRule);
                this.added(rule);
            }
        };
        ruleRegistry.addRegistryChangeListener(this.listener);
        for (Rule rule : ruleRegistry.getAll()) {
            this.addRule(rule);
        }
        readyService.registerTracker((ReadyService.ReadyTracker)this, new ReadyMarkerFilter().withType("startlevel").withIdentifier(Integer.toString(40)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            if (this.isDisposed) {
                return;
            }
            this.isDisposed = true;
        }
        this.compositeFactory.deactivate();
        for (Future<?> f : this.scheduleTasks.values()) {
            f.cancel(true);
        }
        if (this.scheduleTasks.isEmpty() && this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        this.scheduleTasks.clear();
        this.contextMap.clear();
        this.mtRegistry.removeRegistryChangeListener(this);
        this.ruleRegistry.removeRegistryChangeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(ModuleType moduleType) {
        String moduleTypeName = moduleType.getUID();
        for (ModuleHandlerFactory moduleHandlerFactory : this.allModuleHandlerFactories) {
            Collection<String> moduleTypes = moduleHandlerFactory.getTypes();
            if (!moduleTypes.contains(moduleTypeName)) continue;
            RuleEngineImpl ruleEngineImpl = this;
            synchronized (ruleEngineImpl) {
                this.moduleHandlerFactories.put(moduleTypeName, moduleHandlerFactory);
                break;
            }
        }
        HashSet<String> rules = null;
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            Set<String> rulesPerModule = this.mapModuleTypeToRules.get(moduleTypeName);
            if (rulesPerModule != null) {
                rules = new HashSet<String>(rulesPerModule);
            }
        }
        if (rules != null) {
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus != RuleStatus.UNINITIALIZED) continue;
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    public void removed(ModuleType moduleType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(ModuleType oldElement, ModuleType moduleType) {
        if (moduleType.equals(oldElement)) {
            return;
        }
        String moduleTypeName = moduleType.getUID();
        HashSet<String> rules = null;
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            Set<String> rulesPerModule = this.mapModuleTypeToRules.get(moduleTypeName);
            if (rulesPerModule != null) {
                rules = new HashSet<String>(rulesPerModule);
            }
        }
        if (rules != null) {
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus == null || !RuleStatus.IDLE.equals((Object)ruleStatus) && !RuleStatus.RUNNING.equals((Object)ruleStatus)) continue;
                this.unregister(this.getManagedRule(rUID), RuleStatusDetail.HANDLER_MISSING_ERROR, "Update Module Type " + moduleType.getUID());
                this.setStatus(rUID, new RuleStatusInfo(RuleStatus.INITIALIZING));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        this.logger.debug("ModuleHandlerFactory added {}", (Object)moduleHandlerFactory.getClass().getSimpleName());
        this.allModuleHandlerFactories.add(moduleHandlerFactory);
        Collection<String> moduleTypes = moduleHandlerFactory.getTypes();
        Set notInitializedRules = null;
        for (String moduleTypeName : moduleTypes) {
            HashSet<String> rules = null;
            RuleEngineImpl ruleEngineImpl = this;
            synchronized (ruleEngineImpl) {
                this.moduleHandlerFactories.put(moduleTypeName, moduleHandlerFactory);
                Set<String> rulesPerModule = this.mapModuleTypeToRules.get(moduleTypeName);
                if (rulesPerModule != null) {
                    rules = new HashSet<String>(rulesPerModule);
                }
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus != RuleStatus.UNINITIALIZED) continue;
                notInitializedRules = notInitializedRules != null ? notInitializedRules : new HashSet(20);
                notInitializedRules.add(rUID);
            }
        }
        if (notInitializedRules != null) {
            for (String rUID : notInitializedRules) {
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    protected void removeModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        this.allModuleHandlerFactories.remove(moduleHandlerFactory);
        Collection<String> moduleTypes = moduleHandlerFactory.getTypes();
        this.removeMissingModuleTypes(moduleTypes);
        for (String moduleTypeName : moduleTypes) {
            this.moduleHandlerFactories.remove(moduleTypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRule(Rule newRule) {
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            if (this.isDisposed) {
                throw new IllegalStateException("RuleEngineImpl is disposed!");
            }
        }
        String rUID = newRule.getUID();
        WrappedRule rule = new WrappedRule(newRule);
        this.managedRules.put(rUID, rule);
        RuleStatusInfo initStatusInfo = this.disabledRulesStorage.get(rUID) == null ? new RuleStatusInfo(RuleStatus.INITIALIZING) : new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.DISABLED);
        rule.setStatusInfo(initStatusInfo);
        WrappedRule oldRule = this.getManagedRule(rUID);
        if (oldRule != null) {
            this.unregister(oldRule);
        }
        if (Boolean.TRUE.equals(this.isEnabled(rUID))) {
            this.setRule(rule);
        }
    }

    private void setRule(WrappedRule rule) {
        Future<?> f;
        if (this.isDisposed) {
            return;
        }
        String rUID = rule.getUID();
        this.setStatus(rUID, new RuleStatusInfo(RuleStatus.INITIALIZING));
        try {
            for (WrappedAction action : rule.getActions()) {
                this.updateMapModuleTypeToRule(rUID, ((Action)action.unwrap()).getTypeUID());
                action.setConnections(ConnectionValidator.getConnections(action.getInputs()));
            }
            for (WrappedCondition condition : rule.getConditions()) {
                this.updateMapModuleTypeToRule(rUID, ((Condition)condition.unwrap()).getTypeUID());
                condition.setConnections(ConnectionValidator.getConnections(condition.getInputs()));
            }
            for (WrappedTrigger trigger : rule.getTriggers()) {
                this.updateMapModuleTypeToRule(rUID, ((Trigger)trigger.unwrap()).getTypeUID());
            }
            this.validateModuleIDs(rule);
            this.autoMapConnections(rule);
            ConnectionValidator.validateConnections(this.mtRegistry, rule.unwrap());
        }
        catch (IllegalArgumentException e) {
            this.setStatus(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.INVALID_RULE, "Validation of rule " + rUID + " has failed! " + e.getLocalizedMessage()));
            return;
        }
        boolean activated = this.activateRule(rule);
        if (activated && (f = this.scheduleTasks.remove(rUID)) != null && !f.isDone()) {
            f.cancel(true);
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void postRuleStatusInfoEvent(String ruleUID, RuleStatusInfo statusInfo) {
        if (this.eventPublisher != null) {
            EventPublisher ep = this.eventPublisher;
            RuleStatusInfoEvent event = RuleEventFactory.createRuleStatusInfoEvent(statusInfo, ruleUID, SOURCE);
            try {
                ep.post((Event)event);
            }
            catch (Exception ex) {
                this.logger.error("Could not post event of type '{}'.", (Object)event.getType(), (Object)ex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T extends WrappedModule<?, ?>> @Nullable String setModuleHandlers(String rUID, List<T> modules) {
        StringBuilder sb = null;
        for (WrappedModule mm : modules) {
            String message;
            Object m = mm.unwrap();
            try {
                ModuleHandler moduleHandler = this.getModuleHandler((Module)m, rUID);
                if (moduleHandler != null) {
                    void trigger;
                    WrappedModule wrappedModule = mm;
                    if (wrappedModule instanceof WrappedAction) {
                        void action;
                        WrappedAction cfr_ignored_0 = (WrappedAction)wrappedModule;
                        WrappedAction cfr_ignored_1 = (WrappedAction)wrappedModule;
                        action.setModuleHandler((ActionHandler)moduleHandler);
                        continue;
                    }
                    WrappedModule wrappedModule2 = mm;
                    if (wrappedModule2 instanceof WrappedCondition) {
                        void condition;
                        WrappedCondition cfr_ignored_2 = (WrappedCondition)wrappedModule2;
                        WrappedCondition cfr_ignored_3 = (WrappedCondition)wrappedModule2;
                        condition.setModuleHandler((ConditionHandler)moduleHandler);
                        continue;
                    }
                    WrappedModule wrappedModule3 = mm;
                    if (!(wrappedModule3 instanceof WrappedTrigger)) continue;
                    WrappedTrigger cfr_ignored_4 = (WrappedTrigger)wrappedModule3;
                    WrappedTrigger cfr_ignored_5 = (WrappedTrigger)wrappedModule3;
                    trigger.setModuleHandler((TriggerHandler)moduleHandler);
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder();
                }
                message = "Missing handler '" + m.getTypeUID() + "' for module '" + m.getId() + "'";
                sb.append(message).append("\n");
                this.logger.trace(message);
            }
            catch (Throwable t) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                message = "Getting handler '" + m.getTypeUID() + "' for module '" + m.getId() + "' failed: " + t.getMessage();
                sb.append(message).append("\n");
                this.logger.trace(message);
            }
        }
        return sb != null ? sb.toString() : null;
    }

    private synchronized TriggerHandlerCallbackImpl getTriggerHandlerCallback(String ruleUID) {
        TriggerHandlerCallbackImpl result = this.thCallbacks.get(ruleUID);
        if (result == null) {
            result = new TriggerHandlerCallbackImpl(this, ruleUID);
            this.thCallbacks.put(ruleUID, result);
        }
        return result;
    }

    private <T extends WrappedModule<?, ?>> void removeModuleHandlers(List<T> modules, String ruleUID) {
        for (WrappedModule mm : modules) {
            Object m = mm.unwrap();
            Object handler = mm.getModuleHandler();
            if (handler == null) continue;
            ModuleHandlerFactory factory = this.getModuleHandlerFactory(m.getTypeUID());
            if (factory != null) {
                factory.ungetHandler((Module)m, ruleUID, (ModuleHandler)handler);
            }
            mm.setModuleHandler(null);
        }
    }

    private void register(WrappedRule rule) {
        String ruleUID = rule.getUID();
        TriggerHandlerCallbackImpl thCallback = this.getTriggerHandlerCallback(ruleUID);
        rule.getTriggers().forEach(trigger -> {
            TriggerHandler triggerHandler = (TriggerHandler)trigger.getModuleHandler();
            if (triggerHandler != null) {
                triggerHandler.setCallback(thCallback);
            }
        });
        rule.getConditions().forEach(condition -> {
            ConditionHandler conditionHandler = (ConditionHandler)condition.getModuleHandler();
            if (conditionHandler != null) {
                conditionHandler.setCallback(this.moduleHandlerCallback);
            }
        });
        rule.getActions().forEach(action -> {
            ActionHandler actionHandler = (ActionHandler)action.getModuleHandler();
            if (actionHandler != null) {
                actionHandler.setCallback(this.moduleHandlerCallback);
            }
        });
    }

    private void unregister(@Nullable WrappedRule r, RuleStatusDetail detail, @Nullable String msg) {
        if (r != null) {
            this.unregister(r);
            this.setStatus(r.getUID(), new RuleStatusInfo(RuleStatus.UNINITIALIZED, detail, msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(WrappedRule r) {
        String rUID = r.getUID();
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            TriggerHandlerCallbackImpl callback = this.thCallbacks.remove(rUID);
            if (callback != null) {
                callback.dispose();
            }
        }
        this.removeModuleHandlers(r.getModules(), rUID);
    }

    @Nullable ModuleHandler getModuleHandler(Module m, String ruleUID) {
        String moduleTypeId = m.getTypeUID();
        ModuleHandlerFactory mhf = this.getModuleHandlerFactory(moduleTypeId);
        if (mhf == null || this.mtRegistry.get(moduleTypeId) == null) {
            return null;
        }
        return mhf.getHandler(m, ruleUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ModuleHandlerFactory getModuleHandlerFactory(String moduleTypeId) {
        ModuleType mt;
        ModuleHandlerFactory mhf;
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            mhf = this.moduleHandlerFactories.get(moduleTypeId);
        }
        if (mhf == null && ((mt = (ModuleType)this.mtRegistry.get(moduleTypeId)) instanceof CompositeTriggerType || mt instanceof CompositeConditionType || mt instanceof CompositeActionType)) {
            mhf = this.compositeFactory;
        }
        return mhf;
    }

    public synchronized void updateMapModuleTypeToRule(String rUID, String moduleTypeId) {
        Set<String> rules = this.mapModuleTypeToRules.get(moduleTypeId);
        if (rules == null) {
            rules = new HashSet<String>(11);
        }
        rules.add(rUID);
        this.mapModuleTypeToRules.put(moduleTypeId, rules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeRule(String rUID) {
        WrappedRule r = this.managedRules.remove(rUID);
        if (r != null) {
            this.unregister(r);
            RuleEngineImpl ruleEngineImpl = this;
            synchronized (ruleEngineImpl) {
                Iterator<Map.Entry<String, Set<String>>> it = this.mapModuleTypeToRules.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Set<String>> e = it.next();
                    Set<String> rules = e.getValue();
                    if (!rules.contains(rUID)) continue;
                    rules.remove(rUID);
                    if (!rules.isEmpty()) continue;
                    it.remove();
                }
            }
            this.scheduleTasks.remove(rUID);
            return true;
        }
        return false;
    }

    private @Nullable WrappedRule getManagedRule(String rUID) {
        return this.managedRules.get(rUID);
    }

    protected @Nullable Rule getRule(String rUID) {
        WrappedRule managedRule = this.getManagedRule(rUID);
        return managedRule != null ? managedRule.unwrap() : null;
    }

    @Override
    public synchronized void setEnabled(String uid, boolean enable) {
        WrappedRule rule = this.managedRules.get(uid);
        if (rule == null) {
            throw new IllegalArgumentException(String.format("No rule with id=%s was found!", uid));
        }
        if (enable) {
            this.disabledRulesStorage.remove(uid);
            RuleStatusInfo statusInfo = rule.getStatusInfo();
            if (statusInfo.getStatus() == RuleStatus.UNINITIALIZED) {
                this.activateRule(rule);
            }
        } else {
            this.disabledRulesStorage.put(uid, (Object)true);
            this.unregister(rule, RuleStatusDetail.DISABLED, null);
        }
    }

    private boolean activateRule(WrappedRule rule) {
        RuleStatusInfo statusInfo = rule.getStatusInfo();
        RuleStatus status = statusInfo.getStatus();
        if (status != RuleStatus.UNINITIALIZED && status != RuleStatus.INITIALIZING) {
            this.logger.warn("This method should be called only if the rule has not been activated before or has been disabled.");
            return false;
        }
        String ruleUID = rule.getUID();
        String errMsgs = this.setModuleHandlers(ruleUID, rule.getModules());
        if (errMsgs != null) {
            this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.HANDLER_INITIALIZING_ERROR, errMsgs));
            this.unregister(rule);
            return false;
        }
        this.register(rule);
        this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.IDLE));
        List<Trigger> slTriggers = rule.getTriggers().stream().map(WrappedModule::unwrap).filter(t -> "core.SystemStartlevelTrigger".equals(t.getTypeUID())).toList();
        if (slTriggers.stream().anyMatch(t -> ((BigDecimal)t.getConfiguration().get("startlevel")).intValue() <= this.startLevelService.getStartLevel())) {
            this.runNow(rule.getUID(), true, Map.of("startlevel", 40, "event", SystemEventFactory.createStartlevelEvent((Integer)40)));
        }
        return true;
    }

    @Override
    public @Nullable RuleStatusInfo getStatusInfo(String ruleUID) {
        WrappedRule rule = this.managedRules.get(ruleUID);
        if (rule == null) {
            return null;
        }
        return rule.getStatusInfo();
    }

    @Override
    public @Nullable RuleStatus getStatus(String ruleUID) {
        RuleStatusInfo statusInfo = this.getStatusInfo(ruleUID);
        return statusInfo == null ? null : statusInfo.getStatus();
    }

    @Override
    public @Nullable Boolean isEnabled(String ruleUID) {
        RuleStatusInfo statusInfo = this.getStatusInfo(ruleUID);
        return statusInfo == null ? null : Boolean.valueOf(!RuleStatusDetail.DISABLED.equals((Object)statusInfo.getStatusDetail()));
    }

    private void setStatus(String ruleUID, RuleStatusInfo newStatusInfo) {
        WrappedRule rule = this.managedRules.get(ruleUID);
        if (rule == null) {
            return;
        }
        rule.setStatusInfo(newStatusInfo);
        this.postRuleStatusInfoEvent(ruleUID, newStatusInfo);
    }

    protected void scheduleRuleInitialization(String rUID) {
        Future<?> f = this.scheduleTasks.get(rUID);
        if (f == null || f.isDone()) {
            this.scheduleTasks.put(rUID, this.getScheduledExecutor().schedule(() -> {
                WrappedRule managedRule = this.getManagedRule(rUID);
                if (managedRule == null) {
                    return;
                }
                this.setRule(managedRule);
            }, 500L, TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMissingModuleTypes(Collection<String> moduleTypes) {
        Map mapMissingHandlers = null;
        for (String string : moduleTypes) {
            Set<String> rules;
            RuleEngineImpl ruleEngineImpl = this;
            synchronized (ruleEngineImpl) {
                rules = this.mapModuleTypeToRules.get(string);
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus == null) continue;
                switch (ruleStatus) {
                    case IDLE: 
                    case RUNNING: {
                        mapMissingHandlers = mapMissingHandlers != null ? mapMissingHandlers : new HashMap(20);
                        ArrayList<String> list = (ArrayList<String>)mapMissingHandlers.get(rUID);
                        if (list == null) {
                            list = new ArrayList<String>(5);
                        }
                        list.add(string);
                        mapMissingHandlers.put(rUID, list);
                        break;
                    }
                }
            }
        }
        if (mapMissingHandlers != null) {
            for (Map.Entry entry : mapMissingHandlers.entrySet()) {
                String rUID = (String)entry.getKey();
                List missingTypes = (List)entry.getValue();
                StringBuilder sb = new StringBuilder();
                sb.append("Missing handlers: ");
                for (String typeUID : missingTypes) {
                    sb.append(typeUID).append(", ");
                }
                this.unregister(this.getManagedRule(rUID), RuleStatusDetail.HANDLER_MISSING_ERROR, sb.substring(0, sb.length() - 2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRule(String ruleUID, TriggerHandlerCallbackImpl.TriggerData td) {
        if (this.thCallbacks.get(ruleUID) == null) {
            return;
        }
        if (!this.started) {
            this.logger.debug("Rule engine not yet started - not executing rule '{}',", (Object)ruleUID);
            return;
        }
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            RuleStatus ruleStatus = this.getRuleStatus(ruleUID);
            if (ruleStatus != null && ruleStatus != RuleStatus.IDLE) {
                this.logger.error("Failed to execute rule \u2018{}' with status '{}'", (Object)ruleUID, (Object)ruleStatus.name());
                return;
            }
            this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.RUNNING));
        }
        try {
            this.clearContext(ruleUID);
            this.setTriggerOutputs(ruleUID, td);
            WrappedRule rule = this.managedRules.get(ruleUID);
            if (rule != null) {
                boolean isSatisfied = this.calculateConditions(rule);
                if (isSatisfied) {
                    this.executeActions(rule, true);
                    this.logger.debug("The rule '{}' is executed.", (Object)ruleUID);
                } else {
                    this.logger.debug("The rule '{}' is NOT executed, since it has unsatisfied conditions.", (Object)ruleUID);
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to execute rule '{}': {}", (Object)ruleUID, (Object)t.getMessage());
            this.logger.debug("", t);
        }
        ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            if (this.getRuleStatus(ruleUID) == RuleStatus.RUNNING) {
                this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.IDLE));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> runNow(String ruleUID, boolean considerConditions, @Nullable Map<String, Object> context) {
        HashMap<String, Object> returnContext = new HashMap<String, Object>();
        WrappedRule rule = this.getManagedRule(ruleUID);
        if (rule == null) {
            this.logger.warn("Failed to execute rule '{}': Invalid Rule UID", (Object)ruleUID);
            return returnContext;
        }
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            RuleStatus ruleStatus = this.getRuleStatus(ruleUID);
            if (ruleStatus != null && ruleStatus != RuleStatus.IDLE) {
                this.logger.error("Failed to execute rule \u2018{}' with status '{}'", (Object)ruleUID, (Object)ruleStatus.name());
                return returnContext;
            }
            this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.RUNNING));
        }
        try {
            this.clearContext(ruleUID);
            if (context != null && !context.isEmpty()) {
                this.getContext(ruleUID, null).putAll(context);
            }
            if (!considerConditions || this.calculateConditions(rule)) {
                this.executeActions(rule, false);
            }
            this.logger.debug("The rule '{}' is executed.", (Object)ruleUID);
            returnContext.putAll(this.getContext(ruleUID, null));
        }
        catch (Throwable t) {
            this.logger.error("Failed to execute rule '{}': ", (Object)ruleUID, (Object)t);
        }
        ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            if (this.getRuleStatus(ruleUID) == RuleStatus.RUNNING) {
                this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.IDLE));
            }
        }
        return returnContext;
    }

    @Override
    public Map<String, Object> runNow(String ruleUID) {
        return this.runNow(ruleUID, false, null);
    }

    protected void clearContext(String ruleUID) {
        Map<String, Object> context = this.contextMap.get(ruleUID);
        if (context != null) {
            context.clear();
        }
    }

    private void setTriggerOutputs(String ruleUID, TriggerHandlerCallbackImpl.TriggerData td) {
        Trigger t = td.getTrigger();
        this.updateContext(ruleUID, t.getId(), td.getOutputs());
    }

    private void updateContext(String ruleUID, String moduleUID, @Nullable Map<String, ?> outputs) {
        Map<String, Object> context = this.getContext(ruleUID, null);
        if (outputs != null) {
            for (Map.Entry<String, ?> entry : outputs.entrySet()) {
                String key = moduleUID + "." + entry.getKey();
                context.put(key, entry.getValue());
            }
        }
    }

    private Map<String, Object> getContext(String ruleUID, @Nullable Set<Connection> connections) {
        Map context = this.contextMap.computeIfAbsent(ruleUID, k -> new HashMap());
        if (context == null) {
            throw new IllegalStateException("context cannot be null at that point - please report a bug.");
        }
        if (connections != null) {
            StringBuilder sb = new StringBuilder();
            for (Connection c : connections) {
                String outputModuleId = c.getOutputModuleId();
                if (outputModuleId != null) {
                    sb.append(outputModuleId).append('.').append(c.getOutputName());
                    Object outputValue = context.get(sb.toString());
                    sb.setLength(0);
                    if (outputValue == null) continue;
                    if (c.getReference() == null) {
                        context.put(c.getInputName(), outputValue);
                        continue;
                    }
                    context.put(c.getInputName(), ReferenceResolver.resolveComplexDataReference(outputValue, ReferenceResolver.splitReferenceToTokens(c.getReference())));
                    continue;
                }
                String ref = c.getReference();
                Object value = ReferenceResolver.resolveReference(ref, context);
                if (value == null) continue;
                context.put(c.getInputName(), value);
            }
        }
        return context;
    }

    private boolean calculateConditions(WrappedRule rule) {
        List<WrappedCondition> conditions = rule.getConditions();
        if (conditions.isEmpty()) {
            return true;
        }
        String ruleUID = rule.getUID();
        for (WrappedCondition wrappedCondition : conditions) {
            RuleStatus ruleStatus = this.getRuleStatus(ruleUID);
            if (ruleStatus != RuleStatus.RUNNING) {
                return false;
            }
            Condition condition = (Condition)wrappedCondition.unwrap();
            ConditionHandler tHandler = (ConditionHandler)wrappedCondition.getModuleHandler();
            Map<String, Object> context = this.getContext(ruleUID, wrappedCondition.getConnections());
            if (tHandler == null || tHandler.isSatisfied(Collections.unmodifiableMap(context))) continue;
            this.logger.debug("The condition '{}' of rule '{}' is unsatisfied.", (Object)condition.getId(), (Object)ruleUID);
            return false;
        }
        return true;
    }

    private void executeActions(WrappedRule rule, boolean stopOnFirstFail) {
        String ruleUID = rule.getUID();
        List<WrappedAction> actions = rule.getActions();
        if (actions.isEmpty()) {
            return;
        }
        for (WrappedAction wrappedAction : actions) {
            RuleStatus ruleStatus = this.getRuleStatus(ruleUID);
            if (ruleStatus != RuleStatus.RUNNING) {
                return;
            }
            Action action = (Action)wrappedAction.unwrap();
            ActionHandler aHandler = (ActionHandler)wrappedAction.getModuleHandler();
            if (aHandler == null) continue;
            Map<String, Object> context = this.getContext(ruleUID, wrappedAction.getConnections());
            try {
                Map<String, Object> outputs = aHandler.execute(Collections.unmodifiableMap(context));
                if (outputs == null) continue;
                context = this.getContext(ruleUID, null);
                this.updateContext(ruleUID, action.getId(), outputs);
            }
            catch (Throwable t) {
                String errMessage = "Failed to execute action: " + action.getId() + "(" + t.getMessage() + ")";
                if (stopOnFirstFail) {
                    this.logger.debug("Action {}-{} threw an exception: ", new Object[]{ruleUID, action.getId(), t});
                    throw new RuntimeException(errMessage, t);
                }
                this.logger.warn(errMessage, t);
            }
        }
    }

    protected @Nullable RuleStatus getRuleStatus(String rUID) {
        RuleStatusInfo info = this.getStatusInfo(rUID);
        if (info != null) {
            return info.getStatus();
        }
        return null;
    }

    private ScheduledExecutorService getScheduledExecutor() {
        ScheduledExecutorService newExecutor;
        ScheduledExecutorService currentExecutor = this.executor;
        if (currentExecutor != null && !currentExecutor.isShutdown()) {
            return currentExecutor;
        }
        this.executor = newExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("ruleengine"));
        return newExecutor;
    }

    private void validateModuleIDs(WrappedRule rule) {
        for (WrappedModule<Module, ModuleHandler> mm : rule.getModules()) {
            Module m = mm.unwrap();
            String mId = m.getId();
            if (mId.matches("[A-Za-z0-9_-]*")) continue;
            rule.setStatusInfo(new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.INVALID_RULE, "It is null or not fit to the pattern: [A-Za-z0-9_-]*"));
            throw new IllegalArgumentException("Invalid module uid: " + mId + ". It is null or not fit to the pattern: [A-Za-z0-9_-]*");
        }
    }

    private void autoMapConnections(WrappedRule rule) {
        Map<String, String> connectionMap;
        Set<Connection> connections;
        Action a;
        HashMap<Set<String>, OutputRef> triggerOutputTags = new HashMap<Set<String>, OutputRef>(11);
        for (WrappedTrigger mt : rule.getTriggers()) {
            Trigger t = (Trigger)mt.unwrap();
            TriggerType tt = (TriggerType)this.mtRegistry.get(t.getTypeUID());
            if (tt == null) continue;
            this.initTagsMap(t.getId(), tt.getOutputs(), triggerOutputTags);
        }
        HashMap<Set<String>, OutputRef> actionOutputTags = new HashMap<Set<String>, OutputRef>(11);
        for (WrappedAction ma : rule.getActions()) {
            a = (Action)ma.unwrap();
            ActionType at = (ActionType)this.mtRegistry.get(a.getTypeUID());
            if (at == null) continue;
            this.initTagsMap(a.getId(), at.getOutputs(), actionOutputTags);
        }
        if (!triggerOutputTags.isEmpty()) {
            for (WrappedCondition mc : rule.getConditions()) {
                Condition c = (Condition)mc.unwrap();
                boolean isConnectionChanged = false;
                ConditionType ct = (ConditionType)this.mtRegistry.get(c.getTypeUID());
                if (ct == null) continue;
                connections = this.copyConnections(mc.getConnections());
                for (Input input : ct.getInputs()) {
                    if (this.isConnected(input, connections) || !this.addAutoMapConnections(input, triggerOutputTags, connections)) continue;
                    isConnectionChanged = true;
                }
                if (!isConnectionChanged) continue;
                connectionMap = this.getConnectionMap(connections);
                mc.setInputs(connectionMap);
                mc.setConnections(connections);
            }
        }
        if (!triggerOutputTags.isEmpty() || !actionOutputTags.isEmpty()) {
            for (WrappedAction ma : rule.getActions()) {
                a = (Action)ma.unwrap();
                boolean isConnectionChanged = false;
                ActionType at = (ActionType)this.mtRegistry.get(a.getTypeUID());
                if (at == null) continue;
                connections = this.copyConnections(ma.getConnections());
                for (Input input : at.getInputs()) {
                    if (this.isConnected(input, connections)) continue;
                    if (this.addAutoMapConnections(input, triggerOutputTags, connections)) {
                        isConnectionChanged = true;
                    }
                    if (!this.addAutoMapConnections(input, actionOutputTags, connections)) continue;
                    isConnectionChanged = true;
                }
                if (!isConnectionChanged) continue;
                connectionMap = this.getConnectionMap(connections);
                ma.setInputs(connectionMap);
                ma.setConnections(connections);
            }
        }
    }

    private boolean addAutoMapConnections(Input input, Map<Set<String>, OutputRef> outputTagMap, Set<Connection> currentConnections) {
        boolean result = false;
        Set<String> inputTags = input.getTags();
        OutputRef outputRef = null;
        boolean conflict = false;
        if (!inputTags.isEmpty()) {
            for (Map.Entry<Set<String>, OutputRef> entry : outputTagMap.entrySet()) {
                if (!entry.getKey().containsAll(inputTags)) continue;
                if (outputRef == null) {
                    outputRef = entry.getValue();
                    continue;
                }
                conflict = true;
                break;
            }
            if (!conflict && outputRef != null) {
                currentConnections.add(new Connection(input.getName(), outputRef.getModuleId(), outputRef.getOutputName(), null));
                result = true;
            }
        }
        return result;
    }

    private void initTagsMap(String moduleId, List<Output> outputs, Map<Set<String>, OutputRef> tagMap) {
        for (Output output : outputs) {
            Set<String> tags = output.getTags();
            if (tags.isEmpty()) continue;
            if (tagMap.get(tags) != null) {
                tagMap.remove(tags);
                continue;
            }
            tagMap.put(tags, new OutputRef(moduleId, output.getName()));
        }
    }

    private boolean isConnected(Input input, Set<Connection> connections) {
        for (Connection connection : connections) {
            if (!connection.getInputName().equals(input.getName())) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> getConnectionMap(Set<Connection> connections) {
        HashMap<String, String> connectionMap = new HashMap<String, String>();
        for (Connection connection : connections) {
            connectionMap.put(connection.getInputName(), connection.getOutputModuleId() + "." + connection.getOutputName());
        }
        return connectionMap;
    }

    private Set<Connection> copyConnections(Set<Connection> connections) {
        HashSet<Connection> result = new HashSet<Connection>(connections.size());
        for (Connection c : connections) {
            result.add(new Connection(c.getInputName(), c.getOutputModuleId(), c.getOutputName(), c.getReference()));
        }
        return result;
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        this.executeRulesWithStartLevel();
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        this.started = false;
    }

    private void executeRulesWithStartLevel() {
        this.getScheduledExecutor().submit(() -> {
            this.ruleRegistry.getAll().stream().filter(this::mustTrigger).forEach(r -> {
                Map<String, Object> map = this.runNow(r.getUID(), true, Map.of("startlevel", 40, "event", SystemEventFactory.createStartlevelEvent((Integer)40)));
            });
            this.started = true;
            this.readyService.markReady(MARKER);
            this.logger.info("Rule engine started.");
        });
    }

    private boolean mustTrigger(Rule r) {
        for (Trigger t : r.getTriggers()) {
            int sl;
            if (!"core.SystemStartlevelTrigger".equals(t.getTypeUID()) || (sl = ((BigDecimal)t.getConfiguration().get("startlevel")).intValue()) > 50) continue;
            return true;
        }
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Stream<RuleExecution> simulateRuleExecutions(ZonedDateTime from, ZonedDateTime until) {
        return new RuleExecutionSimulator(this.ruleRegistry, this).simulateRuleExecutions(from, until);
    }

    static class OutputRef {
        private final String moduleId;
        private final String outputName;

        public OutputRef(String moduleId, String outputName) {
            this.moduleId = moduleId;
            this.outputName = outputName;
        }

        public String getModuleId() {
            return this.moduleId;
        }

        public String getOutputName() {
            return this.outputName;
        }
    }
}

