/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.component.dsl.internal.ConcurrentDoublyLinkedList;

class NodeImpl<E>
extends AtomicReference<NodeImpl<E>>
implements ConcurrentDoublyLinkedList.Node {
    private volatile NodeImpl<E> prev;
    final E element;

    NodeImpl(E element, NodeImpl<E> next, NodeImpl<E> prev) {
        super(next);
        this.prev = prev;
        this.element = element;
    }

    NodeImpl(NodeImpl<E> next) {
        super(next);
        this.prev = this;
        this.element = null;
    }

    @Override
    public boolean remove() {
        if (this.isDeleted()) {
            return false;
        }
        while (!this.delete() && !this.isDeleted()) {
        }
        return true;
    }

    private NodeImpl<E> getNext() {
        return (NodeImpl)this.get();
    }

    void setNext(NodeImpl<E> n) {
        this.set(n);
    }

    private boolean casNext(NodeImpl<E> cmp, NodeImpl<E> val) {
        return this.compareAndSet(cmp, val);
    }

    private NodeImpl<E> getPrev() {
        return this.prev;
    }

    void setPrev(NodeImpl<E> b) {
        this.prev = b;
    }

    boolean isSpecial() {
        return this.element == null;
    }

    boolean isTrailer() {
        return this.getNext() == null;
    }

    boolean isHeader() {
        return this.getPrev() == null;
    }

    boolean isMarker() {
        return this.getPrev() == this;
    }

    boolean isDeleted() {
        NodeImpl<E> f = this.getNext();
        return f != null && f.isMarker();
    }

    private NodeImpl<E> nextNonmarker() {
        NodeImpl<E> f = this.getNext();
        return f == null || !f.isMarker() ? f : super.getNext();
    }

    NodeImpl<E> successor() {
        NodeImpl<E> f = this.nextNonmarker();
        while (f != null) {
            if (!f.isDeleted()) {
                if (super.getPrev() != this && !this.isDeleted()) {
                    f.setPrev(this);
                }
                return f;
            }
            NodeImpl<E> s = super.nextNonmarker();
            if (f == this.getNext()) {
                this.casNext(f, s);
            }
            f = s;
        }
        return null;
    }

    private NodeImpl<E> findPredecessorOf(NodeImpl<E> target) {
        NodeImpl<E> n = this;
        NodeImpl<E> f;
        while ((f = n.successor()) != target) {
            if (f == null) {
                return null;
            }
            n = f;
        }
        return n;
    }

    NodeImpl<E> predecessor() {
        NodeImpl<E> n = this;
        NodeImpl<E> b;
        while ((b = n.getPrev()) != null) {
            NodeImpl<E> p;
            NodeImpl<E> s = super.getNext();
            if (s == this) {
                return b;
            }
            if (!(s != null && s.isMarker() || (p = super.findPredecessorOf(this)) == null)) {
                return p;
            }
            n = b;
        }
        return n.findPredecessorOf(this);
    }

    NodeImpl<E> forward() {
        NodeImpl<E> f = this.successor();
        return f == null || f.isSpecial() ? null : f;
    }

    NodeImpl<E> back() {
        NodeImpl<E> f = this.predecessor();
        return f == null || f.isSpecial() ? null : f;
    }

    NodeImpl<E> append(E element) {
        NodeImpl<E> x;
        NodeImpl<E> f;
        do {
            if ((f = this.getNext()) != null && !f.isMarker()) continue;
            return null;
        } while (!this.casNext(f, x = new NodeImpl<E>(element, f, this)));
        f.setPrev(x);
        return x;
    }

    NodeImpl<E> prepend(E element) {
        NodeImpl<E> x;
        NodeImpl<E> b;
        do {
            if ((b = this.predecessor()) != null) continue;
            return null;
        } while (!super.casNext(this, x = new NodeImpl<E>(element, this, b)));
        this.setPrev(x);
        return x;
    }

    boolean delete() {
        NodeImpl<E> b = this.getPrev();
        NodeImpl<E> f = this.getNext();
        if (b != null && f != null && !f.isMarker() && this.casNext(f, new NodeImpl<E>(f))) {
            if (super.casNext(this, f)) {
                f.setPrev(b);
            }
            return true;
        }
        return false;
    }

    NodeImpl<E> replace(E newElement) {
        NodeImpl<E> b;
        NodeImpl<E> x;
        NodeImpl<E> f;
        do {
            b = this.getPrev();
            f = this.getNext();
            if (b != null && f != null && !f.isMarker()) continue;
            return null;
        } while (!this.casNext(f, new NodeImpl<E>(x = new NodeImpl<E>(newElement, f, b))));
        b.successor();
        x.successor();
        return x;
    }
}

