/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.core.valueconverter;

import java.math.BigDecimal;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

@NonNullByDefault
public class ValueTypeToStringConverter
implements IValueConverter<Object> {
    public @Nullable Object toValue(@Nullable String string, @Nullable INode node) throws ValueConverterException {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            try {
                return Strings.convertFromJavaString((String)string.substring(1, string.length() - 1), (boolean)true);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }
        if ("true".equals(string) || "false".equals(string)) {
            return Boolean.valueOf(string);
        }
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Number expected.", node, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString(@Nullable Object value) throws ValueConverterException {
        if (value == null) {
            throw new ValueConverterException("Value may not be null.", null, null);
        }
        Object object = value;
        if (object instanceof String) {
            void string;
            String string2 = (String)object;
            String cfr_ignored_0 = (String)object;
            return this.toEscapedString((String)string);
        }
        Object object2 = value;
        if (object2 instanceof BigDecimal) {
            void decimalValue;
            BigDecimal bigDecimal = (BigDecimal)object2;
            BigDecimal cfr_ignored_1 = (BigDecimal)object2;
            return decimalValue.toPlainString();
        }
        Object object3 = value;
        if (object3 instanceof Boolean) {
            void boolean1;
            Boolean bl = (Boolean)object3;
            Boolean cfr_ignored_2 = (Boolean)object3;
            return boolean1.toString();
        }
        throw new ValueConverterException("Unknown value type: " + value.getClass().getSimpleName(), null, null);
    }

    protected String toEscapedString(String value) {
        return "\"" + Strings.convertToJavaString((String)value, (boolean)false) + "\"";
    }
}

