/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.monitor.internal.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.monitor.internal.metrics.OpenhabCoreMeterBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class JVMMetric
implements OpenhabCoreMeterBinder {
    private final Logger logger = LoggerFactory.getLogger(JVMMetric.class);
    private static final Tag CORE_JVM_METRIC_TAG = Tag.of("metric", "openhab.core.metric.jvm");
    private final Set<Tag> tags = new HashSet<Tag>();
    private @Nullable MeterRegistry meterRegistry;

    public JVMMetric(Collection<Tag> tags) {
        this.tags.addAll(tags);
        this.tags.add(CORE_JVM_METRIC_TAG);
    }

    @Override
    public void bindTo(@NonNullByDefault(value={}) MeterRegistry registry) {
        this.unbind();
        this.logger.debug("JVMMetric is being bound...");
        this.meterRegistry = registry;
        new ClassLoaderMetrics(this.tags).bindTo(this.meterRegistry);
        new JvmMemoryMetrics(this.tags).bindTo(this.meterRegistry);
        new JvmGcMetrics(this.tags).bindTo(this.meterRegistry);
        new ProcessorMetrics(this.tags).bindTo(this.meterRegistry);
        new JvmThreadMetrics(this.tags).bindTo(this.meterRegistry);
    }

    @Override
    public void unbind() {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            return;
        }
        for (Meter meter : meterRegistry.getMeters()) {
            if (!meter.getId().getTags().contains(CORE_JVM_METRIC_TAG)) continue;
            meterRegistry.remove(meter);
        }
        this.meterRegistry = null;
    }
}

