/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.monitor.internal.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.monitor.internal.metrics.OpenhabCoreMeterBinder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class BundleStateMetric
implements OpenhabCoreMeterBinder,
BundleListener {
    private final Logger logger = LoggerFactory.getLogger(BundleStateMetric.class);
    public static final String METRIC_NAME = "openhab.bundle.state";
    private static final String BUNDLE_TAG_NAME = "bundle";
    private final Meter.Id commonMeterId;
    private final Map<Meter.Id, AtomicInteger> registeredMeters = new HashMap<Meter.Id, AtomicInteger>();
    private @Nullable MeterRegistry meterRegistry;
    private final BundleContext bundleContext;

    public BundleStateMetric(BundleContext bundleContext, Collection<Tag> tags) {
        this.commonMeterId = new Meter.Id(METRIC_NAME, Tags.of(tags), "state", "openHAB OSGi bundles state", Meter.Type.GAUGE);
        this.bundleContext = bundleContext;
    }

    @Override
    public void bindTo(@NonNullByDefault(value={}) MeterRegistry meterRegistry) {
        this.unbind();
        this.logger.debug("BundleStateMetric is being bound...");
        this.meterRegistry = meterRegistry;
        Stream.of(this.bundleContext.getBundles()).forEach(bundle -> this.createOrUpdateMetricForBundleState(bundle.getSymbolicName(), bundle.getState()));
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void bundleChanged(@NonNullByDefault(value={}) BundleEvent bundleEvent) {
        if (this.meterRegistry == null) {
            return;
        }
        String bundleName = bundleEvent.getBundle().getSymbolicName();
        int state = bundleEvent.getBundle().getState();
        this.createOrUpdateMetricForBundleState(bundleName, state);
    }

    private void createOrUpdateMetricForBundleState(String bundleName, int state) {
        Meter.Id uniqueId = this.commonMeterId.withTag(Tag.of(BUNDLE_TAG_NAME, bundleName));
        AtomicInteger bundleStateHolder = this.registeredMeters.get(uniqueId);
        if (bundleStateHolder == null) {
            bundleStateHolder = new AtomicInteger();
            Gauge.builder(uniqueId.getName(), bundleStateHolder, AtomicInteger::get).baseUnit(uniqueId.getBaseUnit()).description(uniqueId.getDescription()).tags(uniqueId.getTags()).register(this.meterRegistry);
            this.registeredMeters.put(uniqueId, bundleStateHolder);
        }
        bundleStateHolder.set(state);
    }

    @Override
    public void unbind() {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            return;
        }
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.registeredMeters.keySet().forEach(meterRegistry::remove);
        this.registeredMeters.clear();
        this.meterRegistry = null;
    }
}

