/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.auth.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.lang.JoseException;
import org.openhab.core.OpenHAB;
import org.openhab.core.auth.Authentication;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.auth.User;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={JwtHelper.class})
public class JwtHelper {
    private final Logger logger = LoggerFactory.getLogger(JwtHelper.class);
    private static final String KEY_FILE_PATH = OpenHAB.getUserDataFolder() + File.separator + "secrets" + File.separator + "rsa_json_web_key.json";
    private static final String ISSUER_NAME = "openhab";
    private static final String AUDIENCE = "openhab";
    private RsaJsonWebKey jwtWebKey;

    public JwtHelper() {
        try {
            this.jwtWebKey = this.loadOrGenerateKey();
        }
        catch (Exception e) {
            this.logger.error("Error while initializing the JWT helper", (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private RsaJsonWebKey generateNewKey() throws JoseException, IOException {
        RsaJsonWebKey newKey = RsaJwkGenerator.generateJwk((int)2048);
        File file = new File(KEY_FILE_PATH);
        file.getParentFile().mkdirs();
        String keyJson = newKey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
        Files.writeString(file.toPath(), (CharSequence)keyJson, StandardCharsets.UTF_8, new OpenOption[0]);
        return newKey;
    }

    private RsaJsonWebKey loadOrGenerateKey() throws JoseException, IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(KEY_FILE_PATH, new String[0]));){
                return (RsaJsonWebKey)JsonWebKey.Factory.newJwk((String)reader.readLine());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JoseException e) {
            RsaJsonWebKey key = this.generateNewKey();
            this.logger.debug("Created JWT signature key in {}", (Object)KEY_FILE_PATH);
            return key;
        }
    }

    public String getJwtAccessToken(User user, String clientId, String scope, int tokenLifetime) {
        try {
            JwtClaims jwtClaims = new JwtClaims();
            jwtClaims.setIssuer("openhab");
            jwtClaims.setAudience("openhab");
            jwtClaims.setExpirationTimeMinutesInTheFuture((float)tokenLifetime);
            jwtClaims.setGeneratedJwtId();
            jwtClaims.setIssuedAtToNow();
            jwtClaims.setNotBeforeMinutesInThePast(2.0f);
            jwtClaims.setSubject(user.getName());
            jwtClaims.setClaim("client_id", (Object)clientId);
            jwtClaims.setClaim("scope", (Object)scope);
            jwtClaims.setStringListClaim("role", new ArrayList(user.getRoles() != null ? user.getRoles() : Set.of()));
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(jwtClaims.toJson());
            jws.setKey((Key)this.jwtWebKey.getPrivateKey());
            jws.setKeyIdHeaderValue(this.jwtWebKey.getKeyId());
            jws.setAlgorithmHeaderValue("RS256");
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new IllegalStateException("Error while writing JWT token", e);
        }
    }

    public Authentication verifyAndParseJwtAccessToken(String jwt) throws AuthenticationException {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setRequireSubject().setExpectedIssuer("openhab").setExpectedAudience(new String[]{"openhab"}).setVerificationKey(this.jwtWebKey.getKey()).setJwsAlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"RS256"}).build();
        try {
            JwtClaims jwtClaims = jwtConsumer.processToClaims(jwt);
            String username = jwtClaims.getSubject();
            List roles = jwtClaims.getStringListClaimValue("role");
            String scope = jwtClaims.getStringClaimValue("scope");
            return new Authentication(username, roles.toArray(new String[roles.size()]), scope);
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new AuthenticationException("Error while processing JWT token", e);
        }
    }
}

