/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.osgi.util.converter.ConvertingImpl;
import org.osgi.util.converter.DynamicMapLikeFacade;
import org.osgi.util.converter.Util;

class DynamicBeanFacade
extends DynamicMapLikeFacade<String, Object> {
    private Map<String, Method> keys = null;
    private final Object backingObject;
    private final Class<?> beanClass;

    DynamicBeanFacade(Object backingObject, Class<?> beanClass, ConvertingImpl convertingImpl) {
        super(convertingImpl);
        this.backingObject = backingObject;
        this.beanClass = beanClass;
    }

    @Override
    public Object get(Object key) {
        Method m = this.getKeys().get(key);
        try {
            return m.invoke(this.backingObject, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        return this.getKeys().keySet();
    }

    private Map<String, Method> getKeys() {
        if (this.keys == null) {
            this.keys = Util.getBeanKeys(this.beanClass);
        }
        return this.keys;
    }
}

