/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal.osgi;

import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.bundle.core.BundleStateService;
import org.apache.karaf.bundle.core.BundleWatcher;
import org.apache.karaf.bundle.core.internal.BundleServiceImpl;
import org.apache.karaf.bundle.core.internal.BundleWatcherImpl;
import org.apache.karaf.bundle.core.internal.BundlesMBeanImpl;
import org.apache.karaf.bundle.core.internal.MavenConfigService;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Services(requires={@RequireService(value=ConfigurationAdmin.class)}, provides={@ProvideService(value=BundleService.class)})
public class Activator
extends BaseActivator {
    private ServiceTracker<BundleStateService, BundleStateService> bundleStateServicesTracker;
    private BundleWatcherImpl bundleWatcher;

    @Override
    protected void doStart() throws Exception {
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin == null) {
            return;
        }
        final BundleServiceImpl bundleService = new BundleServiceImpl(this.bundleContext);
        this.register(BundleService.class, bundleService);
        this.bundleStateServicesTracker = new ServiceTracker(this.bundleContext, BundleStateService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<BundleStateService, BundleStateService>(){

            public BundleStateService addingService(ServiceReference<BundleStateService> reference) {
                BundleStateService service = (BundleStateService)Activator.this.bundleContext.getService(reference);
                bundleService.registerBundleStateService(service);
                return service;
            }

            public void modifiedService(ServiceReference<BundleStateService> reference, BundleStateService service) {
            }

            public void removedService(ServiceReference<BundleStateService> reference, BundleStateService service) {
                bundleService.unregisterBundleStateService(service);
                Activator.this.bundleContext.ungetService(reference);
            }
        });
        this.bundleStateServicesTracker.open();
        this.bundleWatcher = new BundleWatcherImpl(this.bundleContext, new MavenConfigService(configurationAdmin), bundleService);
        this.bundleWatcher.start();
        this.register(BundleWatcher.class, this.bundleWatcher);
        BundlesMBeanImpl bundlesMBeanImpl = new BundlesMBeanImpl(this.bundleContext, bundleService);
        this.registerMBean(bundlesMBeanImpl, "type=bundle");
    }

    @Override
    protected void doStop() {
        if (this.bundleStateServicesTracker != null) {
            this.bundleStateServicesTracker.close();
            this.bundleStateServicesTracker = null;
        }
        super.doStop();
        if (this.bundleWatcher != null) {
            this.bundleWatcher.stop();
            this.bundleWatcher = null;
        }
    }
}

