/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldUByte
extends JBBPAbstractField
implements JBBPNumericField {
    private static final long serialVersionUID = -1280322774219967406L;
    private final byte value;

    public JBBPFieldUByte(JBBPNamedFieldInfo name, byte value) {
        super(name);
        this.value = value;
    }

    public static long reverseBits(byte value) {
        return JBBPUtils.reverseBitsInByte(value) & 0xFF;
    }

    @Override
    public double getAsDouble() {
        return this.value & 0xFF;
    }

    @Override
    public float getAsFloat() {
        return this.value & 0xFF;
    }

    @Override
    public int getAsInt() {
        return this.value & 0xFF;
    }

    @Override
    public long getAsLong() {
        return this.getAsInt();
    }

    @Override
    public boolean getAsBool() {
        return this.value != 0;
    }

    @Override
    public long getAsInvertedBitOrder() {
        return JBBPFieldUByte.reverseBits(this.value);
    }

    @Override
    public String getTypeAsString() {
        return "ubyte";
    }
}

