/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler.varlen;

import com.igormaznitsa.jbbp.JBBPNamedNumericFieldMap;
import com.igormaznitsa.jbbp.compiler.JBBPCompiledBlock;
import com.igormaznitsa.jbbp.compiler.JBBPCompilerUtils;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.conversion.ExpressionEvaluatorVisitor;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.exceptions.JBBPCompilationException;
import com.igormaznitsa.jbbp.exceptions.JBBPEvalException;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPIntCounter;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JBBPExpressionEvaluator
implements JBBPIntegerValueEvaluator {
    private static final long serialVersionUID = -2951446352849455161L;
    private static final int PSEUDOCODE_LEFT_BRACKET = 0;
    private static final int CODE_VAR = 1;
    private static final int CODE_EXTVAR = 2;
    private static final int CODE_CONST = 3;
    private static final int CODE_NOT = 4;
    private static final int CODE_UNARYMINUS = 5;
    private static final int CODE_UNARYPLUS = 6;
    private static final int CODE_ADD = 7;
    private static final int CODE_MINUS = 8;
    private static final int CODE_MUL = 9;
    private static final int CODE_DIV = 10;
    private static final int CODE_MOD = 11;
    private static final int CODE_OR = 12;
    private static final int CODE_XOR = 13;
    private static final int CODE_AND = 14;
    private static final int CODE_LSHIFT = 15;
    private static final int CODE_RSHIFT = 16;
    private static final int CODE_RSIGNSHIFT = 17;
    private static final int[] PRIORITIES = new int[]{0, 1000, 1000, 1000, 500, 500, 500, 200, 200, 300, 300, 300, 50, 100, 150, 175, 175, 175};
    private static final String[] SYMBOLS = new String[]{"(", "", "", "", "~", "-", "+", "+", "-", "*", "/", "%", "|", "^", "&", "<<", ">>", ">>>"};
    private static final char[] OPERATOR_FIRST_CHARS = new char[]{'(', '+', '-', '*', '/', '%', '|', '&', '^', '~', ')', '>', '<'};
    private static final Pattern PATTERN = Pattern.compile("([0-9]+)|([()])|(<<|>>>|>>|[%*+\\-/&|^~])|([\\S][^<>\\s+%*\\-/()&|^~]*)");
    private final byte[] compiledExpression;
    private final String expressionSource;
    private final String[] externalValueNames;
    private final int maxStackDepth;

    public JBBPExpressionEvaluator(String expression, List<JBBPNamedFieldInfo> namedFields, byte[] compiledData) {
        this.expressionSource = expression;
        Matcher matcher = PATTERN.matcher(expression);
        int lastFound = -1;
        ByteArrayOutputStream compiledScript = new ByteArrayOutputStream(256);
        ArrayList<Integer> operationStack = new ArrayList<Integer>();
        boolean prevoperator = false;
        int unaryOperatorCode = -1;
        boolean theFirstInTheSubExpression = true;
        int counterOperators = 0;
        int counterVarsAndConstants = 0;
        ArrayList<String> externalValueNameList = new ArrayList<String>();
        while (matcher.find()) {
            String substr;
            if (lastFound >= 0 && (substr = expression.substring(lastFound, matcher.start())).trim().length() != 0) {
                throw new JBBPCompilationException("Can't recognize part of expression '" + substr + "' [" + expression + ']');
            }
            lastFound = matcher.end();
            String number = matcher.group(1);
            String bracket = matcher.group(2);
            String operator = matcher.group(3);
            String variable = matcher.group(4);
            if (variable != null) {
                int nameIndex;
                boolean extValue;
                prevoperator = false;
                ++counterVarsAndConstants;
                String normalized = JBBPUtils.normalizeFieldNameOrPath(variable);
                if (normalized.startsWith("$")) {
                    extValue = true;
                    nameIndex = externalValueNameList.size();
                    externalValueNameList.add(normalized.substring(1));
                } else {
                    extValue = false;
                    nameIndex = JBBPCompilerUtils.findIndexForFieldPath(normalized, namedFields);
                    if (nameIndex < 0) {
                        throw new JBBPCompilationException("Unknown variable [" + variable + ']');
                    }
                    JBBPCompilerUtils.assertFieldIsNotArrayOrInArray(namedFields.get(nameIndex), namedFields, compiledData);
                }
                try {
                    compiledScript.write(extValue ? 2 : 1);
                    compiledScript.write(JBBPUtils.packInt(nameIndex));
                    if (unaryOperatorCode > 0) {
                        switch (unaryOperatorCode) {
                            case 7: {
                                break;
                            }
                            case 5: 
                            case 8: {
                                compiledScript.write(5);
                                break;
                            }
                            case 4: {
                                compiledScript.write(4);
                                break;
                            }
                            default: {
                                throw new Error("Unsupported unary operator [" + SYMBOLS[unaryOperatorCode] + ']');
                            }
                        }
                        unaryOperatorCode = -1;
                    }
                }
                catch (IOException ex) {
                    throw new Error("Unexpected IO exception", ex);
                }
                theFirstInTheSubExpression = false;
                continue;
            }
            if (operator != null) {
                int code;
                ++counterOperators;
                if ("+".equals(operator)) {
                    code = 7;
                } else if ("-".equals(operator)) {
                    code = 8;
                } else if ("*".equals(operator)) {
                    code = 9;
                } else if ("%".equals(operator)) {
                    code = 11;
                } else if ("/".equals(operator)) {
                    code = 10;
                } else if ("&".equals(operator)) {
                    code = 14;
                } else if ("|".equals(operator)) {
                    code = 12;
                } else if ("^".equals(operator)) {
                    code = 13;
                } else if ("~".equals(operator)) {
                    code = 4;
                } else if ("<<".equals(operator)) {
                    code = 15;
                } else if (">>".equals(operator)) {
                    code = 16;
                } else if (">>>".equals(operator)) {
                    code = 17;
                } else {
                    throw new Error("Detected unsupported operator, contact developer [" + operator + ']');
                }
                if (theFirstInTheSubExpression) {
                    this.assertUnaryOperator(operator);
                    unaryOperatorCode = JBBPExpressionEvaluator.codeToUnary(code);
                } else if (prevoperator) {
                    if (unaryOperatorCode > 0) {
                        this.assertUnaryOperator(operator);
                        operationStack.add(unaryOperatorCode);
                        unaryOperatorCode = JBBPExpressionEvaluator.codeToUnary(code);
                    } else {
                        this.assertUnaryOperator(operator);
                        unaryOperatorCode = JBBPExpressionEvaluator.codeToUnary(code);
                    }
                } else {
                    int top;
                    unaryOperatorCode = -1;
                    int currentPriority = PRIORITIES[code];
                    while (!operationStack.isEmpty() && PRIORITIES[top = ((Integer)operationStack.get(operationStack.size() - 1)).intValue()] >= currentPriority) {
                        operationStack.remove(operationStack.size() - 1);
                        compiledScript.write(top);
                    }
                    operationStack.add(code);
                }
                prevoperator = true;
                theFirstInTheSubExpression = false;
                continue;
            }
            if (bracket != null) {
                prevoperator = false;
                if ("(".equals(bracket)) {
                    if (unaryOperatorCode > 0) {
                        operationStack.add(unaryOperatorCode);
                        unaryOperatorCode = -1;
                    }
                    operationStack.add(0);
                    theFirstInTheSubExpression = true;
                    continue;
                }
                if (")".equals(bracket)) {
                    boolean metLeftPart = false;
                    while (!operationStack.isEmpty()) {
                        int top = (Integer)operationStack.remove(operationStack.size() - 1);
                        if (top != 0) {
                            compiledScript.write(top);
                            continue;
                        }
                        metLeftPart = true;
                        break;
                    }
                    if (metLeftPart) continue;
                    throw new JBBPCompilationException("Detected unclosed bracket [" + this.expressionSource + ']');
                }
                throw new Error("Detected unsupported bracket, connect developer for the error [" + bracket + ']');
            }
            if (number == null) continue;
            ++counterVarsAndConstants;
            prevoperator = false;
            try {
                int parsed = Integer.parseInt(number);
                if (unaryOperatorCode >= 0) {
                    switch (unaryOperatorCode) {
                        case 6: 
                        case 7: {
                            break;
                        }
                        case 5: 
                        case 8: {
                            parsed = -parsed;
                            break;
                        }
                        case 4: {
                            parsed ^= 0xFFFFFFFF;
                            break;
                        }
                        default: {
                            throw new Error("Unsupported unary operator [" + SYMBOLS[unaryOperatorCode] + ']');
                        }
                    }
                }
                unaryOperatorCode = -1;
                compiledScript.write(3);
                try {
                    compiledScript.write(JBBPUtils.packInt(parsed));
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unexpected IO exception", ex);
                }
            }
            catch (NumberFormatException ex) {
                throw new JBBPCompilationException("Can't parse a numeric constant, only decimal integers are supported '" + number + "' [" + this.expressionSource + ']', null, ex);
            }
            theFirstInTheSubExpression = false;
        }
        if (unaryOperatorCode > 0) {
            throw new JBBPCompilationException("Unary operator without argument '" + SYMBOLS[unaryOperatorCode] + "' [" + this.expressionSource + ']');
        }
        if (counterOperators == 0) {
            if (counterVarsAndConstants == 0) {
                throw new JBBPCompilationException("Empty expression [" + this.expressionSource + ']');
            }
            if (counterVarsAndConstants > 1) {
                throw new JBBPCompilationException("No operators [" + this.expressionSource + ']');
            }
        }
        while (!operationStack.isEmpty()) {
            int top = (Integer)operationStack.remove(operationStack.size() - 1);
            if (top == 0) {
                throw new JBBPCompilationException("Detected unclosed bracket [" + this.expressionSource + ']');
            }
            compiledScript.write(top);
        }
        if (lastFound < 0) {
            throw new JBBPCompilationException("Can't extract expression [" + this.expressionSource + ']');
        }
        this.compiledExpression = compiledScript.toByteArray();
        this.externalValueNames = externalValueNameList.isEmpty() ? null : externalValueNameList.toArray(new String[externalValueNameList.size()]);
        this.maxStackDepth = this.calculateMaxStackDepth();
    }

    private static int codeToUnary(int code) {
        int result;
        switch (code) {
            case 8: {
                result = 5;
                break;
            }
            case 7: {
                result = 6;
                break;
            }
            default: {
                result = code;
            }
        }
        return result;
    }

    private static String code2operator(int code) {
        String result;
        switch (code) {
            case 14: {
                result = "&";
                break;
            }
            case 6: 
            case 7: {
                result = "+";
                break;
            }
            case 12: {
                result = "|";
                break;
            }
            case 10: {
                result = "/";
                break;
            }
            case 9: {
                result = "*";
                break;
            }
            case 11: {
                result = "%";
                break;
            }
            case 15: {
                result = "<<";
                break;
            }
            case 16: {
                result = ">>";
                break;
            }
            case 17: {
                result = ">>>";
                break;
            }
            case 5: 
            case 8: {
                result = "-";
                break;
            }
            case 13: {
                result = "^";
                break;
            }
            default: {
                result = "CODE:" + code;
            }
        }
        return result;
    }

    public static boolean hasExpressionOperators(String str) {
        boolean result = false;
        for (char chr : OPERATOR_FIRST_CHARS) {
            if (str.indexOf(chr) < 0) continue;
            result = true;
            break;
        }
        return result;
    }

    private void assertUnaryOperator(String operator) {
        if (!("+".equals(operator) || "-".equals(operator) || "~".equals(operator))) {
            throw new JBBPCompilationException("Wrong unary operator '" + operator + "' [" + this.expressionSource + ']');
        }
    }

    private int calculateMaxStackDepth() {
        int stackMaxPosition = 0;
        int stackPosition = 0;
        JBBPIntCounter counter = new JBBPIntCounter();
        block5: while (counter.get() < this.compiledExpression.length) {
            byte code = this.compiledExpression[counter.getAndIncrement()];
            switch (code) {
                case 1: 
                case 2: 
                case 3: {
                    JBBPUtils.unpackInt(this.compiledExpression, counter);
                    stackMaxPosition = Math.max(++stackPosition, stackMaxPosition);
                    continue block5;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    if (stackPosition < 2) {
                        throw new JBBPEvalException("Operator '" + JBBPExpressionEvaluator.code2operator(code) + "' needs two operands", this);
                    }
                    --stackPosition;
                    continue block5;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (stackPosition >= 1) continue block5;
                    throw new JBBPEvalException("Operator '" + JBBPExpressionEvaluator.code2operator(code) + "' needs operand", this);
                }
            }
            throw new Error("Detected unsupported operation, contact developer");
        }
        if (stackPosition != 1 || stackPosition > stackMaxPosition) {
            throw new JBBPEvalException("Wrong expression [" + this.expressionSource + "] (" + stackPosition + ':' + stackMaxPosition + ')', this);
        }
        return stackMaxPosition;
    }

    public int getMaxStackDepth() {
        return this.maxStackDepth;
    }

    @Override
    public int eval(JBBPBitInputStream inStream, int currentCompiledBlockOffset, JBBPCompiledBlock compiledBlockData, JBBPNamedNumericFieldMap fieldMap) {
        int[] stack = new int[this.maxStackDepth];
        int stackDepth = 0;
        JBBPIntCounter counter = new JBBPIntCounter();
        block18: while (counter.get() < this.compiledExpression.length) {
            byte code = this.compiledExpression[counter.getAndIncrement()];
            switch (code) {
                case 1: 
                case 2: {
                    int value;
                    int index = JBBPUtils.unpackInt(this.compiledExpression, counter);
                    if (code == 2) {
                        value = "$".equals(this.externalValueNames[index]) ? (int)inStream.getCounter() : fieldMap.getExternalFieldValue(this.externalValueNames[index], compiledBlockData, this);
                    } else {
                        JBBPNamedFieldInfo namedField = compiledBlockData.getNamedFields()[index];
                        JBBPNumericField numericField = fieldMap.get(namedField);
                        if (numericField == null) {
                            throw new ArithmeticException("Can't find field '" + namedField.getFieldName() + "' among numeric fields");
                        }
                        value = fieldMap.get(namedField).getAsInt();
                    }
                    stack[stackDepth++] = value;
                    continue block18;
                }
                case 3: {
                    stack[stackDepth++] = JBBPUtils.unpackInt(this.compiledExpression, counter);
                    continue block18;
                }
                case 7: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] + top;
                    continue block18;
                }
                case 14: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] & top;
                    continue block18;
                }
                case 12: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] | top;
                    continue block18;
                }
                case 13: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] ^ top;
                    continue block18;
                }
                case 8: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] - top;
                    continue block18;
                }
                case 5: {
                    stack[stackDepth - 1] = -stack[stackDepth - 1];
                    continue block18;
                }
                case 6: {
                    continue block18;
                }
                case 4: {
                    stack[stackDepth - 1] = ~stack[stackDepth - 1];
                    continue block18;
                }
                case 10: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] / top;
                    continue block18;
                }
                case 9: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] * top;
                    continue block18;
                }
                case 11: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] % top;
                    continue block18;
                }
                case 15: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] << top;
                    continue block18;
                }
                case 16: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] >> top;
                    continue block18;
                }
                case 17: {
                    int top = stack[--stackDepth];
                    int n = stackDepth - 1;
                    stack[n] = stack[n] >>> top;
                    continue block18;
                }
            }
            throw new Error("Detected unsupported operation, contact developer");
        }
        return stack[0];
    }

    @Override
    public void visitItems(JBBPCompiledBlock block, int currentCompiledBlockOffset, ExpressionEvaluatorVisitor visitor) {
        visitor.visitStart();
        JBBPIntCounter counter = new JBBPIntCounter();
        while (counter.get() < this.compiledExpression.length) {
            byte code = this.compiledExpression[counter.getAndIncrement()];
            switch (code) {
                case 1: 
                case 2: {
                    int index = JBBPUtils.unpackInt(this.compiledExpression, counter);
                    if (code == 2) {
                        if ("$".equals(this.externalValueNames[index])) {
                            visitor.visitSpecial(ExpressionEvaluatorVisitor.Special.STREAM_COUNTER);
                            break;
                        }
                        visitor.visitField(null, this.externalValueNames[index]);
                        break;
                    }
                    visitor.visitField(block.getNamedFields()[index], null);
                    break;
                }
                case 3: {
                    visitor.visitConstant(JBBPUtils.unpackInt(this.compiledExpression, counter));
                    break;
                }
                case 7: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.ADD);
                    break;
                }
                case 14: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.AND);
                    break;
                }
                case 12: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.OR);
                    break;
                }
                case 13: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.XOR);
                    break;
                }
                case 8: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.SUB);
                    break;
                }
                case 5: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.UNARY_MINUS);
                    break;
                }
                case 6: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.UNARY_PLUS);
                    break;
                }
                case 4: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.NOT);
                    break;
                }
                case 10: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.DIV);
                    break;
                }
                case 9: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.MUL);
                    break;
                }
                case 11: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.MOD);
                    break;
                }
                case 15: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.LSHIFT);
                    break;
                }
                case 16: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.RSHIFT);
                    break;
                }
                case 17: {
                    visitor.visitOperator(ExpressionEvaluatorVisitor.Operator.URSHIFT);
                    break;
                }
                default: {
                    throw new Error("Detected unsupported operation, contact developer");
                }
            }
        }
        visitor.visitEnd();
    }

    public String toString() {
        return this.expressionSource;
    }
}

