/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.items.MetadataCommandDescriptionProvider;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.types.StateDescriptionFragment;
import org.openhab.core.types.StateDescriptionFragmentBuilder;
import org.openhab.core.types.StateDescriptionFragmentProvider;
import org.openhab.core.types.StateOption;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={StateDescriptionFragmentProvider.class})
public class MetadataStateDescriptionFragmentProvider
implements StateDescriptionFragmentProvider {
    private final Logger logger = LoggerFactory.getLogger(MetadataStateDescriptionFragmentProvider.class);
    public static final String STATEDESCRIPTION_METADATA_NAMESPACE = "stateDescription";
    private final MetadataRegistry metadataRegistry;
    private final Integer rank;

    /*
     * WARNING - void declaration
     */
    @Activate
    public MetadataStateDescriptionFragmentProvider(@Reference MetadataRegistry metadataRegistry, Map<String, Object> properties) {
        Object serviceRanking;
        this.metadataRegistry = metadataRegistry;
        Object object = serviceRanking = properties.get("service.ranking");
        if (object instanceof Integer) {
            void rankValue;
            Integer n = (Integer)object;
            Integer cfr_ignored_0 = (Integer)object;
            this.rank = rankValue;
        } else {
            this.rank = 1;
        }
    }

    @Override
    public @Nullable StateDescriptionFragment getStateDescriptionFragment(String itemName, @Nullable Locale locale) {
        Metadata metadata = (Metadata)this.metadataRegistry.get(new MetadataKey(STATEDESCRIPTION_METADATA_NAMESPACE, itemName));
        if (metadata != null) {
            try {
                Object readOnly;
                Object step;
                Object max;
                Object min;
                StateDescriptionFragmentBuilder builder = StateDescriptionFragmentBuilder.create();
                Object pattern = metadata.getConfiguration().get("pattern");
                if (pattern != null) {
                    builder.withPattern((String)pattern);
                }
                if ((min = metadata.getConfiguration().get("min")) != null) {
                    builder.withMinimum(this.getBigDecimal(min));
                }
                if ((max = metadata.getConfiguration().get("max")) != null) {
                    builder.withMaximum(this.getBigDecimal(max));
                }
                if ((step = metadata.getConfiguration().get("step")) != null) {
                    builder.withStep(this.getBigDecimal(step));
                }
                if ((readOnly = metadata.getConfiguration().get("readOnly")) != null) {
                    builder.withReadOnly(this.getBoolean(readOnly));
                }
                if (metadata.getConfiguration().containsKey("options")) {
                    List<StateOption> stateOptions = Stream.of(metadata.getConfiguration().get("options").toString().split(",")).map(o -> {
                        if (o.contains("=")) {
                            String[] pair = MetadataCommandDescriptionProvider.parseValueLabelPair(o.trim());
                            return new StateOption(pair[0], pair[1]);
                        }
                        return new StateOption(o.trim(), null);
                    }).toList();
                    builder.withOptions(stateOptions);
                }
                return builder.build();
            }
            catch (Exception e) {
                this.logger.warn("Unable to parse the stateDescription from metadata for item {}, ignoring it", (Object)itemName);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            Object object = value;
            if (object instanceof BigDecimal) {
                void decimal;
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal cfr_ignored_0 = (BigDecimal)object;
                ret = decimal;
            } else {
                Object object2 = value;
                if (object2 instanceof String) {
                    void string;
                    String string2 = (String)object2;
                    String cfr_ignored_1 = (String)object2;
                    ret = new BigDecimal((String)string);
                } else {
                    Object object3 = value;
                    if (object3 instanceof BigInteger) {
                        void integer;
                        BigInteger bigInteger = (BigInteger)object3;
                        BigInteger cfr_ignored_2 = (BigInteger)object3;
                        ret = new BigDecimal((BigInteger)integer);
                    } else {
                        Object object4 = value;
                        if (object4 instanceof Number) {
                            void number;
                            Number number2 = (Number)object4;
                            Number cfr_ignored_3 = (Number)object4;
                            ret = new BigDecimal(number.doubleValue());
                        } else {
                            throw new ClassCastException("Not possible to coerce [" + String.valueOf(value) + "] from class " + String.valueOf(value.getClass()) + " into a BigDecimal.");
                        }
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private Boolean getBoolean(Object value) {
        Boolean ret = null;
        if (value != null) {
            Object object = value;
            if (object instanceof Boolean) {
                void boolean1;
                Boolean bl = (Boolean)object;
                Boolean cfr_ignored_0 = (Boolean)object;
                ret = boolean1;
            } else {
                Object object2 = value;
                if (object2 instanceof String) {
                    void string;
                    String string2 = (String)object2;
                    String cfr_ignored_1 = (String)object2;
                    ret = Boolean.parseBoolean((String)string);
                } else {
                    throw new ClassCastException("Not possible to coerce [" + String.valueOf(value) + "] from class " + String.valueOf(value.getClass()) + " into a Boolean.");
                }
            }
        }
        return ret;
    }

    @Override
    public Integer getRank() {
        return this.rank;
    }
}

